<?php get_header(); ?>

<div id="main-content-wrapper">
	<div id="main-content-full">
		<?php
			//list terms in a given taxonomy (useful as a widget for twentyten)
			$taxonomy = 'project-type';
			$tax_terms = get_terms($taxonomy);	
			$selectedTerm = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
		?>
		<ul class="project-taxonomies">
			<?php
				foreach ($tax_terms as $tax_term) {
					echo '<li';

					if ( $selectedTerm->name == $tax_term->name ) :
			
						echo ' class="selected-taxonomy" ';
			
					endif;

					echo '><a href="' . esc_attr(get_term_link($tax_term, $taxonomy)) . '" title="' . sprintf( __( "View all projects in %s", 'aya'), $tax_term->name ) . '" class="project-taxonomy">' . $tax_term->name.'</a></li>';
				}
			?>
		</ul>
		
		<div class="clear"></div>
		
		<div id="portfolio">
			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>	
					<?php
						$title= str_ireplace('"', '', trim(get_the_title()));
						$desc= str_ireplace('"', '', trim(get_the_content()));
					?>
					<div class="project-cols1-a">
						<a href="<?php the_permalink(); ?>" title="<?php echo $title; ?>"><?php the_post_thumbnail('full'); ?></a>
					</div>
					
					<div class="project-cols1-b">
						<h1 class="project-title"><?php the_title(); ?></h1>
						<div class="project-after-title"></div>
						
						<div class="project-taxonomies-box">
						<?php $taxonomy = 'project-type';
							  $proj_tax_terms = get_the_terms( $post->ID, $taxonomy );

if ( $proj_tax_terms && !is_wp_error( $proj_tax_terms ) ) {

							foreach ($proj_tax_terms as $proj_tax_term) {

								echo '<a href="#" class="project-taxonomy" data-taxonomy="'.$proj_tax_term->slug.'" title="'.$proj_tax_term->name.'">'.$proj_tax_term->name.'</a></li>';
			
								if ( $proj_tax_term !== end($proj_tax_terms) ) {
									
										echo ', ';
								}
							 }

								}



						?>
						</div>

						<?php the_content(); ?>
						
						<?php $site = get_post_custom_values('projLink'); ?>
						<?php if ( $site[0] != "" ) : ?>
						
						
							<a href="<?php echo $site[0]; ?>" title="<?php _e('View Project', 'aya') ?>" target="_blank" class="project-view-project">
								<button><?php _e('View Project', 'aya') ?></button>
							</a>
						
						<?php endif; ?>
						
						<a href="<?php the_permalink(); ?>" title="<?php _e('Read More', 'aya') ?>" class="project-read-more">
							<button><?php _e('Read More', 'aya') ?></button>
						</a>		
					</div>
					
					<div class="clear">
					</div>
			<?php endwhile; endif; ?> 
		</div>
	</div>
</div>
<?php get_footer(); ?>