<?php
/**
 * The template for displaying social sharing box
 *
 * Used for single posts and costom post formats contents.
 *
 * Note: before including it check if is single and if show social sharing box is set to be shown after single posts
 *
 */
?>
<h4 class="social-sharing-title">
	<?php if ( is_single() ) :

				_e( 'Share this post on', 'aya' );

		  else :
		  
				_e( 'Share this page on', 'aya' );

		endif;
	?>
</h4>
<div class="social-sharing-after-title">
</div>
<div class="social-sharing-box">

	<ul class="social-widget">

		<li><a class="fa social-share-icon fa-facebook" href="https://www.facebook.com/dialog/feed?
  app_id=145634995501895
  &amp;display=popup&amp;caption=<?php echo urlencode( get_the_title() ); ?> 
  &amp;link=<?php echo urlencode( get_the_permalink() ); ?>
  &amp;redirect_uri=https://developers.facebook.com/tools/explorer" title="<?php _e( 'Share this post on Facebook', 'aya' ); ?>" target="_blank"></a></li>

		<li><a class="fa social-share-icon fa-google-plus" target="_blank" href="https://plus.google.com/share?url=<?php the_permalink(); ?>" title="<?php _e( 'Share this post on Google+', 'aya' ); ?>"></a></li>
		
		<li><a class="fa social-share-icon fa-twitter" href="http://twitter.com/home?status=Reading:%20<?php the_permalink(); ?>" title="<?php _e( 'Share this post on Twitter', 'aya' ); ?>" target="_blank"></a></li>
		
		<li><a class="fa social-share-icon fa-linkedin" href="http://www.linkedin.com/shareArticle?mini=true&amp;title=<?php echo urlencode( get_the_title() ); ?>&amp;url=<?php the_permalink(); ?>" title="<?php _e( 'Share this post on LinkedIn', 'aya' ); ?>" rel="external nofollow" target="_blank"></a></li>
		
		<li><a class="fa social-share-icon fa-reddit" href="http://www.reddit.com/submit?url=<?php the_permalink(); ?>&amp;title=<?php echo urlencode( get_the_title() ); ?>" title="<?php _e( 'Share this post on Reddit', 'aya' ); ?>" rel="nofollow" target="_blank"></a></li>

		<li><a class="fa social-share-icon fa-stumbleupon" href="http://www.stumbleupon.com/submit?url=<?php the_permalink(); ?>&amp;title=<?php echo urlencode( get_the_title() ); ?>" title="<?php _e( 'Share this post on StumbleUpon', 'aya' ); ?>" rel="nofollow" target="_blank"></a></li>
		
		<li><a class="fa social-share-icon fa-digg" href="http://digg.com/submit?url=<?php the_permalink(); ?>&amp;title=<?php echo urlencode( get_the_title() ); ?>" title="<?php _e( 'Share this post on Digg', 'aya' ); ?>" rel="nofollow" target="_blank"></a></li>
	
		<li><a class="fa social-share-icon fa-delicious" href="http://del.icio.us/post?url=<?php the_permalink(); ?>&amp;title=<?php echo urlencode( get_the_title() ); ?>" title="<?php _e( 'Bookmark this post on del.icio.us', 'aya' ); ?>" rel="nofollow" target="_blank"></a></li>
		
	</ul>
	<div class="clear">
	</div>
</div>