<?php get_header(); ?>

<div id="main-content-wrapper">
	<div id="main-content-full">

	<?php if (have_posts()) :

			while ( have_posts() ) :
			
				the_post();
	?>		
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<h1 class="entry-title">
						<?php the_title(); ?>
					</h1>

					<?php
						$title= str_ireplace('"', '', trim(get_the_title()));
						$desc= str_ireplace('"', '', trim(get_the_content()));
					?>
					<div class="single-project-col1">
						<?php the_post_thumbnail('full'); ?>
					</div>
					
					<div class="single-project-col2">
					
						<h3 class="sidebar-title"><?php _e('Project Description', 'aya') ?></h3>
						<div class="sidebar-after-title"></div>
						<?php the_content(); ?>
						
						<h3 class="sidebar-title"><?php _e('Project Details', 'aya') ?></h3>
						<div class="sidebar-after-title"></div>
						
						<ul class="project-details">
							<?php $taxonomy = 'project-type';
								  $tax_terms = get_the_terms( $post->ID, $taxonomy );

								  if (sizeof($tax_terms) > 1) : ?>				  
									<li>
										<span><?php _e('Category:', 'aya') ?></span>
										
										<?php foreach ($tax_terms as $tax_term) {
											
												echo '<a href="' . esc_attr(get_term_link($tax_term, $taxonomy)) . '" title="' . sprintf( __( "View all projects in %s", 'aya'), $tax_term->name ) . '" ' . '>' . $tax_term->name.'</a>';
							
												if ( $tax_term !== end($tax_terms) ) {
													
														echo ', ';
												}
											 }
										?>
									
									</li>
							<?php endif; ?>
							
							<li>
								<span><?php _e('Date:', 'aya') ?></span>							
								<time datetime="<?php the_time( 'Y-m-d' ); ?>"><?php the_time(get_option('date_format')); ?></time>
							</li>
							
							<?php $client = get_post_custom_values('projClient'); ?>
							<?php if ( $client[0] != "" ) : ?>
							
								<li>
									<span><?php _e('Client:', 'aya') ?></span>
									<?php echo $client[0]; ?>
								</li>
							
							<?php endif; ?>
							
							<?php $company = get_post_custom_values('projCompany'); ?>
							<?php if ( $company[0] != "" ) : ?>
							
								<li>
									<span><?php _e('Company:', 'aya') ?></span>
									<?php echo $company[0]; ?>
								</li>
							
							<?php endif; ?>

							<?php $site = get_post_custom_values('projLink'); ?>
							<?php if ( $site[0] != "" ) : ?>
							
								<li>
									<span><?php _e('Project URL:', 'aya') ?></span>
									
									<a href="<?php echo $site[0]; ?>" target="_blank"><?php echo $site[0]; ?></a>
								</li>
							
							<?php endif; ?>						
						</ul>				
					</div>
					
					<div class="clear">
					</div>
				</article>
	<?php		
				endwhile;
	?>
	<?php else :

				// if no content is loaded, show the 'no found' template
				get_template_part( 'content', 'none' );

		  endif; ?>
		  
		<div class="clear">
		</div>
		
		<div class="additional-content">
			<?php the_widget('aya_Display_Projects_Widget',
										array( 'title' => __('Recent Projects', 'aya') ),
										array ('before_title' => '<h3 class="home-title">',
											   'after_title' => '</h3><div class="home-after-title"></div>')
											  );
			?>
		</div>
		  
	</div>
</div>
<?php get_footer(); ?>