<?php
/*

Template Name: Page with Widget Areas

*/

?>
<?php get_header(); ?>

<div id="main-content-wrapper">
	<div id="main-content">
	<h1><?php wp_title(''); ?></h1>
	<?php if ( have_posts() ) :
			
			while ( have_posts() ) :
			
				the_post(); ?>
				
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="clear">
						<?php // show widget before single page content
							  dynamic_sidebar( 'before-single-page-content-widget-area' ); ?>
					</div>
					<div class="custom-content">
						<?php
							if ( has_post_thumbnail() ) {

								the_post_thumbnail('full');
							}
							the_content( __( 'Read More...', 'aya' ) );
						?>
					</div>
					<div class="clear">
						<?php // show widget after single page content
							  dynamic_sidebar( 'after-single-page-content-widget-area' ); ?>
					</div>
					<div class="custom-after-content">
						<?php aya_author_link(); ?>
						<?php if ('open' == $post->comment_status) : ?>
							<?php if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>

<span class="comments-icon">
			<?php comments_popup_link(__( 'No Comments', 'aya' ), __( '1 Comment', 'aya' ), __( '% Comments', 'aya' ), '', __( 'Comments are closed.', 'aya' )); ?>
		</span>
<?php endif; ?>
						<?php endif; ?>
						<?php edit_post_link( __( 'Edit', 'aya' ), '<span class="edit-icon">', '</span>' ); ?>
					</div>
				</article>

	<?php		// if comments are open or there's at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) {
					comments_template();
				}
			
			endwhile;
				
		  else : 
		  
			// if no content is loaded, show the 'no found' template
			get_template_part( 'content', 'none' );
	 
		  endif; ?>
	</div>

	<?php get_sidebar(); ?>
</div>
<?php get_footer(); ?>