<?php
/*

Template Name: Sitemap Page

*/
?>
<?php get_header(); ?>

<div id="main-content-wrapper">
	<div id="main-content">
	<h1><?php wp_title(''); ?></h1>
	<?php if ( have_posts() ) :

			while ( have_posts() ) :
			
					the_post();			
	?>

				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="custom-content">
						<?php
							if ( has_post_thumbnail() ) {

								the_post_thumbnail('full');
							}
							the_content( __( 'Read More...', 'aya' ) );
						?>
					</div>
					
					<div class="clear">
					</div>
					
					<h2 id="authors"><?php _e( 'Authors', 'aya' ); ?></h2>
					<ul>
						<?php wp_list_authors(array( 'exclude_admin' => false)); ?>
					</ul>	 
					<h2 id="pages"><?php _e( 'Pages', 'aya' ); ?></h2>
					<ul>
						<?php wp_list_pages(array( 'exclude' => '','title_li' => '' )); ?>
						
						<?php wp_link_pages( array(
											'link_before'      => '<li>',
											'link_after'       => '</li>',
										) ); ?>
					</ul>
					<h2 id="posts"><?php _e( 'Posts', 'aya' ); ?></h2>
					<ul>
						<?php $archive_query = new WP_Query( 'showposts=1000' );
							while ($archive_query->have_posts()) : $archive_query->the_post(); ?>
							  <li><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></li>
						<?php endwhile; ?>
					</ul>
					
					<?php // Restore global post data stomped by the_post()
						  wp_reset_query(); ?>
			
					<div class="custom-after-content">
						<?php edit_post_link( __( 'Edit', 'aya' ), '<span class="edit-icon">', '</span>' ); ?>
					</div>
				</article>
	<?php
				// if comments are open or there's at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) {
					comments_template();
				}

			endwhile;

		  else :

			// if no content is loaded, show the 'no found' template
			get_template_part( 'content', 'none' );

		  endif; ?>
	</div>

	<?php get_sidebar(); ?>
</div>
<?php get_footer(); ?>