<?php
/*

Template Name: Portfolio 2 Columns

*/

?>
<?php get_header(); ?>

<?php
	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	
	$postsPerPage = get_option('posts_per_page');
	
	$selectedTaxony = 'all';
	if ( isset( $_POST[ 'selected-taxonomy' ] )
		 && trim( $_POST[ 'selected-taxonomy' ] ) !== ''
		 && trim( $_POST[ 'selected-taxonomy' ] ) !== 'all' ) {

			$selectedTaxony = trim( $_POST[ 'selected-taxonomy' ] );

			$projectsFilter = esc_sql("post_type=project&posts_per_page=$postsPerPage&project-type=$selectedTaxony&paged=$paged");
		
			query_posts($projectsFilter);

	} else {
	
		query_posts('post_type=project&posts_per_page='.$postsPerPage.'&paged=' . $paged);
	}
?>



<div id="main-content-wrapper">
	<div id="main-content-full">

		<h1 class="entry-title">
			<?php the_title(); ?>
		</h1>

	<?php
		//list terms in a given taxonomy (useful as a widget for twentyten)
		$taxonomy = 'project-type';
		$tax_terms = get_terms($taxonomy);
	?>
		<form action="<?php the_permalink(); ?>" id="taxonomy-filter-form" method="post">
			<input type="hidden" name="selected-taxonomy" />
		</form>
		<ul class="project-taxonomies">
			<li
			<?php if ( $selectedTaxony == 'all' ) :
			
					echo ' class="selected-taxonomy" ';
			
				  endif; ?>>
			<a href="#" title="<?php _e('All', 'aya'); ?>" data-taxonomy="all" class="project-taxonomy"><?php _e('All', 'aya'); ?></a></li>
			<?php
				foreach ($tax_terms as $tax_term) {
				
					echo '<li';
					
					if ($tax_term->slug == $selectedTaxony) {
					
						echo ' class="selected-taxonomy" ';
						
					}

					echo '><a href="#" data-taxonomy="'.$tax_term->slug.'" title="'.$tax_term->name.'" class="project-taxonomy">'.$tax_term->name.'</a></li>';
				}
			?>
		</ul>
		
		<div class="clear"></div>
	
		<div id="portfolio">
			<?php $projNumber = 0; ?>
			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>	
					<?php
						++$projNumber;
						$title= str_ireplace('"', '', trim(get_the_title()));
						$desc= str_ireplace('"', '', trim(get_the_content()));
					?>
					<div class="project-cols2">
						<div class="project-col-image">
							<a href="<?php the_permalink(); ?>" title="<?php echo $title; ?>"><?php the_post_thumbnail('full'); ?></a>
						</div>
						<h1><?php the_title(); ?></h1>
						<div class="project-col-taxonomies-box">
							<?php $taxonomy = 'project-type';
								  $proj_tax_terms = get_the_terms( $post->ID, $taxonomy );
								
								if ( $proj_tax_terms && !is_wp_error( $proj_tax_terms ) ) {

									foreach ($proj_tax_terms as $proj_tax_term) {

									echo '<a href="#" class="project-taxonomy" data-taxonomy="'.$proj_tax_term->slug.'" title="'.$proj_tax_term->name.'">'.$proj_tax_term->name.'</a></li>';
				
									if ( $proj_tax_term !== end($proj_tax_terms) ) {
										
											echo ', ';
									}
								 }
								}



							?>
						</div>
						<div class="project-col-read-more">
							<a href="<?php the_permalink(); ?>" title="<?php _e('Read More', 'aya') ?>" class="project-read-more">
								<button><?php _e('Read More', 'aya') ?></button>
							</a>
						</div>
					</div>

					<?php if ( $projNumber % 2 == 0 ) : ?>
					
							<div class="clear">
							</div>
					
					<?php endif; ?>
			<?php endwhile; endif; ?>
			<div class="clear">
			</div>
		</div>
		<?php	
			the_posts_pagination( array(
                        'prev_next' => '',
                    ) );
		?>
	</div>
</div>
<script>
	jQuery( document ).ready( function() {

		jQuery( "a.project-taxonomy" ).click(function() {

			var curTaxonomy = jQuery(this).data('taxonomy');
		
			jQuery( "input[name='selected-taxonomy']" ).val(curTaxonomy);

			jQuery('#taxonomy-filter-form').submit();		
		});
	});
</script>
<?php get_footer(); ?>