<?php
/*

Template Name: Landing Page 4

*/

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo('charset'); ?>" />
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
		<meta name="viewport" content="width=device-width" />
		<?php aya_head_load_scripts();
			  wp_head(); ?>
	
    </head>

	<body <?php body_class(); ?>

	<?php if ( has_post_thumbnail() ) : ?>

			style="background-image: url('<?php the_post_thumbnail_url( 'full' ); ?>');"


	<?php else : ?>

			style="background-color:#CCCCCC;"

	<?php endif; ?>>

			<header id="header-main-fixed">
				<div id="header-content-wrapper" class="header-content-spacing">
					<?php aya_show_header_top(); ?>
					<div>
						<?php aya_shopping_cart(); ?>
					</div>
					<div class="clear">
					</div>
					<div id="header-logo">
						<?php aya_show_website_logo_image_and_title(); ?>
					</div><!-- #header-logo -->
					<nav id="navmain">
						<?php wp_nav_menu( array( 'theme_location' => 'primary', ) ); ?>
						<div class="clear">
						</div>
					</nav><!-- #navmain -->
					
					<div class="clear">
					</div>
				</div><!-- #header-content-wrapper -->
			</header><!-- #header-main-fixed -->
			
			<div class="clear">
			</div>

			<div id="main-content-wrapper-landing">

			<div id="progress"
				data-0="width:0%;background:hsl(0, 0%, 7.8%);"
				data-end="width:100%;background:hsl(0, 0%, 20%);">
			</div>

			<nav id="landing-dots">
				<a href="#intro" data-menu-top="0" class="active"></a>
			</nav>

				<?php if ( have_posts() ) :
				
						while ( have_posts() ) :
						
							the_post(); ?>
					
							<div id="landing-page-content">

							<div id="intro"
								data-0="opacity:1;top:3%;transform:rotate(0deg);transform-origin:0 0;"
								data-500="opacity:0;top:-10%;transform:rotate(-90deg);">
								<h1><?php echo get_the_title(); ?></h1>
							</div>

							<?php
								// includes the single page content templata here
								the_content();
							?>

							</div>

							<?php

								// if comments are open or there's at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) {
									comments_template();
								} ?>
					
					<?php endwhile;
					
			  else : 
			  
				// if no content is loaded, show the 'no found' template
				get_template_part( 'content', 'none' );
		 
			  endif; ?>

		  	
	</div>

	<?php
		wp_enqueue_script( 'tisho-skrollr-js', get_template_directory_uri() . '/js/skrollr.min.js', array( 'jquery' ) );
	?>
	<!--[if lt IE 9]>
	<script type="text/javascript" src="../skrollr-ie/dist/skrollr.ie.min.js"></script>
	<![endif]-->

	<script type="text/javascript">

		jQuery(function() {

			let marginTop = jQuery('#header-main-fixed').height() + 50 + 'px';

			jQuery('#intro').css('margin-top', marginTop);

			let elements = jQuery("#landing-page-content > p")
				.filter(function( index ) {
			    	let text = jQuery(this).text();
			    	return (jQuery.trim(text).length > 0);
  				});

			var contentsLength = elements.length;

  			elements.each(function(index){

			let startTime = index * 2000;

				let time1 = startTime,
					time2 = time1 + 500,
					time3 = time2 + 500,
					time4 = time3 + 500;

				if (index < contentsLength - 1) {

					jQuery(this).wrap('<div class="easing_wrapper" data-' + time1 + '="display:block;" data-' + time2 + '="top:10%;" data-' + time3 + '="top:10%;" data-' + time4 + '="top:-100%;"><div class="easing-right" data-' + time1 + '="right:100%" data-' + time2 + '="right:10%;"></div></div>');

					jQuery('#landing-dots').append('<a href="#landing-content-' + index + '" data-menu-top="' + time2 + '"></a>');

				} else {

					jQuery(this).wrap('<div id="last-element" data-' + time1 +'="top[cubic]:100%;" data-' + time2 + '="top:20%;background:rgb(255,255,255);border-width:10px;"></div>');

					jQuery('#landing-dots').append('<a href="#last-element" data-menu-top="' + time2 + '"></a>');
				}
			});

			var s = skrollr.init({
				edgeStrategy: 'set',
				easing: {
					WTF: Math.random,
					inverted: function(p) {
						return 1-p;
					}
				}
			});

			skrollr.menu.init(s, {
    				updateUrl: false //defaults to `true`.
			});

		});

		jQuery(window).scroll(function(){

			jQuery('#landing-page-content > div').each(function(i) {
			            if (jQuery(this).css("opacity") == '1' 
			            	&& jQuery(this).css("top").charAt(0) != '-') {
			            	
			                jQuery('#landing-dots a.active').removeClass('active');
			                jQuery('#landing-dots a').eq(i).addClass('active');
			            
			            	return false;
			            }
			        });
		});
	
	</script>


<a href="#" class="scrollup"></a>
<?php wp_footer(); ?>
	</body>
</html>