<?php
/*

Template Name: Contact Page

*/

?>
<?php

	$captcha_correct = false;
	$name = '';
	$email = '';
	$subject = '';
	$comments = '';
	$isReallySimpleCaptchaExist = class_exists('ReallySimpleCaptcha');

	if ( class_exists('ReallySimpleCaptcha') ) {

		$captcha = new ReallySimpleCaptcha();

		if ( !empty($_POST) ) {
				
			if ($captcha -> check( $_POST['captcha_prefix'], $_POST['captcha_code'] ) ) {
				$captcha_correct = true;
			}
		}
	}

	if ( isset($_POST[ 'submitted' ] ) ) {
		if ( trim($_POST[ 'contactName' ] ) === '' ) {
			$nameError = __( 'Please enter your name.', 'aya' );
			$hasError = true;
	    } else {
			$name = trim( $_POST[ 'contactName' ] );
		}

		if ( trim( $_POST[ 'email' ] ) === '' )  {
			$emailError = __( 'Please enter your email address.', 'aya' );
			$hasError = true;
		} else if ( !preg_match("/^[[:alnum:]][a-z0-9_.-]*@[a-z0-9.-]+\.[a-z]{2,4}$/i", trim( $_POST[ 'email' ] ) ) ) {
			$emailError = __( 'You entered an invalid email address.', 'aya' );
			$hasError = true;
		} else {
			$email = trim($_POST[ 'email' ]);
		}
		
		if (trim( $_POST[ 'comments' ] ) === '' ) {
			$commentError = __( 'Please enter a message.', 'aya' );
			$hasError = true;
		} else {
			if ( function_exists( 'stripslashes' ) ) {
				$comments = stripslashes( trim($_POST[ 'comments' ] ) );
			} else {
				$comments = trim( $_POST[ 'comments' ] );
			}
		}
		if ( $isReallySimpleCaptchaExist && $captcha_correct != true ) {

			$captchaError = __( 'The captcha code you filled in is correct!', 'aya' ) . '<br />';
			$hasError = true;
		}
		$subject = trim( $_POST[ 'subject' ] );

		if ( !isset( $hasError ) ) {
			$emailTo = get_option( 'admin_email' );
			//t $subject = trim( $_POST[ 'subject' ] );
			$body = __( 'From', 'aya' ).': '.$name." \n\n".
					__( 'Email', 'aya' ).': '.$email." \n\n".
					__( 'Subject', 'aya' ).': '.$subject." \n\n".
					__( 'Message Body', 'aya' ).":\n".$comments." \n\n--\n".
					__( 'This e-mail was sent from a contact form on', 'aya' ).' '.get_bloginfo( 'name' ).' ( '.home_url('/').' )';

			$headers = 'From: '.$name.' <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;

			wp_mail( $emailTo, __( '[Contact Form] ', 'aya' ).$subject, $body, $headers );
			$emailSent = true;

			$name = '';
			$email = '';
			$subject = '';
			$comments = '';
		}
	}
?>
<?php get_header(); ?>

<div id="main-content-wrapper">
	<div class="top-widget">
		<?php dynamic_sidebar( 'contacts-top-widget-area' ); ?>
	</div>
		
	<div id="main-content">
		<h1><?php wp_title(''); ?></h1>
		<?php if ( have_posts() ) :		
					while ( have_posts() ) :			
						the_post(); ?>		
						<div class="page-content">
							<?php
								if ( has_post_thumbnail() ) {

									the_post_thumbnail('full');
								}
								the_content( __( 'Read More...', 'aya' ) );
							?>
						</div>
						<div class="page-after-content">
							<?php edit_post_link( __( 'Edit', 'aya' ), '<span class="edit-icon">', '</span>' ); ?>
						</div>		
			  <?php endwhile;
		  endif; ?>
		<div class="clear">
		</div>
		<form action="<?php the_permalink(); ?>" id="contact-form" method="post">
			<p class="contact-form-author">
				<input required type="text" name="contactName" id="contactName" size="40" placeholder="<?php _e( 'Name', 'aya' ); ?>" value="<?php echo $name; ?>" />
				<?php if (isset($hasError) && isset($nameError)) { 
					echo "<span class='contact-error'>$nameError</span>";
				}?>
			</p>
			<p class="contact-form-email">
				<input required placeholder="<?php _e( 'Email', 'aya' ); ?>" type="text" name="email" id="email" size="40" value="<?php echo $email; ?>" />
				<?php if (isset($hasError) && isset($emailError)) { 
					echo "<span class='contact-error'>$emailError</span>";
				}?>
			</p>
			<p class="contact-form-subject">
				<input placeholder="<?php _e( 'Subject', 'aya' ); ?>" type="text" name="subject" id="subject" size="40" value="<?php echo $subject; ?>" />
			</p>
			<p class="contact-form-message">
				<textarea required placeholder="<?php _e( 'Message', 'aya' ); ?>" name="comments" id="commentsText" rows="10" cols="40"><?php echo $comments; ?></textarea>
				<?php if (isset($hasError) && isset($commentError)) { 
					echo "<span class='contact-error'>$commentError</span>";
				}?>
			</p>
			<?php if ( $isReallySimpleCaptchaExist ) { ?>

					<p>
						<?php if ( isset($hasError) && isset($captchaError) ) {
							
								echo '<span class="contact-error">'.$captchaError.'</span>';
						}?>
						<?php
							$captcha_word = $captcha -> generate_random_word();
							$captcha_prefix = mt_rand();
							$captcha_image = $captcha -> generate_image($captcha_prefix, $captcha_word);
							$captcha_file = rtrim(site_url(), '/') . '/wp-content/plugins/really-simple-captcha/tmp/' . $captcha_image;
						?>
						<?php _e('Please fill in the code below', 'aya'); ?><br />
						<img src="<?php echo $captcha_file; ?>" /><br />
						<input type="text" name="captcha_code" required />
						<input type="hidden" name="captcha_prefix" value="<?php echo $captcha_prefix; ?>" />
					</p>

			<?php } ?>
			<p>
				<button type="submit"><?php _e( 'Send Message', 'aya' ); ?></button>
			</p>
			<input type="hidden" name="submitted" id="submitted" value="true" />
		</form>
		<?php if ( isset($_POST[ 'submitted' ]) && !isset( $hasError ) && isset( $emailSent ) && $emailSent ) { ?>
				<p class="contact-success">
					<?php _e( 'Your message was sent successfully. Thanks.', 'aya' ); ?>
				</p>
		<?php } ?>
	</div>

	<?php get_sidebar('contacts'); ?>
</div>
<?php get_footer(); ?>