<?php

/*
 * Recent Posts Displayed in Slider Widget Class
 */
class aya_Recent_Posts_Slider_Widget extends WP_Widget {

	function __construct() {
		parent::__construct('recent-posts-slider', __('Recent Posts Slider Widget', 'aya'), 
							array( 'classname' => 'widget_recent_posts_slider_entries',
							       'description' => __( "Your site&#8217;s most recent Posts displayed in a Slider.", 'aya') )
						    );
		$this->alt_option_name = 'widget_recent_posts_slider_entries';

		add_action( 'save_post', array($this, 'flush_widget_recent_posts_slider_cache') );
		add_action( 'deleted_post', array($this, 'flush_widget_recent_posts_slider_cache') );
		add_action( 'switch_theme', array($this, 'flush_widget_recent_posts_slider_cache') );
	}

	function widget($args, $instance) {
		$cache = wp_cache_get('widget_recent_posts_slider', 'widget');

		if ( !is_array($cache) )
			$cache = array();

		if ( ! isset( $args['widget_id'] ) )
			$args['widget_id'] = $this->id;

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();
		extract($args);

		$title = ( array_key_exists( 'title', $instance ) && !empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Posts', 'aya' );
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$displayExcerpt = ( array_key_exists( 'display_excerpt', $instance ) && !empty( $instance['display_excerpt'] ) ) ? $instance['display_excerpt'] : false;

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 10;
		if ( ! $number )
 			$number = 10;

		$r = new WP_Query( apply_filters( 'widget_posts_args',
										  array( 'posts_per_page'      => $number,
												 'no_found_rows'       => true,
												 'post_status'         => 'publish',
												 'ignore_sticky_posts' => true,
												 'post_type' => 'post', 
												)
										) );
		if ($r->have_posts()) :
?>
		<?php echo $before_widget; ?>
		<?php if ( $title ) echo $before_title . $title . $after_title; ?>

		<ul class="jcarousel jcarousel-skin">

		<?php while ( $r->have_posts() ) : $r->the_post(); ?>

				<li class="slide">

					<?php echo '<h1 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark" title="'.get_the_title().'">'.get_the_title().'</a></h1>'; ?>

					<?php // Display Thumbnails if enabled from settings and if thumbnail is set for the post
						if ( has_post_thumbnail() ) {

							echo '<a href="'.get_permalink().'" title="'.get_the_title().'">';

							the_post_thumbnail();

							echo '</a>';
						}
					?>

					<?php if ( $displayExcerpt ) {

							the_excerpt();

						} ?>
					<div class="recent-posts-slider-after-content">
						<?php aya_author_link(); ?>
						<?php if ( !is_single() && get_the_title() === '' ) : ?>

							<span class="clock-icon">
								<a href="<?php the_permalink(); ?>" rel="bookmark">
									<time datetime="<?php the_time( 'Y-m-d' ); ?>"><?php the_time(get_option('date_format')); ?></time>
								</a>
							</span>
		
						<?php else : ?>

							<span class="clock-icon">
								<time datetime="<?php the_time( 'Y-m-d' ); ?>"><?php the_time(get_option('date_format')); ?></time>
							</span>
				
						<?php endif; ?>
					</div>
				</li>

		<?php endwhile; ?>

		</ul>

		<?php echo $after_widget; ?>
<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;

		$cache[$args['widget_id']] = ob_get_flush();
		wp_cache_set('widget_recent_posts_slider', $cache, 'widget');
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$instance['display_excerpt'] = $new_instance['display_excerpt'];
		
		$this->flush_widget_recent_posts_slider_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_recent_posts_slider_entries']) )
			delete_option('widget_recent_posts_slider_entries');

		return $instance;
	}

	function flush_widget_recent_posts_slider_cache() {
		wp_cache_delete('widget_recent_posts_slider', 'widget');
	}

	function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'Recent Posts', 'aya' );
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		$displayExcerpt    = isset( $instance['display_excerpt'] ) ? $instance['display_excerpt'] : false;
?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of Posts to show:', 'aya' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>

		<p>
		    <input class="checkbox" type="checkbox" <?php checked( $displayExcerpt, 'on'); ?> id="<?php echo $this->get_field_id('display_excerpt'); ?>" name="<?php echo $this->get_field_name('display_excerpt'); ?>" /> 
		    <label for="<?php echo $this->get_field_id('display_excerpt'); ?>">Display Posts Excerpt</label>
		</p>
<?php
	}
}

/**
 * Offices Contacts Widget class
 */
class aya_OfficesContacts_Widget extends WP_Widget {

	function __construct() {
	parent::__construct(
		// Base ID of Offices Contacts widget
		'aya_OfficesContacts_Widget', 

		// Offices Contacts Widget name will appear in UI
		__( 'Offices Contacts', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Displays Contact Information about Offices', 'aya' )) 
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {
		$title = apply_filters( 'widget_title', array_key_exists( 'title', $instance ) ? $instance[ 'title' ] : '' );
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];
		
		if (!empty($title)) {
			echo $args[ 'before_title' ].$title.$args[ 'after_title' ];
		}

		// displays information about all offices
		for ( $i = 1; $i <= 20; ++$i ) {
		
			$officeNameKey = 'name_'.$i;
			$officeAddressKey = 'address_'.$i;
			$officeAddress2Key = 'address2_'.$i;
			$officePhone1Key = 'phone1_'.$i;
			$officePhone2Key = 'phone2_'.$i;
			$officeEmailKey = 'email_'.$i;
		
			$officeName =  array_key_exists( $officeNameKey, $instance ) ? $instance[ $officeNameKey ] : '';
			$officeAddress = array_key_exists( $officeAddressKey, $instance ) ? $instance[ $officeAddressKey ] : '';
			$officeAddress2 = array_key_exists( $officeAddress2Key, $instance ) ? $instance[ $officeAddress2Key ] : '';
			$officePhone1 = array_key_exists( $officePhone1Key, $instance ) ? $instance[ $officePhone1Key ] : '';
			$officePhone2 = array_key_exists( $officePhone2Key, $instance ) ? $instance[ $officePhone2Key ] : '';
			$officeEmail = array_key_exists( $officeEmailKey, $instance ) ? $instance[ $officeEmailKey ] : '';
			
			if (!empty($officeName) || !empty($officeAddress) || !empty($officePhone1) || !empty($officePhone2) || !empty($officeEmail)) {
	
				echo '<div class="office-info-box">';

				if ( !empty($officeName) ) {

					echo '<strong>'.$officeName.'</strong>';
				}
				
				// show office address
				if ( !empty($officeAddress) || !empty($officeAddress2) ) {

					echo '<p><i class="fa fa-map-marker"></i> ';
					if ( !empty($officeAddress) ) {
						echo $officeAddress;
					}

					if ( !empty($officeAddress2) ) {
						if ( !empty($officeAddress) ) {
							echo '<br />';
						}
						echo $officeAddress2;
					}
					echo '</p>';
				}

				// show office phone1
				if ( !empty($officePhone1) ) {
					
					echo '<p><i class="fa fa-phone"></i> '.$officePhone1.'</p>';
				}
				
				// show office phone2
				if ( !empty($officePhone2) ) {
					
					echo '<p><i class="fa fa-phone"></i> '.$officePhone2.'</p>';
				}

				// show office email
				if ( !empty($officeEmail) ) {
					
					echo '<p><i class="fa fa-envelope"></i> ';
					echo '<a href="mailto:'.antispambot($officeEmail, 1).'" title="'.$officeEmail.'">'.$officeEmail.'</a>';
					echo '</p>';
				}
				
				echo '</div>';
			}
		}

		echo $args[ 'after_widget' ];
	}
		
	// Widget Backend
	public function form($instance) {
	
		// title
		if (isset($instance[ 'title' ])) {
			$title = $instance[ 'title' ];
		} else {
			$title = '';
		}

		// Widget admin form
?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
				name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"
				value="<?php echo esc_attr($title); ?>" />
		</p>		
<?php
		// displays information about all offices
		for ( $i = 1; $i <= 20; ++$i ) {
		
			$officeNameKey = 'name_'.$i;
			$officeAddressKey = 'address_'.$i;
			$officeAddress2Key = 'address2_'.$i;
			$officePhone1Key = 'phone1_'.$i;
			$officePhone2Key = 'phone2_'.$i;
			$officeEmailKey = 'email_'.$i;

			$officeName =  isset($instance[ $officeNameKey ]) ? $instance[ $officeNameKey ] : '';
			$officeAddress = isset($instance[ $officeAddressKey ]) ? $instance[ $officeAddressKey ] : '';
			$officeAddress2 = isset($instance[ $officeAddress2Key ]) ? $instance[ $officeAddress2Key ] : '';
			$officePhone1 = isset($instance[ $officePhone1Key ]) ? $instance[ $officePhone1Key ] : '';
			$officePhone2 = isset($instance[ $officePhone2Key ]) ? $instance[ $officePhone2Key ] : '';
			$officeEmail = isset($instance[ $officeEmailKey ]) ? $instance[ $officeEmailKey ] : '';
?>	
			<p>
				<label for="<?php echo $this->get_field_id( $officeNameKey ); ?>"><?php echo sprintf( __( 'Office #%s Name', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( $officeNameKey ); ?>"
					name="<?php echo $this->get_field_name( $officeNameKey ); ?>" type="text"
					value="<?php echo esc_attr($officeName); ?>"
					placeholder="Office Name" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( $officeAddressKey ); ?>"><?php echo sprintf( __( 'Office #%s Address 1', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( $officeAddressKey ); ?>"
					name="<?php echo $this->get_field_name( $officeAddressKey ); ?>" type="text"
					value="<?php echo esc_attr($officeAddress); ?>"
					placeholder="1111 Main Street" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( $officeAddress2Key ); ?>"><?php echo sprintf( __( 'Office #%s Address 2', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( $officeAddress2Key ); ?>"
					name="<?php echo $this->get_field_name( $officeAddress2Key ); ?>" type="text"
					value="<?php echo esc_attr($officeAddress2); ?>"
					placeholder="Anytown, USA" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( $officePhone1Key ); ?>"><?php echo sprintf( __( 'Office #%s Phone No.1', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( $officePhone1Key ); ?>"
					name="<?php echo $this->get_field_name( $officePhone1Key ); ?>" type="text"
					value="<?php echo esc_attr($officePhone1); ?>"
					placeholder="1.111.111.111" />
			</p>	
			<p>
				<label for="<?php echo $this->get_field_id( $officePhone2Key ); ?>"><?php echo sprintf( __( 'Office #%s Phone No.2', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( $officePhone2Key ); ?>"
					name="<?php echo $this->get_field_name( $officePhone2Key ); ?>" type="text"
					value="<?php echo esc_attr($officePhone2); ?>"
					placeholder="1.222.222.222" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( $officeEmailKey ); ?>"><?php echo sprintf( __( 'Office #%s Email', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( $officeEmailKey ); ?>"
					name="<?php echo $this->get_field_name( $officeEmailKey ); ?>" type="text"
					value="<?php echo esc_attr($officeEmail); ?>"
					placeholder="office@example.com" />
			</p>
<?php		
		}
	}
	
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance[ 'title' ] = (!empty( $new_instance[ 'title' ])) ? strip_tags($new_instance[ 'title' ]) : '';
		
		for ( $i = 1; $i <= 20; ++$i ) {
		
			$officeNameKey = 'name_'.$i;
			$officeAddressKey = 'address_'.$i;
			$officeAddress2Key = 'address2_'.$i;
			$officePhone1Key = 'phone1_'.$i;
			$officePhone2Key = 'phone2_'.$i;
			$officeEmailKey = 'email_'.$i;

			$instance[ $officeNameKey ] = (!empty( $new_instance[ $officeNameKey ])) ? strip_tags($new_instance[ $officeNameKey ]) : '';
			$instance[ $officeAddressKey ] = (!empty( $new_instance[ $officeAddressKey ])) ? strip_tags($new_instance[ $officeAddressKey ]) : '';
			$instance[ $officeAddress2Key ] = (!empty( $new_instance[ $officeAddress2Key ])) ? strip_tags($new_instance[ $officeAddress2Key ]) : '';
			$instance[ $officePhone1Key ] = (!empty( $new_instance[ $officePhone1Key ])) ? strip_tags($new_instance[ $officePhone1Key ]) : '';
			$instance[ $officePhone2Key ] = (!empty( $new_instance[ $officePhone2Key ])) ? strip_tags($new_instance[ $officePhone2Key ]) : '';
			$instance[ $officeEmailKey ] = (!empty( $new_instance[ $officeEmailKey ])) ? strip_tags($new_instance[ $officeEmailKey ]) : '';
		}

		return $instance;
	}
}

/**
 * Google Map Widget class
 */
class aya_GoogleMap_Widget extends WP_Widget {

	function __construct() {
	parent::__construct(
		// Base ID of Google Map widget
		'aya_GoogleMap_Widget', 

		// Google Map Widget name will appear in UI
		__( 'Google Map', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Displays Google Map with Marker Points for the Offices', 'aya' )) 
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {
		$title = apply_filters( 'widget_title', array_key_exists( 'title', $instance ) ? $instance[ 'title' ] : '' );
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];
		
		if ( !empty($title) ) {
			echo $args[ 'before_title' ].$title.$args[ 'after_title' ];
		}
		
		if ( array_key_exists( 'textbeforemap', $instance ) && ( $instance[ 'textbeforemap' ] != '' ) ) {
		
			echo '<div>'.$instance[ 'textbeforemap' ].'</div>';
		}

		$centerLatitude = array_key_exists( 'googlemapcenterlatitude', $instance ) ? $instance[ 'googlemapcenterlatitude' ] : '';
		$centerlongitude = array_key_exists( 'googlemapcenterlongitude', $instance ) ? $instance[ 'googlemapcenterlongitude' ] : '';

		$googlemapzoom = array_key_exists( 'googlemapzoom', $instance ) ? $instance[ 'googlemapzoom' ] : 10;
		$googlekey = array_key_exists( 'googlemapkey', $instance ) ? $instance[ 'googlemapkey' ] : '';

		// if no center map latitude and longitude coordinates not exist or they are empty, do NOT display the google map.
		if ( !empty( $centerLatitude ) && !empty( $centerlongitude ) ) {
?>
			<div id="map_canvas"></div>
			<?php if ($googlekey != '') : ?>
				<script src="https://maps.googleapis.com/maps/api/js?libraries=places&key=<?php echo $googlekey; ?>"></script>
			<?php else : ?>
				<script src="https://maps.googleapis.com/maps/api/js"></script>
			<?php endif; ?>
			<script>
				function initialize() {
					var map_canvas = document.getElementById('map_canvas');
					var map_options = {
						// LatLng(double latitude, double longitude)
					  center: new google.maps.LatLng(<?php echo $centerLatitude; ?>, <?php echo $centerlongitude; ?>),
					  zoom: <?php echo $googlemapzoom; ?>,
					  mapTypeId: google.maps.MapTypeId.ROADMAP
					}
					var map = new google.maps.Map(map_canvas, map_options);
					var marker;
		
					<?php for ( $i = 1; $i <= 20; ++$i ) {
						
						$officeLatitudeKey = 'officelatitude_'.$i;
						$officeLongitudeKey = 'officelongitude_'.$i;
						$officeNameKey = 'officename_'.$i;

						$officeLatitude = array_key_exists( $officeLatitudeKey, $instance ) ? $instance[ $officeLatitudeKey ] : '';
						$officeLongitude = array_key_exists( $officeLongitudeKey, $instance ) ? $instance[ $officeLongitudeKey ] : '';
						$officeName = array_key_exists( $officeNameKey, $instance ) ? $instance[ $officeNameKey ] : '';

						if ( !empty($officeLatitude) && !empty($officeLongitude) ) { ?>					 
		
							marker = new google.maps.Marker({
									position: new google.maps.LatLng(<?php echo $officeLatitude; ?>, <?php echo $officeLongitude; ?>),
									map: map
									<?php if ( empty($officeName) ) {
										echo ', title:"'.$officeName.'"';
									      } ?>
								});
						<?php }
			} ?>
		  }
		  google.maps.event.addDomListener(window, 'load', initialize);
		</script>
<?php
		}
		
		if ( array_key_exists( 'textaftermap', $instance ) && ( $instance[ 'textaftermap' ] != '' ) ) {
		
			echo '<div>'.$instance[ 'textaftermap' ].'</div>';
		}

		echo $args[ 'after_widget' ];
	}
		
	// Widget Backend
	public function form($instance) {
	
		// title
		if (isset($instance[ 'title' ])) {
			$title = $instance[ 'title' ];
		} else {
			$title = '';
		}
		
		// text before map
		if (isset($instance[ 'textbeforemap' ])) {
			$textbeforemap = $instance[ 'textbeforemap' ];
		} else {
			$textbeforemap = '';
		}
		
		// text after map
		if (isset($instance[ 'textaftermap' ])) {
			$textaftermap = $instance[ 'textaftermap' ];
		} else {
			$textaftermap = '';
		}

		// Widget admin form
?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
				name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"
				value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'textbeforemap' ); ?>"><?php _e( 'Text Before Map:', 'aya' ); ?></label> 
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'textbeforemap' ); ?>" name="<?php echo $this->get_field_name( 'textbeforemap' ); ?>"><?php echo esc_attr($textbeforemap); ?></textarea>
		</p>
<?php
		$centerLatitude = array_key_exists( 'googlemapcenterlatitude', $instance ) ? $instance[ 'googlemapcenterlatitude' ] : '';
		$centerLongitude = array_key_exists( 'googlemapcenterlongitude', $instance ) ? $instance[ 'googlemapcenterlongitude' ] : '';
		$googlemapzoom = array_key_exists( 'googlemapzoom', $instance ) ? $instance[ 'googlemapzoom' ] : 10;
		$googlekey = array_key_exists( 'googlemapkey', $instance ) ? $instance[ 'googlemapkey' ] : '';
?>
		<p>
			<label for="<?php echo $this->get_field_id( 'googlemapkey' ); ?>"><?php _e( 'Google API Key', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'googlemapkey' ); ?>"
				name="<?php echo $this->get_field_name( 'googlemapkey' ); ?>" type="text"
				value="<?php echo esc_attr($googlekey); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'googlemapcenterlatitude' ); ?>"><?php _e( 'Center Google Map Latitude', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'googlemapcenterlatitude' ); ?>"
				name="<?php echo $this->get_field_name( 'googlemapcenterlatitude' ); ?>" type="text"
				value="<?php echo esc_attr($centerLatitude); ?>"
				placeholder="40.764229" required />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'googlemapcenterlongitude' ); ?>"><?php _e( 'Center Google Map Longitude', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'googlemapcenterlongitude' ); ?>"
				name="<?php echo $this->get_field_name( 'googlemapcenterlongitude' ); ?>" type="text"
				value="<?php echo esc_attr($centerLongitude); ?>"
				placeholder="-73.948134" required />
		</p>
		<p><label for="<?php echo $this->get_field_id('googlemapzoom'); ?>"><?php _e('Default Zoom Level', 'aya'); ?>:</label>
			<select id="<?php echo $this->get_field_id('googlemapzoom'); ?>" name="<?php echo $this->get_field_name('googlemapzoom'); ?>" class="widefat">
				<?php for ($i = 1; $i < 20; ++$i) : ?>
						<option value="<?php echo $i; ?>" <?php selected($googlemapzoom, $i) ?>>
							<?php echo $i; ?>
						</option>
				<?php endfor; ?>
			</select>
		</p>

<?php
		for ( $i = 1; $i <= 20; ++$i ) {
						
			$officeLatitudeKey = 'officelatitude_'.$i;
			$officeLongitudeKey = 'officelongitude_'.$i;
			$officeNameKey = 'officename_'.$i;

			$officeLatitude = array_key_exists( $officeLatitudeKey, $instance ) ? $instance[ $officeLatitudeKey ] : '';
			$officeLongitude = array_key_exists( $officeLongitudeKey, $instance ) ? $instance[ $officeLongitudeKey ] : '';
			$officeName = array_key_exists( $officeNameKey, $instance ) ? $instance[ $officeNameKey ] : '';
?>
			<p>
				<label for="<?php echo $this->get_field_id( $officeLatitudeKey ); ?>"><?php echo sprintf( __( 'Office #%s Latitude', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( $officeLatitudeKey ); ?>"
					name="<?php echo $this->get_field_name( $officeLatitudeKey ); ?>" type="text"
					value="<?php echo esc_attr($officeLatitude); ?>"
					placeholder="40.764229" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( $officeLongitudeKey ); ?>"><?php echo sprintf( __( 'Office #%s Longitude', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( $officeLongitudeKey ); ?>"
					name="<?php echo $this->get_field_name( $officeLongitudeKey ); ?>" type="text"
					value="<?php echo esc_attr($officeLongitude); ?>"
					placeholder="-73.948134" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( $officeNameKey ); ?>"><?php echo sprintf( __( 'Office #%s Name', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( $officeNameKey ); ?>"
					name="<?php echo $this->get_field_name( $officeNameKey ); ?>" type="text"
					value="<?php echo esc_attr($officeName); ?>"
					placeholder="Office Name" />
			</p>
<?php
		}
?>
		<p>
			<label for="<?php echo $this->get_field_id( 'textaftermap' ); ?>"><?php _e( 'Text After Map:', 'aya' ); ?></label> 
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'textaftermap' ); ?>" name="<?php echo $this->get_field_name( 'textaftermap' ); ?>"><?php echo esc_attr($textaftermap); ?></textarea>
		</p>
<?php 
	}
	
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance[ 'title' ] = (!empty( $new_instance[ 'title' ])) ? strip_tags($new_instance[ 'title' ]) : '';
		$instance[ 'textbeforemap' ] = (!empty( $new_instance[ 'textbeforemap' ])) ? strip_tags($new_instance[ 'textbeforemap' ]) : '';

		$instance[ 'googlemapcenterlatitude' ] = (!empty( $new_instance[ 'googlemapcenterlatitude' ])) ? strip_tags($new_instance[ 'googlemapcenterlatitude' ]) : '';
		$instance[ 'googlemapcenterlongitude' ] = (!empty( $new_instance[ 'googlemapcenterlongitude' ])) ? strip_tags($new_instance[ 'googlemapcenterlongitude' ]) : '';
		$instance[ 'googlemapzoom' ] = !empty( $new_instance[ 'googlemapzoom' ])
											? strip_tags($new_instance[ 'googlemapzoom' ]) : 10;
		$instance[ 'googlemapkey' ] = !empty( $new_instance[ 'googlemapkey' ])
											? strip_tags($new_instance[ 'googlemapkey' ]) : '';

		for ( $i = 1; $i <= 20; ++$i ) {
						
			$officeLatitudeKey = 'officelatitude_'.$i;
			$officeLongitudeKey = 'officelongitude_'.$i;
			$officeNameKey = 'officename_'.$i;

			$instance[ $officeLatitudeKey ] = (!empty( $new_instance[ $officeLatitudeKey ])) ? strip_tags($new_instance[ $officeLatitudeKey ]) : '';
			$instance[ $officeLongitudeKey ] = (!empty( $new_instance[ $officeLongitudeKey ])) ? strip_tags($new_instance[ $officeLongitudeKey ]) : '';
			$instance[ $officeNameKey ] = (!empty( $new_instance[ $officeNameKey ])) ? strip_tags($new_instance[ $officeNameKey ]) : '';
		}

		$instance[ 'textaftermap' ] = (!empty( $new_instance[ 'textaftermap' ])) ? strip_tags($new_instance[ 'textaftermap' ]) : '';

		return $instance;
	}
}

class aya_Instagram_Widget extends WP_Widget {
	
	function __construct() {
		$widget_ops = array('classname' => 'aya-instagram-feed', 'description' => __('Displays your latest Instagram photos', 'aya') );
		parent::__construct('aya-instagram-feed', __('Instagram', 'aya'), $widget_ops);	
	}

	function widget($args, $instance) {
		
		extract($args, EXTR_SKIP);
		
		$title = empty($instance['title']) ? '' : apply_filters('widget_title', $instance['title']);	
		$username = empty($instance['username']) ? '' : $instance['username'];
		$limit = empty($instance['number']) ? 9 : $instance['number'];
		$size = empty($instance['size']) ? 'thumbnail' : $instance['size'];

		echo $before_widget;
		if(!empty($title)) { echo $before_title . $title . $after_title; };
		
		if ($username != '') {

			$request  = wp_remote_get( 'http://instagram.com/'.trim($username) );
$insta_source = wp_remote_retrieve_body( $request );
			$shards = explode('window._sharedData = ', $insta_source);
			$insta_json = explode(';</script>', $shards[1]); 
			$insta_array = json_decode($insta_json[0], TRUE);

			if (!$insta_array)
	  			return new WP_Error('bad_json', __('Instagram has returned invalid data.', 'aya'));
			
			$images = $insta_array['entry_data']['ProfilePage'][0]['user']['media']['nodes'];
			$userId = $insta_array['entry_data']['ProfilePage'][0]['user']['id'];

			echo '<ul class="instagram-pics">';
			for ( $i = 0; $i < min( count($images), $limit ); ++$i) {

				$image = $images[$i];

				if ( !$image['is_video'] && $image['owner']['id'] == $userId ) {

					$link = 'https://instagram.com/p/' . $image['code'] . '/?taken-by=' . trim($username);
					echo '<li><a href="'.$link.'" target="_blank"><img src="'.$image['display_src'].'"  alt="'.$image['code'].'"/></a></li>';
				}
			}
			echo '</ul>';
		}

		echo $after_widget;
	}

	function form($instance) {
		$instance = wp_parse_args( (array) $instance, array( 'title' 	=> __('Instagram', 'aya'),
															 'username' => '',
															 'number' 	=> 9,
															 'size' => 'thumbnail')
														   );
		$title = esc_attr($instance['title']);
		$username = esc_attr($instance['username']);
		$number = absint($instance['number']);
		$size = esc_attr($instance['size']);
		?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'aya'); ?>: <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
		<p><label for="<?php echo $this->get_field_id('username'); ?>"><?php _e('Username', 'aya'); ?>: <input class="widefat" id="<?php echo $this->get_field_id('username'); ?>" name="<?php echo $this->get_field_name('username'); ?>" type="text" value="<?php echo $username; ?>" /></label></p>
		<p><label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number of Photos', 'aya'); ?>: <input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" /></label></p>
		<p><label for="<?php echo $this->get_field_id('size'); ?>"><?php _e('Photo Size', 'aya'); ?>:</label>
			<select id="<?php echo $this->get_field_id('size'); ?>" name="<?php echo $this->get_field_name('size'); ?>" class="widefat">
				<option value="thumbnail" <?php selected('thumbnail', $size) ?>><?php _e('Thumbnail', 'aya'); ?></option>
				<option value="large" <?php selected('large', $size) ?>><?php _e('Large', 'aya'); ?></option>
			</select>
		</p>
		<?php

	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['username'] = trim(strip_tags($new_instance['username']));
		$instance['number'] = !absint($new_instance['number']) ? 9 : $new_instance['number'];
		$instance['size'] = (($new_instance['size'] == 'thumbnail' || $new_instance['size'] == 'large') ? $new_instance['size'] : 'thumbnail');
		return $instance;
	}
}

/**
 *  Social Sites Widget Class
 */
class aya_SocialSites_Widget extends WP_Widget {

	function __construct() {
	parent::__construct(
		// Base ID of Social Sites widget
		'aya_SocialSites_Widget', 

		// Social Sites Widget name will appear in UI
		__( 'Social Sites (icons)', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Social Sites icons', 'aya' )) 
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', array_key_exists( 'title', $instance ) ? $instance[ 'title' ] : '' );
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];
		if (!empty($title)) {
			echo $args[ 'before_title' ].$title.$args[ 'after_title' ];
		}
		
		$displayType = ( ! empty( $instance['display_type'] ) ) ? absint( $instance['display_type'] ) : 0;
 		if ( ! $displayType )
 			$displayType = 0;
		
		// Display the output
		$openinnewwindow = isset($instance[ 'openinnewwindow' ]) ? $instance[ 'openinnewwindow' ] : true;
		
		if ( $displayType == 0 ) {
		
			aya_show_social_sites16($openinnewwindow);
			
		} else {
		
			aya_show_social_sites32($openinnewwindow);
		}
			
		echo $args[ 'after_widget' ];
	}
		
	// Widget Backend 
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Social Sites', 'aya' );
		}
		if (isset($instance[ 'openinnewwindow' ])) {
			$openinnewwindow = $instance[ 'openinnewwindow' ];
		}
		else {
			$openinnewwindow = 1;
		}
		
		$displayType = isset( $instance['display_type'] ) ? absint( $instance['display_type'] ) : 0;
		
		// Widget admin form
?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
		<input class="checkbox" type="checkbox" <?php checked((bool)(isset($instance[ 'openinnewwindow' ]) ? $instance[ 'openinnewwindow' ] : 1), true); ?> id="<?php echo $this->get_field_id( 'openinnewwindow' ); ?>" name="<?php echo $this->get_field_name( 'openinnewwindow' ); ?>" />
		<br /><span class='description'><?php _e( 'Open Social Icons in a new window', 'aya' ) ?></span>
		</p>
		<p><label for="<?php echo $this->get_field_id( 'display_type' ); ?>"><?php _e( 'Display Type:', 'aya' ); ?></label>		
		<select id="<?php echo $this->get_field_id( 'display_type' ); ?>" name="<?php echo $this->get_field_name( 'display_type' ); ?>">
			<option value="0" 
	        			<?php if ( $displayType == 0 ) : ?>
	        						selected="selected"
	        			<?php endif; ?>>
	        	<?php _e('Small Icons', 'aya'); ?>
	        </option>
	        <option value="1" 
	        			<?php if ( $displayType == 1 ) : ?>
	        						selected="selected"
	        			<?php endif; ?>>
	        	<?php _e('Large Icons', 'aya'); ?>
	        </option>
	    </select>
	    </p>
<?php 
	}
	
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance[ 'title' ] = (!empty( $new_instance[ 'title' ])) ? strip_tags($new_instance[ 'title' ]) : '';
		$instance[ 'openinnewwindow' ] = (!empty($new_instance[ 'openinnewwindow' ])) ? strip_tags($new_instance[ 'openinnewwindow' ]) : '';
		$instance['display_type'] = (int) $new_instance['display_type'];
		
		return $instance;
	}
}

/*
 * Follow Us on Facebook Widget class
 */
class aya_FollowUsOnFacebook_Widget extends WP_Widget {

	function __construct() {
	parent::__construct(
		// Base ID of Follow Us on Facebook widget
		'aya_FollowUsOnFacebook_Widget', 

		// Widget name will appear in UI
		__( 'Follow Us on Facebook', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Follow us on Facebook icon and text', 'aya' )) 
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {

		$title = apply_filters( 'widget_title', array_key_exists( 'title', $instance ) ? $instance[ 'title' ] : '' );
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];
		
		// get facebook url from options
		$socialPageUrl = aya_read_customizer_option('aya_social_facebook', 'https://www.facebook.com/ayatemplates');
		
		// Display the output
		if ($socialPageUrl) {
			$openinnewwindow = isset($instance[ 'openinnewwindow' ]) ? $instance[ 'openinnewwindow' ] : true;
			
			aya_show_follow_single_social_site($socialPageUrl, $title, 'facebook32', $openinnewwindow);
		
		} else {
		
			echo '<p>'.__( 'No Facebook URL entered. Please, log in your Admin, go to Appearance -> Theme Options -> Social Tab and enter your Facebook page URL to see this widget', 'aya' ).'</p>';
		}

		echo $args[ 'after_widget' ];
	}
		
	// Widget Backend 
	public function form($instance) {
		if (isset($instance[ 'title' ])) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Follow Us on Facebook', 'aya' );
		}
		if (isset($instance[ 'openinnewwindow' ])) {
			$openinnewwindow = $instance[ 'openinnewwindow' ];
		}
		else {
			$openinnewwindow = 1;
		}
		// Widget admin form
?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
		<input class="checkbox" type="checkbox" <?php checked((bool)(isset($instance[ 'openinnewwindow' ]) ? $instance[ 'openinnewwindow' ] : 1), true); ?> id="<?php echo $this->get_field_id( 'openinnewwindow' ); ?>" name="<?php echo $this->get_field_name( 'openinnewwindow' ); ?>" />
		<br /><span class='description'><?php _e( 'Open Facebook link in a new window', 'aya' ) ?></span>
		</p>
<?php 
	}
	
	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance[ 'title' ] = (!empty( $new_instance[ 'title' ])) ? strip_tags($new_instance[ 'title' ]) : '';
		$instance[ 'openinnewwindow' ] = (!empty($new_instance[ 'openinnewwindow' ])) ? strip_tags($new_instance[ 'openinnewwindow' ]) : '';
		
		return $instance;
	}
}

/*
 * Follow Us on Twitter Widget class
 */
class aya_FollowUsOnTwitter_Widget extends WP_Widget {

	function __construct() {
	parent::__construct(
		// Base ID of Follow Us on Twitter widget
		'aya_FollowUsOnTwitter_Widget', 

		// Widget name will appear in UI
		__( 'Follow Us on Twitter', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Follow us on Twitter icon and text', 'aya' )) 
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {

		$title = apply_filters( 'widget_title', array_key_exists( 'title', $instance ) ? $instance[ 'title' ] : '' );
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];
		
		// get twitter url from options
		$socialPageUrl = aya_read_customizer_option('aya_social_twitter', 'https://twitter.com/ayatemplates');
		
		// Display the output
		if ($socialPageUrl) {
			$openinnewwindow = isset($instance[ 'openinnewwindow' ]) ? $instance[ 'openinnewwindow' ] : true;
			
			aya_show_follow_single_social_site($socialPageUrl, $title, 'twitter32', $openinnewwindow);
		
		} else {
		
			echo '<p>'.__( 'No Twitter URL entered. Please, log in your Admin, go to Appearance -> Theme Options -> Social Tab and enter your Twitter page URL to see this widget', 'aya' ).'</p>';
		}

		echo $args[ 'after_widget' ];
	}
		
	// Widget Backend 
	public function form($instance) {
		if (isset($instance[ 'title' ])) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Follow Us on Twitter', 'aya' );
		}
		if (isset($instance[ 'openinnewwindow' ])) {
			$openinnewwindow = $instance[ 'openinnewwindow' ];
		}
		else {
			$openinnewwindow = 1;
		}
		// Widget admin form
?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
		<input class="checkbox" type="checkbox" <?php checked((bool)(isset($instance[ 'openinnewwindow' ]) ? $instance[ 'openinnewwindow' ] : 1), true); ?> id="<?php echo $this->get_field_id( 'openinnewwindow' ); ?>" name="<?php echo $this->get_field_name( 'openinnewwindow' ); ?>" />
		<br /><span class='description'><?php _e( 'Open Twitter link in a new window', 'aya' ) ?></span>
		</p>
<?php 
	}
	
	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance[ 'title' ] = (!empty( $new_instance[ 'title' ])) ? strip_tags($new_instance[ 'title' ]) : '';
		$instance[ 'openinnewwindow' ] = (!empty($new_instance[ 'openinnewwindow' ])) ? strip_tags($new_instance[ 'openinnewwindow' ]) : '';
		
		return $instance;
	}
}

/*
 * Follow Our Rss Feeds Widget class
 */ 
class aya_FollowOurRssFeeds_Widget extends WP_Widget {

	function __construct() {
	parent::__construct(
		// Base ID of Follow Our Rss Feeds widget
		'aya_FollowOurRssFeeds_Widget', 

		// Widget name will appear in UI
		__( 'Follow Our Rss Feeds', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Follow Our Rss Feeds icon and text', 'aya' )) 
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {

		$title = apply_filters( 'widget_title', array_key_exists( 'title', $instance ) ? $instance[ 'title' ] : '' );
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];
		
		// get rss feeds url from options
		$socialPageUrl = aya_read_customizer_option('aya_social_rss', get_bloginfo( 'rss2_url' ));
		
		// Display the output
		if ($socialPageUrl) {
			$openinnewwindow = isset($instance[ 'openinnewwindow' ]) ? $instance[ 'openinnewwindow' ] : true;
			
			aya_show_follow_single_social_site($socialPageUrl, $title, 'rss32', $openinnewwindow);
		
		} else {
		
			echo '<p>'.__( 'No Rss Feeds URL entered. Please, log in your Admin, go to Appearance -> Theme Options -> Social Tab and enter your Rss Feeds URL to see this widget', 'aya' ).'</p>';
		}

		echo $args[ 'after_widget' ];
	}
		
	// Widget Backend 
	public function form($instance) {
		if (isset($instance[ 'title' ])) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Follow Our Rss Feeds', 'aya' );
		}
		if (isset($instance[ 'openinnewwindow' ])) {
			$openinnewwindow = $instance[ 'openinnewwindow' ];
		}
		else {
			$openinnewwindow = 1;
		}
		// Widget admin form
?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
		<input class="checkbox" type="checkbox" <?php checked((bool)(isset($instance[ 'openinnewwindow' ]) ? $instance[ 'openinnewwindow' ] : 1), true); ?> id="<?php echo $this->get_field_id( 'openinnewwindow' ); ?>" name="<?php echo $this->get_field_name( 'openinnewwindow' ); ?>" />
		<br /><span class='description'><?php _e( 'Open Rss Feeds link in a new window', 'aya' ) ?></span>
		</p>
<?php 
	}
	
	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance[ 'title' ] = (!empty( $new_instance[ 'title' ])) ? strip_tags($new_instance[ 'title' ]) : '';
		$instance[ 'openinnewwindow' ] = (!empty($new_instance[ 'openinnewwindow' ])) ? strip_tags($new_instance[ 'openinnewwindow' ]) : '';
		
		return $instance;
	}
}

class aya_tabs_widget extends WP_Widget {
	function __construct() {
        
        // add image sizes and load language file
        add_action( 'init', array(&$this, 'aya_tabs_init') );
        
		// ajax functions
		add_action('wp_ajax_aya_tabs_widget_content', array(&$this, 'ajax_aya_tabs_widget_content'));
		add_action('wp_ajax_nopriv_aya_tabs_widget_content', array(&$this, 'ajax_aya_tabs_widget_content'));
        
        // scripts
		add_action('wp_enqueue_scripts', array(&$this, 'aya_tabs_register_scripts'));
        add_action('admin_enqueue_scripts', array(&$this, 'aya_tabs_admin_scripts'));
		
		$widget_ops = array('classname' => 'widget_aya', 'description' => __('Display popular posts, recent posts, comments, and tags in tabbed format.', 'aya'));
		$control_ops = array('width' => 300, 'height' => 350);
		parent::__construct('aya_tabs_widget', __('Tab Widget', 'aya'), $widget_ops, $control_ops);
    }	
    
    function aya_tabs_init() {

        add_image_size( 'wp_review_small', 65, 65, true ); // small thumb
        add_image_size( 'wp_review_large', 320, 240, true ); // large thumb
    }
    function aya_tabs_admin_scripts($hook) {

		wp_enqueue_script('aya_tabs_widget_admin', get_template_directory_uri() . '/js/aya-tabs-admin.js', array( 'jquery' ) );
    }
	
	function aya_tabs_register_scripts() { 
		// JS    
		wp_register_script('aya_tabs_widget', get_template_directory_uri() . '/js/aya-tabs-widget.js', array('jquery'));     
		wp_localize_script( 'aya_tabs_widget', 'aya_tabs', array( 'ajax_url' => admin_url( 'admin-ajax.php' )) );
    }
    	
	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'tabs' => array('recent' => 1, 'popular' => 1, 'comments' => 0, 'tags' => 0), 'tab_order' => array('popular' => 1, 'recent' => 2, 'comments' => 3, 'tags' => 4), 'allow_pagination' => 1, 'post_num' => '5', 'comment_num' => '5', 'show_thumb' => 1, 'thumb_size' => 'small', 'show_date' => 1, 'show_excerpt' => 0, 'excerpt_length' => 10, 'show_comment_num' => 0, 'show_avatar' => 1) );
		extract($instance);
		?>
        <div class="aya_tabs_options_form">
        
        <h4><?php _e('Select Tabs', 'aya'); ?></h4>
        
		<div class="aya_tabs_select_tabs">
			<label class="alignleft" style="display: block; width: 50%; margin-bottom: 5px" for="<?php echo $this->get_field_id("tabs"); ?>_popular">
				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("tabs"); ?>_popular" name="<?php echo $this->get_field_name("tabs"); ?>[popular]" value="1" <?php if (isset($tabs['popular'])) { checked( 1, $tabs['popular'], true ); } ?> />
				<?php _e( 'Popular Tab', 'aya'); ?>
			</label>
			<label class="alignleft" style="display: block; width: 50%; margin-bottom: 5px;" for="<?php echo $this->get_field_id("tabs"); ?>_recent">
				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("tabs"); ?>_recent" name="<?php echo $this->get_field_name("tabs"); ?>[recent]" value="1" <?php if (isset($tabs['recent'])) { checked( 1, $tabs['recent'], true ); } ?> />		
				<?php _e( 'Recent Tab', 'aya'); ?>
			</label>
			<label class="alignleft" style="display: block; width: 50%;" for="<?php echo $this->get_field_id("tabs"); ?>_comments">
				<input type="checkbox" class="checkbox aya_tabs_enable_comments" id="<?php echo $this->get_field_id("tabs"); ?>_comments" name="<?php echo $this->get_field_name("tabs"); ?>[comments]" value="1" <?php if (isset($tabs['comments'])) { checked( 1, $tabs['comments'], true ); } ?> />
				<?php _e( 'Comments Tab', 'aya'); ?>
			</label>
			<label class="alignleft" style="display: block; width: 50%;" for="<?php echo $this->get_field_id("tabs"); ?>_tags">
				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("tabs"); ?>_tags" name="<?php echo $this->get_field_name("tabs"); ?>[tags]" value="1" <?php if (isset($tabs['tags'])) { checked( 1, $tabs['tags'], true ); } ?> />
				<?php _e( 'Tags Tab', 'aya'); ?>
			</label>
		</div>
        <div class="clear"></div>
        
        <h4 class="aya_tabs_tab_order_header"><a href="#"><?php _e('Tab Order', 'aya'); ?></a></h4>
        
        <div class="aya_tabs_tab_order" style="display: none;">
            
            <label class="alignleft" for="<?php echo $this->get_field_id('tab_order'); ?>_popular" style="width: 50%;">
				<input id="<?php echo $this->get_field_id('tab_order'); ?>_popular" name="<?php echo $this->get_field_name('tab_order'); ?>[popular]" type="number" min="1" step="1" value="<?php echo $tab_order['popular']; ?>" style="width: 48px;" />
                <?php _e('Popular', 'aya'); ?>
            </label>
            <label class="alignleft" for="<?php echo $this->get_field_id('tab_order'); ?>_recent" style="width: 50%;">
				<input id="<?php echo $this->get_field_id('tab_order'); ?>_recent" name="<?php echo $this->get_field_name('tab_order'); ?>[recent]" type="number" min="1" step="1" value="<?php echo $tab_order['recent']; ?>" style="width: 48px;" />
                <?php _e('Recent', 'aya'); ?>
            </label>
            <label class="alignleft" for="<?php echo $this->get_field_id('tab_order'); ?>_comments" style="width: 50%;">
				<input id="<?php echo $this->get_field_id('tab_order'); ?>_comments" name="<?php echo $this->get_field_name('tab_order'); ?>[comments]" type="number" min="1" step="1" value="<?php echo $tab_order['comments']; ?>" style="width: 48px;" />
			    <?php _e('Comments', 'aya'); ?>
            </label>
            <label class="alignleft" for="<?php echo $this->get_field_id('tab_order'); ?>_tags" style="width: 50%;">
				<input id="<?php echo $this->get_field_id('tab_order'); ?>_tags" name="<?php echo $this->get_field_name('tab_order'); ?>[tags]" type="number" min="1" step="1" value="<?php echo $tab_order['tags']; ?>" style="width: 48px;" />
			    <?php _e('Tags', 'aya'); ?>
            </label>
        </div>
		<div class="clear"></div>
        
        <h4 class="aya_tabs_advanced_options_header"><a href="#"><?php _e('Advanced Options', 'aya'); ?></a></h4>
        
        <div class="aya_tabs_advanced_options" style="display: none;">
        <p>
			<label for="<?php echo $this->get_field_id("allow_pagination"); ?>">				
				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("allow_pagination"); ?>" name="<?php echo $this->get_field_name("allow_pagination"); ?>" value="1" <?php if (isset($allow_pagination)) { checked( 1, $allow_pagination, true ); } ?> />
				<?php _e( 'Allow pagination', 'aya'); ?>
			</label>
		</p>
		
		<div class="aya_tabs_post_options">

        <p>
			<label for="<?php echo $this->get_field_id('post_num'); ?>"><?php _e('Number of posts to show:', 'aya'); ?>
				<br />
				<input id="<?php echo $this->get_field_id('post_num'); ?>" name="<?php echo $this->get_field_name('post_num'); ?>" type="number" min="1" step="1" value="<?php echo $post_num; ?>" />
			</label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id("show_thumb"); ?>">
				<input type="checkbox" class="checkbox aya_tabs_show_thumbnails" id="<?php echo $this->get_field_id("show_thumb"); ?>" name="<?php echo $this->get_field_name("show_thumb"); ?>" value="1" <?php if (isset($show_thumb)) { checked( 1, $show_thumb, true ); } ?> />
				<?php _e( 'Show post thumbnails', 'aya'); ?>
			</label>
		</p>   
		
		<p class="aya_tabs_thumbnail_size"<?php echo (empty($show_thumb) ? ' style="display: none;"' : ''); ?>>
			<label for="<?php echo $this->get_field_id('thumb_size'); ?>"><?php _e('Thumbnail size:', 'aya'); ?></label> 
			<select id="<?php echo $this->get_field_id('thumb_size'); ?>" name="<?php echo $this->get_field_name('thumb_size'); ?>" style="margin-left: 12px;">
				<option value="small" <?php selected($thumb_size, 'small', true); ?>><?php _e('Small', 'aya'); ?></option>
				<option value="large" <?php selected($thumb_size, 'large', true); ?>><?php _e('Large', 'aya'); ?></option>    
			</select>       
		</p>	
		
		<p>			
			<label for="<?php echo $this->get_field_id("show_date"); ?>">	
				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("show_date"); ?>" name="<?php echo $this->get_field_name("show_date"); ?>" value="1" <?php if (isset($show_date)) { checked( 1, $show_date, true ); } ?> />	
				<?php _e( 'Show post date', 'aya'); ?>	
			</label>	
		</p>
        
		<p>		
			<label for="<?php echo $this->get_field_id("show_comment_num"); ?>">		
				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("show_comment_num"); ?>" name="<?php echo $this->get_field_name("show_comment_num"); ?>" value="1" <?php if (isset($show_comment_num)) { checked( 1, $show_comment_num, true ); } ?> />	
				<?php _e( 'Show number of comments', 'aya'); ?>		
			</label>	
		</p>    
		
		<p>			
			<label for="<?php echo $this->get_field_id("show_excerpt"); ?>">	
				<input type="checkbox" class="checkbox aya_tabs_show_excerpt" id="<?php echo $this->get_field_id("show_excerpt"); ?>" name="<?php echo $this->get_field_name("show_excerpt"); ?>" value="1" <?php if (isset($show_excerpt)) { checked( 1, $show_excerpt, true ); } ?> />
				<?php _e( 'Show post excerpt', 'aya'); ?>
			</label>		
		</p>
		
		<p class="aya_tabs_excerpt_length"<?php echo (empty($show_excerpt) ? ' style="display: none;"' : ''); ?>>
			<label for="<?php echo $this->get_field_id('excerpt_length'); ?>">
				<?php _e('Excerpt length (words):', 'aya'); ?>   
				<br />
				<input type="number" min="1" step="1" id="<?php echo $this->get_field_id('excerpt_length'); ?>" name="<?php echo $this->get_field_name('excerpt_length'); ?>" value="<?php echo $excerpt_length; ?>" />
			</label>
		</p>	
		  
		</div>
        <div class="clear"></div>
        
        <div class="aya_tabs_comment_options"<?php echo (empty($tabs['comments']) ? ' style="display: none;"' : ''); ?>>
		
        <p>
			<label for="<?php echo $this->get_field_id('comment_num'); ?>">
				<?php _e('Number of comments on Comments Tab:', 'aya'); ?>
				<br />
				<input type="number" min="1" step="1" id="<?php echo $this->get_field_id('comment_num'); ?>" name="<?php echo $this->get_field_name('comment_num'); ?>" value="<?php echo $comment_num; ?>" />
			</label>			
		</p>      
		
		<p>			
			<label for="<?php echo $this->get_field_id("show_avatar"); ?>">			
				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("show_avatar"); ?>" name="<?php echo $this->get_field_name("show_avatar"); ?>" value="1" <?php if (isset($show_avatar)) { checked( 1, $show_avatar, true ); } ?> />
				<?php _e( 'Show avatars on Comments Tab', 'aya'); ?>	
			</label>	
		</p>
        </div><!-- .aya_tabs_comment_options -->
        </div><!-- .aya_tabs_advanced_options -->
		</div><!-- .aya_tabs_options_form -->
		<?php 
	}	
	
	function update( $new_instance, $old_instance ) {	
		$instance = $old_instance;    
		$instance['tabs'] = $new_instance['tabs'];  
        $instance['tab_order'] = $new_instance['tab_order'];  
		$instance['allow_pagination'] = $new_instance['allow_pagination'];	
		$instance['post_num'] = $new_instance['post_num'];	
		$instance['comment_num'] =  $new_instance['comment_num'];		
		$instance['show_thumb'] = $new_instance['show_thumb'];     
		$instance['thumb_size'] = $new_instance['thumb_size'];		
		$instance['show_date'] = $new_instance['show_date'];    
		$instance['show_excerpt'] = $new_instance['show_excerpt'];  
		$instance['excerpt_length'] = $new_instance['excerpt_length'];	
		$instance['show_comment_num'] = $new_instance['show_comment_num'];  
		$instance['show_avatar'] = $new_instance['show_avatar'];	
		return $instance;	
	}	
	function widget( $args, $instance ) {
		extract($args);     
		extract($instance);
		
		wp_enqueue_script('aya_tabs_widget'); 
		wp_enqueue_style('aya_tabs_widget');  
		if (empty($tabs)) $tabs = array('recent' => 1, 'popular' => 1);    
		$tabs_count = count($tabs);     
		if ($tabs_count <= 1) {       
			$tabs_count = 1;       
		} elseif($tabs_count > 3) {   
			$tabs_count = 4;      
		}
        
        $available_tabs = array('popular' => __('Popular', 'aya'), 
            'recent' => __('Recent', 'aya'), 
            'comments' => __('Comments', 'aya'), 
            'tags' => __('Tags', 'aya'));
            
        array_multisort($tab_order, $available_tabs);
        
		?>	
		<?php echo $before_widget; ?>	
		<div class="aya_tabs_widget_content" id="<?php if ( isset($widget_id) ) :
																echo $widget_id; 
														 else :
																echo 'aya_tabs_widget_content';
														 endif; ?>_content">		
			<ul class="aya-tabs <?php echo "has-$tabs_count-"; ?>tabs">
                <?php foreach ($available_tabs as $tab => $label) { ?>
                    <?php if (!empty($tabs[$tab])): ?>
                        <li class="tab_title"><a href="#" id="<?php echo $tab; ?>-tab"><?php echo $label; ?></a></li>	
                    <?php endif; ?>
                <?php } ?> 
			</ul> <!--end .tabs-->	
			<div class="clear"></div>  
			<div class="inside">        
				<?php if (!empty($tabs['popular'])): ?>	
					<div id="popular-tab-content" class="tab-content">				
					</div> <!--end #popular-tab-content-->       
				<?php endif; ?>       
				<?php if (!empty($tabs['recent'])): ?>	
					<div id="recent-tab-content" class="tab-content"> 		 
					</div> <!--end #recent-tab-content-->		
				<?php endif; ?>                     
				<?php if (!empty($tabs['comments'])): ?>      
					<div id="comments-tab-content" class="tab-content"> 	
						<ul>                    		
						</ul>		
					</div> <!--end #comments-tab-content-->     
				<?php endif; ?>            
				<?php if (!empty($tabs['tags'])): ?>       
					<div id="tags-tab-content" class="tab-content"> 	
						<ul>                    	
						</ul>			 
					</div> <!--end #tags-tab-content-->  
				<?php endif; ?>	
				<div class="clear"></div>	
			</div> <!--end .inside -->	
			<div class="clear"></div>
		</div><!--end #tabber -->    
		<?php    
		// inline script 
		// to support multiple instances per page with different settings   
		
		unset($instance['tabs'], $instance['tab_order']); // unset unneeded  
		?>  
		<script type="text/javascript">  
			jQuery(function($) {    
				$('#<?php if ( isset($widget_id) ) :
								echo $widget_id; 
						  else :
								echo 'aya_tabs_widget_content';
						  endif; ?>_content').data('args', <?php echo json_encode($instance); ?>);  
			});  
		</script>  
		<?php echo $after_widget; ?>
		<?php 
	}  
	
	 
	function ajax_aya_tabs_widget_content() {     
		$tab = $_POST['tab'];       
		$args = $_POST['args'];  
		$page = intval($_POST['page']);    
		if ($page < 1)        
			$page = 1;            
		if (!is_array($args))      
			return '';
        
		// sanitize args		
		$post_num = (empty($args['post_num']) ? 5 : intval($args['post_num']));    
		if ($post_num > 20 || $post_num < 1) { // max 20 posts
			$post_num = 5;   
		}      
		$comment_num = (empty($args['comment_num']) ? 5 : intval($args['comment_num']));   
		if ($comment_num > 20 || $comment_num < 1) {  
			$comment_num = 5;    
		}       
		$show_thumb = !empty($args['show_thumb']);
		$thumb_size = $args['thumb_size'];
        if ($thumb_size != 'small' && $thumb_size != 'large') {
            $thumb_size = 'small'; // default
        }
		$show_date = !empty($args['show_date']);     
		$show_excerpt = !empty($args['show_excerpt']);  
		$excerpt_length = intval($args['excerpt_length']);
        if ($excerpt_length > 50 || $excerpt_length < 1) {  
			$excerpt_length = 10;   
		}   
		$show_comment_num = !empty($args['show_comment_num']);  
		$show_avatar = !empty($args['show_avatar']);   
		$allow_pagination = !empty($args['allow_pagination']);   
        
		/* ---------- Tab Contents ---------- */    
		switch ($tab) {        
		  
			/* ---------- Popular Posts ---------- */   
			case "popular":      
				?>       
				<ul>				
					<?php 
					$popular = new WP_Query( array('ignore_sticky_posts' => 1, 'posts_per_page' => $post_num, 'post_status' => 'publish', 'orderby' => 'comment_count', 'order' => 'desc', 'paged' => $page));         
					$last_page = $popular->max_num_pages;      
					while ($popular->have_posts()) : $popular->the_post(); ?>	
						<li>	
							<?php if ( $show_thumb == 1 ) : ?>					
								<div class="aya_tabs_thumbnail aya_tabs_thumb_<?php echo $thumb_size; ?>">	
                                    <a title="<?php the_title(); ?>" href="<?php the_permalink() ?>">		
    									<?php if(has_post_thumbnail()): ?>	
    										<?php the_post_thumbnail('wp_review_'.$thumb_size, array('title' => '')); ?>		
    									<?php else: ?>							
    										<img src="<?php echo get_stylesheet_directory_uri().'/images/tabs_'.$thumb_size.'thumb.png'; ?>" alt="<?php the_title(); ?>"  class="wp-post-image" />					
    									<?php endif; ?>
                                    </a>
								</div>				
							<?php endif; ?>					
							<div class="tabs-entry-title"><a title="<?php the_title(); ?>" href="<?php the_permalink() ?>"><?php echo get_the_title(); ?></a></div>		
							<?php if ( $show_date == 1 || $show_comment_num == 1) : ?>	
								<div class="aya-postmeta">						
									<?php if ( $show_date == 1 ) : ?>			
										<?php the_time('F j, Y'); ?>		
									<?php endif; ?>						
									<?php if ( $show_date == 1 && $show_comment_num == 1) : ?>		
										&bull; 						
									<?php endif; ?>					
									<?php if ( $show_comment_num == 1 ) : ?>			
										<?php echo comments_number(__('No Comment','aya'), __('One Comment','aya'), '<span class="comments-number">%</span> '.__('Comments','aya'));?>				
									<?php endif; ?>						
								</div> <!--end .entry-meta--> 				
							<?php endif; ?>
                            
                            <?php if ( $show_excerpt == 1 ) : ?>	
                                <div class="aya_tabs_excerpt">
                                    <p><?php echo $this->excerpt($excerpt_length); ?></p>
                                </div>
                            <?php endif; ?>	
                            						
							<div class="clear"></div>			
						</li>				
					<?php $post_num++; endwhile; wp_reset_query(); ?>		
				</ul>
                <div class="clear"></div>
				<?php if ($allow_pagination) : ?>         
					<?php $this->tab_pagination($page, $last_page); ?>      
				<?php endif; ?>                      
				<?php           
			break;              
            
			/* ---------- Recent Posts ---------- */      
			case "recent":           
				?>         
				<ul>			
					<?php              
					$recent = new WP_Query('posts_per_page='. $post_num .'&orderby=post_date&order=desc&post_status=publish&paged='. $page);       
					$last_page = $recent->max_num_pages;      
					while ($recent->have_posts()) : $recent->the_post();    
						?>						         
						<li>
							<?php if ( $show_thumb == 1 ) : ?>					
								<div class="aya_tabs_thumbnail aya_tabs_thumb_<?php echo $thumb_size; ?>">	
                                    <a title="<?php the_title(); ?>" href="<?php the_permalink() ?>">		
    									<?php if(has_post_thumbnail()): ?>	
    										<?php the_post_thumbnail('wp_review_'.$thumb_size, array('title' => '')); ?>		
    									<?php else: ?>							
    										<img src="<?php echo get_stylesheet_directory_uri().'/images/tabs_'.$thumb_size.'thumb.png'; ?>" alt="<?php the_title(); ?>"  class="wp-post-image" />					
    									<?php endif; ?>
                                    </a>
								</div>				
							<?php endif; ?>					
							<div class="tabs-entry-title"><a title="<?php the_title(); ?>" href="<?php the_permalink() ?>"><?php echo get_the_title(); ?></a></div>		
							<?php if ( $show_date == 1 || $show_comment_num == 1) : ?>			
								<div class="aya-postmeta">										
									<?php if ( $show_date == 1 ) : ?>						
										<?php the_time('F j, Y'); ?>						
									<?php endif; ?>								
									<?php if ( $show_date == 1 && $show_comment_num == 1) : ?>		
										&bull; 										
									<?php endif; ?>								
									<?php if ( $show_comment_num == 1 ) : ?>	
										<?php echo comments_number(__('No Comment','aya'), __('One Comment','aya'), '<span class="comm">%</span> '.__('Comments','aya'));?>									
									<?php endif; ?>		
								</div> <!--end .entry-meta--> 		
							<?php endif; ?>
                            
                            <?php if ( $show_excerpt == 1 ) : ?>	
                                <div class="aya_tabs_excerpt">
                                    <p><?php echo $this->excerpt($excerpt_length); ?></p>
                                </div>
                            <?php endif; ?>	
                            	
							<div class="clear"></div>		
						</li>				
					<?php endwhile; wp_reset_query(); ?>		
				</ul>
                <div class="clear"></div>
				<?php if ($allow_pagination) : ?>       
					<?php $this->tab_pagination($page, $last_page); ?>    
				<?php endif; ?>                 
				<?php       
			break;     
            
			/* ---------- Latest Comments ---------- */        
			case "comments":         
				?>          
				<ul>            
					<?php              
					$no_comments = false;         
					$avatar_size = 65;            
					$comment_length = 90; // max length for comments        
					$comments_total = new WP_Comment_Query();     
					$comments_total_number = $comments_total->query(array('count' => 1));   
					$last_page = ceil($comments_total_number / $comment_num);       
					$comments_query = new WP_Comment_Query();   
					$offset = ($page-1) * $comment_num;         
					$comments = $comments_query->query( array( 'number' => $comment_num, 'offset' => $offset ) );    
					if ( $comments ) : foreach ( $comments as $comment ) : ?>       
						<li>                        
							            
								<?php if ($show_avatar) : ?>                       
									<div class="aya_tabs_avatar">
                                        <a href="<?php echo get_comment_link($comment->comment_ID); ?>">
    										<?php echo get_avatar( $comment->comment_author_email, $avatar_size ); ?>     
                                        </a>                               
									</div>                   
								<?php endif; ?>              
								<div class="aya_tabs_comment_meta">
                                    <a href="<?php echo get_comment_link($comment->comment_ID); ?>">   
    									<span class="aya_tabs_comment_author"><?php echo get_comment_author( $comment->comment_ID ); ?> </span> - <span class="aya_tabs_comment_post"><?php echo get_the_title($comment->comment_post_ID); ?></span>                   
								    </a>
                                </div>                   
								<div class="aya_tabs_comment_content">          
									<p><?php echo $this->truncate(strip_tags(apply_filters( 'get_comment_text', $comment->comment_content )), $comment_length);?></p>
								</div>                   
							</a>                
							<div class="clear"></div>      
						</li>           
					<?php endforeach; else : ?>           
						<li>                   
							<div class="no-comments"><?php _e('No comments yet.', 'aya'); ?></div>        
						</li>                             
						<?php $no_comments = true; 
					endif; ?>       
				</ul>       
				<?php if ($allow_pagination && !$no_comments) : ?>           
					<?php $this->tab_pagination($page, $last_page); ?>      
				<?php endif; ?>                     
				<?php           
			break;             
            
			/* ---------- Tags ---------- */   
			case "tags":        
				?>           
				<ul>         
					<?php        
					$tags = get_tags(array('get'=>'all'));             
					if($tags) {               
						foreach ($tags as $tag): ?>    
							<li><a href="<?php echo get_term_link($tag); ?>"><?php echo $tag->name; ?></a></li>           
							<?php            
						endforeach;       
					} else {          
						_e('No tags created.', 'aya');           
					}            
					?>           
				</ul>            
				<?php            
			break;            
		}              
		die(); // required to return a proper result  
	}    
    function tab_pagination($page, $last_page) {  
		?>   
		<div class="aya-pagination">     
			<?php if ($page > 1) : ?>               
				<a href="#" class="previous"><span><?php _e('&laquo; Previous', 'aya'); ?></span></a>      
			<?php endif; ?>        
			<?php if ($page != $last_page) : ?>     
				<a href="#" class="next"><span><?php _e('Next &raquo;', 'aya'); ?></span></a>      
			<?php endif; ?>          
		</div>                   
		<div class="clear"></div>
		<input type="hidden" class="page_num" name="page_num" value="<?php echo $page; ?>" />    
		<?php   
	}
    
    function excerpt($limit = 10) {
          $excerpt = explode(' ', get_the_excerpt(), $limit);
          if (count($excerpt)>=$limit) {
            array_pop($excerpt);
            $excerpt = implode(" ",$excerpt).'...';
          } else {
            $excerpt = implode(" ",$excerpt);
          }
          $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
          return $excerpt;
    }
    function truncate($str, $length = 24) {
        if (mb_strlen($str) > $length) {
            return mb_substr($str, 0, $length).'...';
        } else {
            return $str;
        }
    }
}

/*
 * Advanced Text Widget class
 */
class aya_AdvancedTextContent_Widget extends WP_Widget {

	function __construct() {
	parent::__construct(
		// Base ID of Advanced Text widget
		'aya_AdvancedTextContent_Widget', 

		// Advanced Text Widget name will appear in UI
		__( 'Advanced Text', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Arbitrary text or HTML with additional display options', 'aya' )) 
		);

		add_action('admin_enqueue_scripts', array($this, 'upload_scripts'));
	}

	/**
     * Upload the Javascripts for the media uploader
     */
    public function upload_scripts() {

        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');
        wp_enqueue_script('aya_upload_media_widget', get_template_directory_uri() . '/js/upload-media.js', array( 'jquery' ) );

        wp_enqueue_style('thickbox');
    }

	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {
		$title = apply_filters( 'widget_title', array_key_exists( 'title', $instance ) ? $instance[ 'title' ] : '' );
		// before and after widget arguments are defined by themes

		$centerBackgroundImg = isset($instance[ 'centerBackgroundImg' ]) ? $instance[ 'centerBackgroundImg' ] : true;

		// Display the output

		echo '<div';

		$wrapperCss = '';

		if ( array_key_exists( 'backgroundImage', $instance ) && ( $instance[ 'backgroundImage' ] != '' ) ) {

			$wrapperCss .= "background-image:url('" . $instance[ 'backgroundImage' ] . "');";

			$wrapperCss .= ' max-width:100%;height:auto;';

			if ( $centerBackgroundImg ) {

				$wrapperCss .= ' background-position: top center;';
			}

			$wrapperCss .= ' background-repeat:no-repeat;';
		}

		if ( array_key_exists( 'paddingTop', $instance ) && ( $instance[ 'paddingTop' ] != '' ) ) {
			$wrapperCss .= ' padding-top:' . $instance[ 'paddingTop' ] . 'px;';
		}

		if ( array_key_exists( 'paddingLeft', $instance ) && ( $instance[ 'paddingLeft' ] != '' ) ) {
			$wrapperCss .= ' padding-left:' . $instance[ 'paddingLeft' ] . 'px;';
		}

		if ( array_key_exists( 'paddingBottom', $instance ) && ( $instance[ 'paddingBottom' ] != '' ) ) {
			$wrapperCss .= ' padding-bottom:' . $instance[ 'paddingBottom' ] . 'px;';
		}

		if ( array_key_exists( 'paddingRight', $instance ) && ( $instance[ 'paddingRight' ] != '' ) ) {
			$wrapperCss .= ' padding-right:' . $instance[ 'paddingRight' ] . 'px;';
		}

		if ( $wrapperCss != '' ) {

			echo ' style="' . $wrapperCss . '"';
		}


		echo '>'; // end of div tag

		echo $args[ 'before_widget' ];
		
		if ( !empty($title) ) {

			$titleClassExists = array_key_exists( 'titleClass', $instance ) && ( $instance[ 'titleClass' ] != '' );
			if ( $titleClassExists ) {
				echo '<div class="'.$instance[ 'titleClass' ].'">';
			}
			
			// Display the output
			echo $args[ 'before_title' ];
			
			echo '<i class="advanced-text-icon '.$instance[ 'iconClass' ].'"></i> ';

			echo $title;
			
			echo $args[ 'after_title' ];
			
			if ( $titleClassExists ) {
				echo '</div>';
			}
		}

		if ( array_key_exists( 'textClass', $instance ) && ( $instance[ 'textClass' ] != '' ) ) {
		
			echo '<div class="advanced-text-content '.$instance[ 'textClass' ].'">'.$instance[ 'text' ].'</div>';
			
		} else {
		
			echo '<div class="advanced-text-content">'.$instance[ 'text' ].'</div>';
		}

		if ( array_key_exists( 'url', $instance ) && array_key_exists( 'linkText', $instance ) 
			 && ( $instance[ 'url' ] != '' ) && ( $instance[ 'linkText' ] != '' ) ) {
		
			echo '<div class="advanced-text-button-wrapper">';
			
			if ( array_key_exists( 'linkClass', $instance ) && ( $instance[ 'linkClass' ] != '' ) ) {
			
				echo '<a href="'.$instance[ 'url' ].'" title="'.$instance[ 'linkText' ].'" class="btn '.$instance[ 'linkClass' ].'">'.$instance[ 'linkText' ].'</a>';
			
			} else {
				
				echo '<a href="'.$instance[ 'url' ].'" title="'.$instance[ 'linkText' ].'" class="btn">'.$instance[ 'linkText' ].'</a>';
			}
			
			echo '</div>';
		}

		echo $args[ 'after_widget' ];

		echo '<div class="clear"></div></div>';
	}
		
	// Widget Backend
	public function form($instance) {
	
		// title
		if (isset($instance[ 'title' ])) {
			$title = $instance[ 'title' ];
		} else {
			$title = '';
		}
		
		// title class
		if (isset($instance[ 'titleClass' ])) {
			$titleClass = $instance[ 'titleClass' ];
		}
		else {
			$titleClass = '';
		}
		
		// icon class
		if (isset($instance[ 'iconClass' ])) {
			$iconClass = $instance[ 'iconClass' ];
		}
		else {
			$iconClass = __( 'fa fa-smile-o', 'aya' );
		}
		
		// text
		if (isset($instance[ 'text' ])) {
			$text = $instance[ 'text' ];
		} else {
			$text = '';
		}
		
		// text class
		if (isset($instance[ 'textClass' ])) {
			$textClass = $instance[ 'textClass' ];
		}
		else {
			$textClass = '';
		}
		
		// url
		if (isset($instance[ 'url' ])) {
			$url = $instance[ 'url' ];
		} else {
			$url = '';
		}
		
		// link text
		if (isset($instance[ 'linkText' ])) {
			$linkText = $instance[ 'linkText' ];
		}
		else {
			$linkText = __( 'Details', 'aya' );
		}
		
		// link class
		if (isset($instance[ 'linkClass' ])) {
			$linkClass = $instance[ 'linkClass' ];
		}
		else {
			$linkClass = '';
		}

		$backgroundImage = isset( $instance['backgroundImage'] ) ? $instance['backgroundImage'] : '';
		$centerBackgroundImg = isset( $instance['centerBackgroundImg'] ) ? $instance['centerBackgroundImg'] : 1;

		$paddingTop = isset( $instance['paddingTop'] ) ? $instance['paddingTop'] : '';
		$paddingLeft = isset( $instance['paddingLeft'] ) ? $instance['paddingLeft'] : '';
		$paddingBottom = isset( $instance['paddingBottom'] ) ? $instance['paddingBottom'] : '';
		$paddingRight = isset( $instance['paddingRight'] ) ? $instance['paddingRight'] : '';

		// Widget admin form
?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_name( 'backgroundImage' ); ?>"><?php _e( 'Background Image:', 'aya' ); ?></label>
			<?php $uploadBtnText = $this->get_field_name( 'backgroundImage' ) ? __('Change Image', 'aya') : __('Upload Image', 'aya'); ?>
            <input name="<?php echo $this->get_field_name( 'backgroundImage' ); ?>"
            		id="<?php echo $this->get_field_id( 'backgroundImage' ); ?>" class="widefat" type="text" size="36"
            		value="<?php echo esc_url( $backgroundImage ); ?>" />
            <input class="upload_image_button button button-primary" type="button" value="<?php echo $uploadBtnText; ?>" />
        </p>
        <p>
		<input class="checkbox" type="checkbox" <?php checked((bool)(isset($instance[ 'centerBackgroundImg' ]) ? $instance[ 'centerBackgroundImg' ] : 1), true); ?> id="<?php echo $this->get_field_id( 'centerBackgroundImg' ); ?>" name="<?php echo $this->get_field_name( 'centerBackgroundImg' ); ?>" />
		<br /><span class='description'><?php _e( 'Center Background Image', 'aya' ) ?></span>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'paddingTop' ); ?>"><?php _e( 'Padding Top (in Pixels):', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'paddingTop' ); ?>" name="<?php echo $this->get_field_name( 'paddingTop' ); ?>" type="text" value="<?php echo esc_attr($paddingTop); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'paddingLeft' ); ?>"><?php _e( 'Padding Left (in Pixels):', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'paddingLeft' ); ?>" name="<?php echo $this->get_field_name( 'paddingLeft' ); ?>" type="text" value="<?php echo esc_attr($paddingLeft); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'paddingBottom' ); ?>"><?php _e( 'Padding Bottom (in Pixels):', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'paddingBottom' ); ?>" name="<?php echo $this->get_field_name( 'paddingBottom' ); ?>" type="text" value="<?php echo esc_attr($paddingBottom); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'paddingRight' ); ?>"><?php _e( 'Padding Right (in Pixels):', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'paddingRight' ); ?>" name="<?php echo $this->get_field_name( 'paddingRight' ); ?>" type="text" value="<?php echo esc_attr($paddingRight); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'titleClass' ); ?>"><?php _e( 'Title CSS Class:', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'titleClass' ); ?>" name="<?php echo $this->get_field_name( 'titleClass' ); ?>" type="text" value="<?php echo esc_attr($titleClass); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'iconClass' ); ?>"><?php _e( 'Icon CSS Class:', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'iconClass' ); ?>" name="<?php echo $this->get_field_name( 'iconClass' ); ?>" type="text" value="<?php echo esc_attr($iconClass); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'text' ); ?>"><?php _e( 'Text:', 'aya' ); ?></label> 
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'text' ); ?>" name="<?php echo $this->get_field_name( 'text' ); ?>"><?php echo esc_attr($text); ?></textarea>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'textClass' ); ?>"><?php _e( 'Text CSS Class:', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'textClass' ); ?>" name="<?php echo $this->get_field_name( 'textClass' ); ?>" type="text" value="<?php echo esc_attr($textClass); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'url' ); ?>"><?php _e( 'URL:', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'url' ); ?>" name="<?php echo $this->get_field_name( 'url' ); ?>" type="text" value="<?php echo esc_attr($url); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'linkText' ); ?>"><?php _e( 'Link Text:', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'linkText' ); ?>" name="<?php echo $this->get_field_name( 'linkText' ); ?>" type="text" value="<?php echo esc_attr($linkText); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'linkClass' ); ?>"><?php _e( 'Link CSS Class:', 'aya' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'linkClass' ); ?>" name="<?php echo $this->get_field_name( 'linkClass' ); ?>" type="text" value="<?php echo esc_attr($linkClass); ?>" />
		</p>
<?php 
	}
	
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance[ 'title' ] = (!empty( $new_instance[ 'title' ])) ? strip_tags($new_instance[ 'title' ]) : '';
		$instance[ 'titleClass' ] = (!empty( $new_instance[ 'titleClass' ])) ? strip_tags($new_instance[ 'titleClass' ]) : '';
		$instance[ 'iconClass' ] = (!empty( $new_instance[ 'iconClass' ])) ? strip_tags($new_instance[ 'iconClass' ]) : '';
		$instance[ 'text' ] = (!empty( $new_instance[ 'text' ])) ? $new_instance[ 'text' ] : '';
		$instance[ 'textClass' ] = (!empty( $new_instance[ 'textClass' ])) ? $new_instance[ 'textClass' ] : '';
		$instance[ 'linkText' ] = (!empty( $new_instance[ 'linkText' ])) ? strip_tags($new_instance[ 'linkText' ]) : '';
		$instance[ 'linkClass' ] = (!empty( $new_instance[ 'linkClass' ])) ? strip_tags($new_instance[ 'linkClass' ]) : '';
		$instance[ 'url' ] = (!empty( $new_instance[ 'url' ])) ? strip_tags($new_instance[ 'url' ]) : '';
		$instance[ 'backgroundImage' ] = (!empty( $new_instance[ 'backgroundImage' ])) ? strip_tags($new_instance[ 'backgroundImage' ]) : '';
		$instance[ 'centerBackgroundImg' ] = (!empty($new_instance[ 'centerBackgroundImg' ])) ? strip_tags($new_instance[ 'centerBackgroundImg' ]) : '';

		$instance[ 'paddingTop' ] = (!empty( $new_instance[ 'paddingTop' ])) ? strip_tags($new_instance[ 'paddingTop' ]) : '';
		$instance[ 'paddingLeft' ] = (!empty( $new_instance[ 'paddingLeft' ])) ? strip_tags($new_instance[ 'paddingLeft' ]) : '';
		$instance[ 'paddingBottom' ] = (!empty( $new_instance[ 'paddingBottom' ])) ? strip_tags($new_instance[ 'paddingBottom' ]) : '';
		$instance[ 'paddingRight' ] = (!empty( $new_instance[ 'paddingRight' ])) ? strip_tags($new_instance[ 'paddingRight' ]) : '';

		return $instance;
	}
}

/*
 * Advanced Text 2 Columns Widget class
 */
class aya_AdvancedTextContentTwoColumns_Widget extends WP_Widget {

	const NUMBER_OF_COLUMNS = 2;

	function __construct() {
	parent::__construct(
		// Base ID of Advanced Text 2 Columns widget
		'aya_AdvancedTextContentTwoColumns_Widget', 

		// Advanced Text 2 Columns Widget name will appear in UI
		__( 'Advanced Text (2 Columns)', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Arbitrary text or HTML with additional display options displayed in 2 Columns', 'aya' )) 
		);

		add_action('admin_enqueue_scripts', array($this, 'upload_scripts'));
	}

	/**
     * Upload the Javascripts for the media uploader
     */
    public function upload_scripts() {

        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');
        wp_enqueue_script('aya_upload_media_widget', get_template_directory_uri() . '/js/upload-media.js', array( 'jquery' ) );

        wp_enqueue_style('thickbox');
    }

	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {
			
		echo '<div class="clear"></div>';

		$centerBackgroundImg = isset($instance[ 'centerBackgroundImg' ]) ? $instance[ 'centerBackgroundImg' ] : true;

		// Display the output

		echo '<div';

		$wrapperCss = '';

		if ( array_key_exists( 'backgroundImage', $instance ) && ( $instance[ 'backgroundImage' ] != '' ) ) {

			$wrapperCss .= "background-image:url('" . $instance[ 'backgroundImage' ] . "');";

			$wrapperCss .= ' max-width:100%;height:auto;';

			if ( $centerBackgroundImg ) {

				$wrapperCss .= ' background-position: top center;';
			}

			$wrapperCss .= ' background-repeat:no-repeat;';
		}

		if ( $wrapperCss != '' ) {

			echo ' style="' . $wrapperCss . '"';
		}

		echo '>'; // end of div tag
		
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];
		
		$chars = array( 'a', 'b', 'c', 'd' );
		
		for ( $i = 1; $i <= self::NUMBER_OF_COLUMNS; ++$i) {

			$wrapperCss = '';

			if ( array_key_exists( 'paddingTop' . $i, $instance ) && ( $instance[ 'paddingTop' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-top:' . $instance[ 'paddingTop' . $i ] . 'px;';
			}

			if ( array_key_exists( 'paddingLeft' . $i, $instance ) && ( $instance[ 'paddingLeft' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-left:' . $instance[ 'paddingLeft' . $i ] . 'px;';
			}

			if ( array_key_exists( 'paddingBottom' . $i, $instance ) && ( $instance[ 'paddingBottom' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-bottom:' . $instance[ 'paddingBottom' . $i ] . 'px;';
			}

			if ( array_key_exists( 'paddingRight' . $i, $instance ) && ( $instance[ 'paddingRight' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-right:' . $instance[ 'paddingRight' . $i ] . 'px;';
			}

		
			// Display Column #i
			echo '<div class="col'.(self::NUMBER_OF_COLUMNS).($chars[$i - 1]).'"';

			if ( $wrapperCss != '' ) {

				echo ' style="' . $wrapperCss . '"';
			}

			echo '>';
			
			$titleCol = apply_filters( 'widget_title', array_key_exists( 'titleCol' . $i, $instance ) ? $instance[ 'titleCol' . $i ] : '');
			if ( !empty($titleCol) ) {

				$titleClassExists = array_key_exists( 'titleClassCol' . $i, $instance ) && ( $instance[ 'titleClassCol' . $i ] != '' );
				if ( $titleClassExists ) {
					echo '<div class="'.$instance[ 'titleClassCol' . $i ].'">';
				}
				
				// Display the output
				echo $args[ 'before_title' ];
				
				echo '<i class="advanced-text-icon '.$instance[ 'iconClassCol' . $i ].'"></i> ';
				
				echo $titleCol;

				echo $args[ 'after_title' ];
				
				if ( $titleClassExists ) {
					echo '</div>';
				}
			}
			
			if ( array_key_exists( 'textClassCol' . $i, $instance ) && ( $instance[ 'textClassCol' . $i ] != '' ) ) {
			
				echo '<div class="advanced-text-content '.$instance[ 'textClassCol' . $i ].'">'.$instance[ 'textCol' . $i ].'</div>';
				
			} else {
			
				echo '<div class="advanced-text-content">'.$instance[ 'textCol' . $i ].'</div>';
			}
			
			if ( array_key_exists( 'urlCol' . $i, $instance ) && array_key_exists( 'linkTextCol' . $i, $instance ) 
				 && ( $instance[ 'urlCol' . $i ] != '' ) && ( $instance[ 'linkTextCol' . $i ] != '' ) ) {
				 
				 echo '<div class="advanced-text-button-wrapper">';
			
				if ( array_key_exists( 'linkClassCol' . $i, $instance ) && ( $instance[ 'linkClassCol' . $i ] != '' ) ) {
				
					echo '<a href="'.$instance[ 'urlCol' . $i ].'" title="'.$instance[ 'linkTextCol' . $i ].'" class="btn '.$instance[ 'linkClassCol' . $i ].'">'.$instance[ 'linkTextCol' . $i ].'</a>';
				
				} else {
					
					echo '<a href="'.$instance[ 'urlCol' . $i ].'" title="'.$instance[ 'linkTextCol' . $i ].'" class="btn">'.$instance[ 'linkTextCol' . $i ].'</a>';
				}
				
				echo '</div>';			
			}
			
			// Column #i end
			echo '</div>';
		}

		echo $args[ 'after_widget' ];

		echo '<div class="clear"></div></div>';
	}
		
	// Widget Backend
	public function form($instance) {

		$backgroundImage = isset( $instance['backgroundImage'] ) ? $instance['backgroundImage'] : '';
		$centerBackgroundImg = isset( $instance['centerBackgroundImg'] ) ? $instance['centerBackgroundImg'] : 1;
?>
		<p>
			<label for="<?php echo $this->get_field_name( 'backgroundImage' ); ?>"><?php _e( 'Background Image:', 'aya' ); ?></label>
			<?php $uploadBtnText = $this->get_field_name( 'backgroundImage' ) ? __('Change Image', 'aya') : __('Upload Image', 'aya'); ?>
            <input name="<?php echo $this->get_field_name( 'backgroundImage' ); ?>"
            		id="<?php echo $this->get_field_id( 'backgroundImage' ); ?>" class="widefat" type="text" size="36"
            		value="<?php echo esc_url( $backgroundImage ); ?>" />
            <input class="upload_image_button button button-primary" type="button" value="<?php echo $uploadBtnText; ?>" />
        </p>
        <p>
		<input class="checkbox" type="checkbox" <?php checked((bool)(isset($instance[ 'centerBackgroundImg' ]) ? $instance[ 'centerBackgroundImg' ] : 1), true); ?> id="<?php echo $this->get_field_id( 'centerBackgroundImg' ); ?>" name="<?php echo $this->get_field_name( 'centerBackgroundImg' ); ?>" />
		<br /><span class='description'><?php _e( 'Center Background Image', 'aya' ) ?></span>
		</p>
<?php
		for ( $i = 1; $i <= self::NUMBER_OF_COLUMNS; ++$i) {

			$paddingTop = isset( $instance['paddingTop' . $i] ) ? $instance['paddingTop' . $i] : '';
			$paddingLeft = isset( $instance['paddingLeft' . $i] ) ? $instance['paddingLeft' . $i] : '';
			$paddingBottom = isset( $instance['paddingBottom' . $i] ) ? $instance['paddingBottom' . $i] : '';
			$paddingRight = isset( $instance['paddingRight' . $i] ) ? $instance['paddingRight' . $i] : '';
	
			// title
			if (isset($instance[ 'titleCol' . $i ])) {
				$title = $instance[ 'titleCol' . $i ];
			} else {
				$title = '';
			}
			
			// title class
			if (isset($instance[ 'titleClassCol' . $i ])) {
				$titleClass = $instance[ 'titleClassCol' . $i ];
			}
			else {
				$titleClass = '';
			}
			
			// icon class
			if (isset($instance[ 'iconClassCol' . $i ])) {
				$iconClass = $instance[ 'iconClassCol' . $i ];
			}
			else {
				$iconClass = __( 'fa fa-smile-o', 'aya' );
			}
			
			// text
			if (isset($instance[ 'textCol' . $i ])) {
				$text = $instance[ 'textCol' . $i ];
			} else {
				$text = '';
			}
			
			// text class
			if (isset($instance[ 'textClassCol' . $i ])) {
				$textClass = $instance[ 'textClassCol' . $i ];
			}
			else {
				$textClass = '';
			}
			
			// url
			if (isset($instance[ 'urlCol' . $i ])) {
				$url = $instance[ 'urlCol' . $i ];
			} else {
				$url = '';
			}
			
			// link text
			if (isset($instance[ 'linkTextCol' . $i ])) {
				$linkText = $instance[ 'linkTextCol' . $i ];
			}
			else {
				$linkText = __( 'Details', 'aya' );
			}
			
			// link class
			if (isset($instance[ 'linkClassCol' . $i ])) {
				$linkClass = $instance[ 'linkClassCol' . $i ];
			}
			else {
				$linkClass = '';
			}
			
			// Widget admin form
	?>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingTop' . $i ); ?>"><?php printf( __( 'Padding Top in Pixels (Column #%s):', 'aya' ), $i ); ?></label>  
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingTop' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingTop' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingTop); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingLeft' . $i ); ?>"><?php printf( __( 'Padding Left in Pixels (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingLeft' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingLeft' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingLeft); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingBottom' . $i ); ?>"><?php printf( __( 'Padding Bottom in Pixels (Column #%s):', 'aya' ), $i ); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingBottom' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingBottom' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingBottom); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingRight' . $i ); ?>"><?php printf( __( 'Padding Right in Pixels (Column #%s):', 'aya' ), $i ); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingRight' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingRight' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingRight); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'titleCol' . $i ); ?>"><?php printf( __( 'Title (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'titleCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'titleCol' . $i ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'titleClassCol' . $i ); ?>"><?php printf( __( 'Title CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'titleClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'titleClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($titleClass); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'iconClassCol' . $i ); ?>"><?php printf( __( 'Icon CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'iconClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'iconClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($iconClass); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'textCol' . $i ); ?>"><?php printf( __( 'Text (Column #%s):', 'aya' ), $i ); ?></label> 
				<textarea class="widefat" id="<?php echo $this->get_field_id( 'textCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'textCol' . $i ); ?>"><?php echo esc_attr($text); ?></textarea>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'textClassCol' . $i ); ?>"><?php printf( __( 'Text CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'textClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'textClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($textClass); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'urlCol' . $i ); ?>"><?php printf( __( 'URL (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'urlCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'urlCol' . $i ); ?>" type="text" value="<?php echo esc_attr($url); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'linkTextCol' . $i ); ?>"><?php printf( __( 'Link Text (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'linkTextCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'linkTextCol' . $i ); ?>" type="text" value="<?php echo esc_attr($linkText); ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'linkClassCol' . $i ); ?>"><?php printf( __( 'Link CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'linkClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'linkClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($linkClass); ?>" />
			</p>
<?php
		}
	}
	
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();

		$instance[ 'backgroundImage' ] = (!empty( $new_instance[ 'backgroundImage' ])) ? strip_tags($new_instance[ 'backgroundImage' ]) : '';
		$instance[ 'centerBackgroundImg' ] = (!empty($new_instance[ 'centerBackgroundImg' ])) ? strip_tags($new_instance[ 'centerBackgroundImg' ]) : '';
		
		for ( $i = 1; $i <= self::NUMBER_OF_COLUMNS; ++$i) {
		
			$instance[ 'titleCol' . $i ]     = (!empty( $new_instance[ 'titleCol' . $i ])) ? strip_tags($new_instance[ 'titleCol' . $i ]) : '';
			$instance[ 'titleClassCol' . $i ] = (!empty( $new_instance[ 'titleClassCol' . $i ])) ? strip_tags($new_instance[ 'titleClassCol' . $i ]) : '';
			$instance[ 'iconClassCol' . $i ] = (!empty( $new_instance[ 'iconClassCol' . $i ])) ? strip_tags($new_instance[ 'iconClassCol' . $i ]) : '';
			$instance[ 'textCol' . $i ]      = (!empty( $new_instance[ 'textCol' . $i ])) ? $new_instance[ 'textCol' . $i ] : '';
			$instance[ 'textClassCol' . $i ] = (!empty( $new_instance[ 'textClassCol' . $i ])) ? $new_instance[ 'textClassCol' . $i ] : '';
			$instance[ 'linkTextCol' . $i ]  = (!empty( $new_instance[ 'linkTextCol' . $i ])) ? strip_tags($new_instance[ 'linkTextCol' . $i ]) : '';
			$instance[ 'linkClassCol' . $i ] = (!empty( $new_instance[ 'linkClassCol' . $i ])) ? strip_tags($new_instance[ 'linkClassCol' . $i ]) : '';
			$instance[ 'urlCol' . $i ]       = (!empty( $new_instance[ 'urlCol' . $i ])) ? strip_tags($new_instance[ 'urlCol' . $i ]) : '';

			$instance[ 'paddingTop' . $i ] = (!empty( $new_instance[ 'paddingTop' . $i ])) ?
													strip_tags($new_instance[ 'paddingTop' . $i ]) : '';
			$instance[ 'paddingLeft' . $i ] = (!empty( $new_instance[ 'paddingLeft' . $i ])) ?
													strip_tags($new_instance[ 'paddingLeft' . $i ]) : '';
			$instance[ 'paddingBottom' . $i ] = (!empty( $new_instance[ 'paddingBottom' . $i ])) ?
													strip_tags($new_instance[ 'paddingBottom' . $i ]) : '';
			$instance[ 'paddingRight' . $i ] = (!empty( $new_instance[ 'paddingRight' . $i ])) ?
													strip_tags($new_instance[ 'paddingRight' . $i ]) : '';
		}

		return $instance;
	}
}

/*
 * Advanced Text 3 Columns Widget class
 */ 
class aya_AdvancedTextContentThreeColumns_Widget extends WP_Widget {

	const NUMBER_OF_COLUMNS = 3;

	function __construct() {
	parent::__construct(
		// Base ID of Advanced Text 3 Columns widget
		'aya_AdvancedTextContentThreeColumns_Widget', 

		// Advanced Text 3 Columns Widget name will appear in UI
		__( 'Advanced Text (3 Columns)', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Arbitrary text or HTML with additional display options displayed in 3 Columns', 'aya' )) 
		);

		add_action('admin_enqueue_scripts', array($this, 'upload_scripts'));
	}

	/**
     * Upload the Javascripts for the media uploader
     */
    public function upload_scripts() {

        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');
        wp_enqueue_script('aya_upload_media_widget', get_template_directory_uri() . '/js/upload-media.js', array( 'jquery' ) );

        wp_enqueue_style('thickbox');
    }


	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {
			
		echo '<div class="clear"></div>';

		$centerBackgroundImg = isset($instance[ 'centerBackgroundImg' ]) ? $instance[ 'centerBackgroundImg' ] : true;

		// Display the output

		echo '<div';

		$wrapperCss = '';

		if ( array_key_exists( 'backgroundImage', $instance ) && ( $instance[ 'backgroundImage' ] != '' ) ) {

			$wrapperCss .= "background-image:url('" . $instance[ 'backgroundImage' ] . "');";

			$wrapperCss .= ' max-width:100%;height:auto;';

			if ( $centerBackgroundImg ) {

				$wrapperCss .= ' background-position: top center;';
			}

			$wrapperCss .= ' background-repeat:no-repeat;';
		}

		if ( $wrapperCss != '' ) {

			echo ' style="' . $wrapperCss . '"';
		}

		echo '>'; // end of div tag
		
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];
		
		$chars = array( 'a', 'b', 'c', 'd' );
		
		for ( $i = 1; $i <= self::NUMBER_OF_COLUMNS; ++$i) {
		
			// Display Column #i
			$wrapperCss = '';

			if ( array_key_exists( 'paddingTop' . $i, $instance ) && ( $instance[ 'paddingTop' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-top:' . $instance[ 'paddingTop' . $i ] . 'px;';
			}

			if ( array_key_exists( 'paddingLeft' . $i, $instance ) && ( $instance[ 'paddingLeft' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-left:' . $instance[ 'paddingLeft' . $i ] . 'px;';
			}

			if ( array_key_exists( 'paddingBottom' . $i, $instance ) && ( $instance[ 'paddingBottom' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-bottom:' . $instance[ 'paddingBottom' . $i ] . 'px;';
			}

			if ( array_key_exists( 'paddingRight' . $i, $instance ) && ( $instance[ 'paddingRight' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-right:' . $instance[ 'paddingRight' . $i ] . 'px;';
			}

		
			// Display Column #i
			echo '<div class="col'.(self::NUMBER_OF_COLUMNS).($chars[$i - 1]).'"';

			if ( $wrapperCss != '' ) {

				echo ' style="' . $wrapperCss . '"';
			}

			echo '>';

			$titleCol = apply_filters( 'widget_title', array_key_exists( 'titleCol' . $i, $instance ) ? $instance[ 'titleCol' . $i ] : '');
			if ( !empty($titleCol) ) {
			
				$titleClassExists = array_key_exists( 'titleClassCol' . $i, $instance ) && ( $instance[ 'titleClassCol' . $i ] != '' );
				if ( $titleClassExists ) {
					echo '<div class="'.$instance[ 'titleClassCol' . $i ].'">';
				}
				
				// Display the output
				echo $args[ 'before_title' ];
				
				echo '<i class="advanced-text-icon '.$instance[ 'iconClassCol' . $i ].'"></i> ';
				
					echo $titleCol;
				

				echo $args[ 'after_title' ];
				
				if ( $titleClassExists ) {
					echo '</div>';
				}
			}
			
			if ( array_key_exists( 'textClassCol' . $i, $instance ) && ( $instance[ 'textClassCol' . $i ] != '' ) ) {
			
				echo '<div class="advanced-text-content '.$instance[ 'textClassCol' . $i ].'">'.$instance[ 'textCol' . $i ].'</div>';
				
			} else {
			
				echo '<div class="advanced-text-content">'.$instance[ 'textCol' . $i ].'</div>';
			}
			
			if ( array_key_exists( 'urlCol' . $i, $instance ) && array_key_exists( 'linkTextCol' . $i, $instance ) 
				 && ( $instance[ 'urlCol' . $i ] != '' ) && ( $instance[ 'linkTextCol' . $i ] != '' ) ) {
				 
				 echo '<div class="advanced-text-button-wrapper">';
			
				if ( array_key_exists( 'linkClassCol' . $i, $instance ) && ( $instance[ 'linkClassCol' . $i ] != '' ) ) {
				
					echo '<a href="'.$instance[ 'urlCol' . $i ].'" title="'.$instance[ 'linkTextCol' . $i ].'" class="btn '.$instance[ 'linkClassCol' . $i ].'">'.$instance[ 'linkTextCol' . $i ].'</a>';
				
				} else {
					
					echo '<a href="'.$instance[ 'urlCol' . $i ].'" title="'.$instance[ 'linkTextCol' . $i ].'" class="btn">'.$instance[ 'linkTextCol' . $i ].'</a>';
				}
				
				echo '</div>';			
			}
			
			// Column #i end
			echo '</div>';
		}

		echo $args[ 'after_widget' ];

		echo '<div class="clear"></div></div>';
	}
		
	// Widget Backend
	public function form($instance) {

		$backgroundImage = isset( $instance['backgroundImage'] ) ? $instance['backgroundImage'] : '';
		$centerBackgroundImg = isset( $instance['centerBackgroundImg'] ) ? $instance['centerBackgroundImg'] : 1;
?>
		<p>
			<label for="<?php echo $this->get_field_name( 'backgroundImage' ); ?>"><?php _e( 'Background Image:', 'aya' ); ?></label>
			<?php $uploadBtnText = $this->get_field_name( 'backgroundImage' ) ? __('Change Image', 'aya') : __('Upload Image', 'aya'); ?>
            <input name="<?php echo $this->get_field_name( 'backgroundImage' ); ?>"
            		id="<?php echo $this->get_field_id( 'backgroundImage' ); ?>" class="widefat" type="text" size="36"
            		value="<?php echo esc_url( $backgroundImage ); ?>" />
            <input class="upload_image_button button button-primary" type="button" value="<?php echo $uploadBtnText; ?>" />
        </p>
        <p>
		<input class="checkbox" type="checkbox" <?php checked((bool)(isset($instance[ 'centerBackgroundImg' ]) ? $instance[ 'centerBackgroundImg' ] : 1), true); ?> id="<?php echo $this->get_field_id( 'centerBackgroundImg' ); ?>" name="<?php echo $this->get_field_name( 'centerBackgroundImg' ); ?>" />
		<br /><span class='description'><?php _e( 'Center Background Image', 'aya' ) ?></span>
		</p>
<?php
	
		for ( $i = 1; $i <= self::NUMBER_OF_COLUMNS; ++$i) {

			$paddingTop = isset( $instance['paddingTop' . $i] ) ? $instance['paddingTop' . $i] : '';
			$paddingLeft = isset( $instance['paddingLeft' . $i] ) ? $instance['paddingLeft' . $i] : '';
			$paddingBottom = isset( $instance['paddingBottom' . $i] ) ? $instance['paddingBottom' . $i] : '';
			$paddingRight = isset( $instance['paddingRight' . $i] ) ? $instance['paddingRight' . $i] : '';
	
			// title
			if (isset($instance[ 'titleCol' . $i ])) {
				$title = $instance[ 'titleCol' . $i ];
			} else {
				$title = '';
			}
			
			// title class
			if (isset($instance[ 'titleClassCol' . $i ])) {
				$titleClass = $instance[ 'titleClassCol' . $i ];
			}
			else {
				$titleClass = '';
			}
			
			// icon class
			if (isset($instance[ 'iconClassCol' . $i ])) {
				$iconClass = $instance[ 'iconClassCol' . $i ];
			}
			else {
				$iconClass = __( 'fa fa-smile-o', 'aya' );
			}
			
			// text
			if (isset($instance[ 'textCol' . $i ])) {
				$text = $instance[ 'textCol' . $i ];
			} else {
				$text = '';
			}
			
			// text class
			if (isset($instance[ 'textClassCol' . $i ])) {
				$textClass = $instance[ 'textClassCol' . $i ];
			}
			else {
				$textClass = '';
			}
			
			// url
			if (isset($instance[ 'urlCol' . $i ])) {
				$url = $instance[ 'urlCol' . $i ];
			} else {
				$url = '';
			}
			
			// link text
			if (isset($instance[ 'linkTextCol' . $i ])) {
				$linkText = $instance[ 'linkTextCol' . $i ];
			}
			else {
				$linkText = __( 'Details', 'aya' );
			}
			
			// link class
			if (isset($instance[ 'linkClassCol' . $i ])) {
				$linkClass = $instance[ 'linkClassCol' . $i ];
			}
			else {
				$linkClass = '';
			}
			
			// Widget admin form
	?>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingTop' . $i ); ?>"><?php printf( __( 'Padding Top in Pixels (Column #%s):', 'aya' ), $i ); ?></label>  
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingTop' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingTop' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingTop); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingLeft' . $i ); ?>"><?php printf( __( 'Padding Left in Pixels (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingLeft' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingLeft' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingLeft); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingBottom' . $i ); ?>"><?php printf( __( 'Padding Bottom in Pixels (Column #%s):', 'aya' ), $i ); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingBottom' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingBottom' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingBottom); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingRight' . $i ); ?>"><?php printf( __( 'Padding Right in Pixels (Column #%s):', 'aya' ), $i ); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingRight' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingRight' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingRight); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'titleCol' . $i ); ?>"><?php printf( __( 'Title (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'titleCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'titleCol' . $i ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'titleClassCol' . $i ); ?>"><?php printf( __( 'Title CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'titleClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'titleClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($titleClass); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'iconClassCol' . $i ); ?>"><?php printf( __( 'Icon CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'iconClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'iconClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($iconClass); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'textCol' . $i ); ?>"><?php printf( __( 'Text (Column #%s):', 'aya' ), $i ); ?></label> 
				<textarea class="widefat" id="<?php echo $this->get_field_id( 'textCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'textCol' . $i ); ?>"><?php echo esc_attr($text); ?></textarea>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'textClassCol' . $i ); ?>"><?php printf( __( 'Text CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'textClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'textClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($textClass); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'urlCol' . $i ); ?>"><?php printf( __( 'URL (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'urlCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'urlCol' . $i ); ?>" type="text" value="<?php echo esc_attr($url); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'linkTextCol' . $i ); ?>"><?php printf( __( 'Link Text (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'linkTextCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'linkTextCol' . $i ); ?>" type="text" value="<?php echo esc_attr($linkText); ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'linkClassCol' . $i ); ?>"><?php printf( __( 'Link CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'linkClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'linkClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($linkClass); ?>" />
			</p>
<?php
		}
	}
	
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();

		$instance[ 'backgroundImage' ] = (!empty( $new_instance[ 'backgroundImage' ])) ? strip_tags($new_instance[ 'backgroundImage' ]) : '';
		$instance[ 'centerBackgroundImg' ] = (!empty($new_instance[ 'centerBackgroundImg' ])) ? strip_tags($new_instance[ 'centerBackgroundImg' ]) : '';
		
		for ( $i = 1; $i <= self::NUMBER_OF_COLUMNS; ++$i) {
		
			$instance[ 'titleCol' . $i ]     = (!empty( $new_instance[ 'titleCol' . $i ])) ? strip_tags($new_instance[ 'titleCol' . $i ]) : '';
			$instance[ 'titleClassCol' . $i ] = (!empty( $new_instance[ 'titleClassCol' . $i ])) ? strip_tags($new_instance[ 'titleClassCol' . $i ]) : '';
			$instance[ 'iconClassCol' . $i ] = (!empty( $new_instance[ 'iconClassCol' . $i ])) ? strip_tags($new_instance[ 'iconClassCol' . $i ]) : '';
			$instance[ 'textCol' . $i ]      = (!empty( $new_instance[ 'textCol' . $i ])) ? $new_instance[ 'textCol' . $i ] : '';
			$instance[ 'textClassCol' . $i ] = (!empty( $new_instance[ 'textClassCol' . $i ])) ? $new_instance[ 'textClassCol' . $i ] : '';
			$instance[ 'linkTextCol' . $i ]  = (!empty( $new_instance[ 'linkTextCol' . $i ])) ? strip_tags($new_instance[ 'linkTextCol' . $i ]) : '';
			$instance[ 'linkClassCol' . $i ] = (!empty( $new_instance[ 'linkClassCol' . $i ])) ? strip_tags($new_instance[ 'linkClassCol' . $i ]) : '';
			$instance[ 'urlCol' . $i ]       = (!empty( $new_instance[ 'urlCol' . $i ])) ? strip_tags($new_instance[ 'urlCol' . $i ]) : '';

			$instance[ 'paddingTop' . $i ] = (!empty( $new_instance[ 'paddingTop' . $i ])) ?
													strip_tags($new_instance[ 'paddingTop' . $i ]) : '';
			$instance[ 'paddingLeft' . $i ] = (!empty( $new_instance[ 'paddingLeft' . $i ])) ?
													strip_tags($new_instance[ 'paddingLeft' . $i ]) : '';
			$instance[ 'paddingBottom' . $i ] = (!empty( $new_instance[ 'paddingBottom' . $i ])) ?
													strip_tags($new_instance[ 'paddingBottom' . $i ]) : '';
			$instance[ 'paddingRight' . $i ] = (!empty( $new_instance[ 'paddingRight' . $i ])) ?
													strip_tags($new_instance[ 'paddingRight' . $i ]) : '';
		}

		return $instance;
	}
}

/**
 * Advanced Text 4 Columns Widget Class
 */
class aya_AdvancedTextContentFourColumns_Widget extends WP_Widget {

	const NUMBER_OF_COLUMNS = 4;

	function __construct() {
	parent::__construct(
		// Base ID of Advanced Text 4 Columns widget
		'aya_AdvancedTextContentFourColumns_Widget', 

		// Advanced Text 4 Columns Widget name will appear in UI
		__( 'Advanced Text (4 Columns)', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Arbitrary text or HTML with additional display options displayed in 4 Columns', 'aya' )) 
		);

		add_action('admin_enqueue_scripts', array($this, 'upload_scripts'));
	}

	/**
     * Upload the Javascripts for the media uploader
     */
    public function upload_scripts() {

        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');
        wp_enqueue_script('aya_upload_media_widget', get_template_directory_uri() . '/js/upload-media.js', array( 'jquery' ) );

        wp_enqueue_style('thickbox');
    }


	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {
			
		echo '<div class="clear"></div>';

		$centerBackgroundImg = isset($instance[ 'centerBackgroundImg' ]) ? $instance[ 'centerBackgroundImg' ] : true;

		// Display the output

		echo '<div';

		$wrapperCss = '';

		if ( array_key_exists( 'backgroundImage', $instance ) && ( $instance[ 'backgroundImage' ] != '' ) ) {

			$wrapperCss .= "background-image:url('" . $instance[ 'backgroundImage' ] . "');";

			$wrapperCss .= ' max-width:100%;height:auto;';

			if ( $centerBackgroundImg ) {

				$wrapperCss .= ' background-position: top center;';
			}

			$wrapperCss .= ' background-repeat:no-repeat;';
		}

		if ( $wrapperCss != '' ) {

			echo ' style="' . $wrapperCss . '"';
		}

		echo '>'; // end of div tag
		
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];
		
		$chars = array( 'a', 'b', 'c', 'd' );
		
		for ( $i = 1; $i <= self::NUMBER_OF_COLUMNS; ++$i) {
		
			// Display Column #i
			$wrapperCss = '';

			if ( array_key_exists( 'paddingTop' . $i, $instance ) && ( $instance[ 'paddingTop' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-top:' . $instance[ 'paddingTop' . $i ] . 'px;';
			}

			if ( array_key_exists( 'paddingLeft' . $i, $instance ) && ( $instance[ 'paddingLeft' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-left:' . $instance[ 'paddingLeft' . $i ] . 'px;';
			}

			if ( array_key_exists( 'paddingBottom' . $i, $instance ) && ( $instance[ 'paddingBottom' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-bottom:' . $instance[ 'paddingBottom' . $i ] . 'px;';
			}

			if ( array_key_exists( 'paddingRight' . $i, $instance ) && ( $instance[ 'paddingRight' . $i ] != '' ) ) {
				$wrapperCss .= ' padding-right:' . $instance[ 'paddingRight' . $i ] . 'px;';
			}

		
			// Display Column #i
			echo '<div class="col'.(self::NUMBER_OF_COLUMNS).($chars[$i - 1]).'"';

			if ( $wrapperCss != '' ) {

				echo ' style="' . $wrapperCss . '"';
			}

			echo '>';

			$titleCol = apply_filters( 'widget_title', array_key_exists( 'titleCol' . $i, $instance ) ? $instance[ 'titleCol' . $i ] : '');
			if ( !empty($titleCol) ) {
				
				$titleClassExists = array_key_exists( 'titleClassCol' . $i, $instance ) && ( $instance[ 'titleClassCol' . $i ] != '' );
				if ( $titleClassExists ) {
					echo '<div class="'.$instance[ 'titleClassCol' . $i ].'">';
				}
				
				// Display the output
				echo $args[ 'before_title' ];
				
				echo '<i class="advanced-text-icon '.$instance[ 'iconClassCol' . $i ].'"></i> ';
				
					echo $titleCol;

				echo $args[ 'after_title' ];
				
				if ( $titleClassExists ) {
					echo '</div>';
				}
			}
			
			if ( array_key_exists( 'textClassCol' . $i, $instance ) && ( $instance[ 'textClassCol' . $i ] != '' ) ) {
			
				echo '<div class="advanced-text-content '.$instance[ 'textClassCol' . $i ].'">'.$instance[ 'textCol' . $i ].'</div>';
				
			} else {
			
				echo '<div class="advanced-text-content">'.$instance[ 'textCol' . $i ].'</div>';
			}
			
			if ( array_key_exists( 'urlCol' . $i, $instance ) && array_key_exists( 'linkTextCol' . $i, $instance ) 
				 && ( $instance[ 'urlCol' . $i ] != '' ) && ( $instance[ 'linkTextCol' . $i ] != '' ) ) {
				 
				 echo '<div class="advanced-text-button-wrapper">';
			
				if ( array_key_exists( 'linkClassCol' . $i, $instance ) && ( $instance[ 'linkClassCol' . $i ] != '' ) ) {
				
					echo '<a href="'.$instance[ 'urlCol' . $i ].'" title="'.$instance[ 'linkTextCol' . $i ].'" class="btn '.$instance[ 'linkClassCol' . $i ].'">'.$instance[ 'linkTextCol' . $i ].'</a>';
				
				} else {
					
					echo '<a href="'.$instance[ 'urlCol' . $i ].'" title="'.$instance[ 'linkTextCol' . $i ].'" class="btn">'.$instance[ 'linkTextCol' . $i ].'</a>';
				}
				
				echo '</div>';			
			}
			
			// Column #i end
			echo '</div>';
		}

		echo $args[ 'after_widget' ];

		echo '<div class="clear"></div></div>';
	}
		
	// Widget Backend
	public function form($instance) {

		$backgroundImage = isset( $instance['backgroundImage'] ) ? $instance['backgroundImage'] : '';
		$centerBackgroundImg = isset( $instance['centerBackgroundImg'] ) ? $instance['centerBackgroundImg'] : 1;
?>
		<p>
			<label for="<?php echo $this->get_field_name( 'backgroundImage' ); ?>"><?php _e( 'Background Image:', 'aya' ); ?></label>
			<?php $uploadBtnText = $this->get_field_name( 'backgroundImage' ) ? __('Change Image', 'aya') : __('Upload Image', 'aya'); ?>
            <input name="<?php echo $this->get_field_name( 'backgroundImage' ); ?>"
            		id="<?php echo $this->get_field_id( 'backgroundImage' ); ?>" class="widefat" type="text" size="36"
            		value="<?php echo esc_url( $backgroundImage ); ?>" />
            <input class="upload_image_button button button-primary" type="button" value="<?php echo $uploadBtnText; ?>" />
        </p>
        <p>
		<input class="checkbox" type="checkbox" <?php checked((bool)(isset($instance[ 'centerBackgroundImg' ]) ? $instance[ 'centerBackgroundImg' ] : 1), true); ?> id="<?php echo $this->get_field_id( 'centerBackgroundImg' ); ?>" name="<?php echo $this->get_field_name( 'centerBackgroundImg' ); ?>" />
		<br /><span class='description'><?php _e( 'Center Background Image', 'aya' ) ?></span>
		</p>
<?php
	
		for ( $i = 1; $i <= self::NUMBER_OF_COLUMNS; ++$i) {

			$paddingTop = isset( $instance['paddingTop' . $i] ) ? $instance['paddingTop' . $i] : '';
			$paddingLeft = isset( $instance['paddingLeft' . $i] ) ? $instance['paddingLeft' . $i] : '';
			$paddingBottom = isset( $instance['paddingBottom' . $i] ) ? $instance['paddingBottom' . $i] : '';
			$paddingRight = isset( $instance['paddingRight' . $i] ) ? $instance['paddingRight' . $i] : '';
	
			// title
			if (isset($instance[ 'titleCol' . $i ])) {
				$title = $instance[ 'titleCol' . $i ];
			} else {
				$title = '';
			}
			
			// title class
			if (isset($instance[ 'titleClassCol' . $i ])) {
				$titleClass = $instance[ 'titleClassCol' . $i ];
			}
			else {
				$titleClass = '';
			}
			
			// icon class
			if (isset($instance[ 'iconClassCol' . $i ])) {
				$iconClass = $instance[ 'iconClassCol' . $i ];
			}
			else {
				$iconClass = __( 'fa fa-smile-o', 'aya' );
			}
			
			// text
			if (isset($instance[ 'textCol' . $i ])) {
				$text = $instance[ 'textCol' . $i ];
			} else {
				$text = '';
			}
			
			// text class
			if (isset($instance[ 'textClassCol' . $i ])) {
				$textClass = $instance[ 'textClassCol' . $i ];
			}
			else {
				$textClass = '';
			}
			
			// url
			if (isset($instance[ 'urlCol' . $i ])) {
				$url = $instance[ 'urlCol' . $i ];
			} else {
				$url = '';
			}
			
			// link text
			if (isset($instance[ 'linkTextCol' . $i ])) {
				$linkText = $instance[ 'linkTextCol' . $i ];
			}
			else {
				$linkText = __( 'Details', 'aya' );
			}
			
			// link class
			if (isset($instance[ 'linkClassCol' . $i ])) {
				$linkClass = $instance[ 'linkClassCol' . $i ];
			}
			else {
				$linkClass = '';
			}
			
			// Widget admin form
	?>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingTop' . $i ); ?>"><?php printf( __( 'Padding Top in Pixels (Column #%s):', 'aya' ), $i ); ?></label>  
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingTop' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingTop' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingTop); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingLeft' . $i ); ?>"><?php printf( __( 'Padding Left in Pixels (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingLeft' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingLeft' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingLeft); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingBottom' . $i ); ?>"><?php printf( __( 'Padding Bottom in Pixels (Column #%s):', 'aya' ), $i ); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingBottom' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingBottom' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingBottom); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'paddingRight' . $i ); ?>"><?php printf( __( 'Padding Right in Pixels (Column #%s):', 'aya' ), $i ); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'paddingRight' . $i ); ?>" name="<?php echo $this->get_field_name( 'paddingRight' . $i ); ?>" type="text" value="<?php echo esc_attr($paddingRight); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'titleCol' . $i ); ?>"><?php printf( __( 'Title (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'titleCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'titleCol' . $i ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'titleClassCol' . $i ); ?>"><?php printf( __( 'Title CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'titleClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'titleClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($titleClass); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'iconClassCol' . $i ); ?>"><?php printf( __( 'Icon CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'iconClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'iconClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($iconClass); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'textCol' . $i ); ?>"><?php printf( __( 'Text (Column #%s):', 'aya' ), $i ); ?></label> 
				<textarea class="widefat" id="<?php echo $this->get_field_id( 'textCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'textCol' . $i ); ?>"><?php echo esc_attr($text); ?></textarea>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'textClassCol' . $i ); ?>"><?php printf( __( 'Text CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'textClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'textClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($textClass); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'urlCol' . $i ); ?>"><?php printf( __( 'URL (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'urlCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'urlCol' . $i ); ?>" type="text" value="<?php echo esc_attr($url); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id( 'linkTextCol' . $i ); ?>"><?php printf( __( 'Link Text (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'linkTextCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'linkTextCol' . $i ); ?>" type="text" value="<?php echo esc_attr($linkText); ?>" />
			</p>

			<p>
				<label for="<?php echo $this->get_field_id( 'linkClassCol' . $i ); ?>"><?php printf( __( 'Link CSS Class (Column #%s):', 'aya' ), $i ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'linkClassCol' . $i ); ?>" name="<?php echo $this->get_field_name( 'linkClassCol' . $i ); ?>" type="text" value="<?php echo esc_attr($linkClass); ?>" />
			</p>
<?php
		}
	}
	
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();

		$instance[ 'backgroundImage' ] = (!empty( $new_instance[ 'backgroundImage' ])) ? strip_tags($new_instance[ 'backgroundImage' ]) : '';
		$instance[ 'centerBackgroundImg' ] = (!empty($new_instance[ 'centerBackgroundImg' ])) ? strip_tags($new_instance[ 'centerBackgroundImg' ]) : '';
		
		for ( $i = 1; $i <= self::NUMBER_OF_COLUMNS; ++$i) {
		
			$instance[ 'titleCol' . $i ]     = (!empty( $new_instance[ 'titleCol' . $i ])) ? strip_tags($new_instance[ 'titleCol' . $i ]) : '';
			$instance[ 'titleClassCol' . $i ] = (!empty( $new_instance[ 'titleClassCol' . $i ])) ? strip_tags($new_instance[ 'titleClassCol' . $i ]) : '';
			$instance[ 'iconClassCol' . $i ] = (!empty( $new_instance[ 'iconClassCol' . $i ])) ? strip_tags($new_instance[ 'iconClassCol' . $i ]) : '';
			$instance[ 'textCol' . $i ]      = (!empty( $new_instance[ 'textCol' . $i ])) ? $new_instance[ 'textCol' . $i ] : '';
			$instance[ 'textClassCol' . $i ] = (!empty( $new_instance[ 'textClassCol' . $i ])) ? $new_instance[ 'textClassCol' . $i ] : '';
			$instance[ 'linkTextCol' . $i ]  = (!empty( $new_instance[ 'linkTextCol' . $i ])) ? strip_tags($new_instance[ 'linkTextCol' . $i ]) : '';
			$instance[ 'linkClassCol' . $i ] = (!empty( $new_instance[ 'linkClassCol' . $i ])) ? strip_tags($new_instance[ 'linkClassCol' . $i ]) : '';
			$instance[ 'urlCol' . $i ]       = (!empty( $new_instance[ 'urlCol' . $i ])) ? strip_tags($new_instance[ 'urlCol' . $i ]) : '';

			$instance[ 'paddingTop' . $i ] = (!empty( $new_instance[ 'paddingTop' . $i ])) ?
													strip_tags($new_instance[ 'paddingTop' . $i ]) : '';
			$instance[ 'paddingLeft' . $i ] = (!empty( $new_instance[ 'paddingLeft' . $i ])) ?
													strip_tags($new_instance[ 'paddingLeft' . $i ]) : '';
			$instance[ 'paddingBottom' . $i ] = (!empty( $new_instance[ 'paddingBottom' . $i ])) ?
													strip_tags($new_instance[ 'paddingBottom' . $i ]) : '';
			$instance[ 'paddingRight' . $i ] = (!empty( $new_instance[ 'paddingRight' . $i ])) ?
													strip_tags($new_instance[ 'paddingRight' . $i ]) : '';
		}

		return $instance;
	}
}

/**
 * Skills Widget
 */

class aya_Skills_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'aya_skills_widget',
			__( 'Skill Section Widget', 'aya' ),
			array( 'description' => __( 'Single Skill Section Widget.', 'aya' ), )
		);
	}

	function form($instance) {
	
		// text before skill
		if (isset($instance[ 'textbeforeskill' ])) {
			$textbeforeskill = $instance[ 'textbeforeskill' ];
		} else {
			$textbeforeskill = '';
		}
		
		// text after skill
		if (isset($instance[ 'textafterskill' ])) {
			$textafterskill = $instance[ 'textafterskill' ];
		} else {
			$textafterskill = '';
		}
?>
		<p>
			<label for="<?php echo $this->get_field_id( 'textbeforeskill' ); ?>"><?php _e( 'Text Before Skill:', 'aya' ); ?></label> 
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'textbeforeskill' ); ?>" name="<?php echo $this->get_field_name( 'textbeforeskill' ); ?>"><?php echo esc_attr($textbeforeskill); ?></textarea>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>">
				<?php esc_html_e('Skill Name', 'aya'); ?>
			</label> 
			<input
				id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" 
				name="<?php echo esc_attr( $this->get_field_name('title') ); ?>"
				value="<?php if( !empty($instance['title']) ): echo esc_html($instance['title']); endif; ?>"
				type="text"
				placeholder="Skill Name" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('percentage') ); ?>">
				<?php esc_html_e('Skill Percentage', 'aya'); ?>
			</label> 
			<input
				id="<?php echo esc_attr( $this->get_field_id('percentage') ); ?>"
				name="<?php echo esc_attr( $this->get_field_name('percentage') ); ?>"
				value="<?php if( !empty($instance['percentage']) ): echo intval($instance['percentage']); endif; ?>"
				type="number" placeholder="80" min="0" max="100" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('titlecolor') ); ?>">
				<?php esc_html_e('Skill Name Color', 'aya'); ?>
			</label> 
			<input id="<?php echo esc_attr( $this->get_field_id('titlecolor') ); ?>"
				name="<?php echo esc_attr( $this->get_field_name('titlecolor') ); ?>"
				value="<?php if( !empty($instance['titlecolor']) ): echo esc_html($instance['titlecolor']); else: echo'#FFFFFF'; endif; ?>"
				type="color"
				data-default-color="#FFFFFF"  />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('titlebackground') ); ?>">
				<?php esc_html_e('Skill Name Background', 'aya'); ?>
			</label> 
			<input id="<?php echo esc_attr( $this->get_field_id('titlebackground') ); ?>"
				name="<?php echo esc_attr( $this->get_field_name('titlebackground') ); ?>"
				value="<?php if( !empty($instance['titlebackground']) ): echo esc_html($instance['titlebackground']); else: echo'#696969'; endif; ?>"
				type="color" data-default-color="#696969"  />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('barbackground') ); ?>">
				<?php esc_html_e('Skill Background', 'aya'); ?>
			</label> 
			<input id="<?php echo esc_attr( $this->get_field_id('barbackground') ); ?>"
				name="<?php echo esc_attr( $this->get_field_name('barbackground') ); ?>"
				value="<?php if( !empty($instance['barbackground']) ): echo esc_html($instance['barbackground']); else: echo'#808080'; endif; ?>"
				type="color" data-default-color="#808080"  />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'textafterskill' ); ?>"><?php _e( 'Text After Skill:', 'aya' ); ?></label> 
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'textafterskill' ); ?>" name="<?php echo $this->get_field_name( 'textafterskill' ); ?>"><?php echo esc_attr($textafterskill); ?></textarea>
		</p>
		<?php 
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = esc_html($new_instance['title']);
		$instance[ 'textbeforeskill' ] = (!empty( $new_instance[ 'textbeforeskill' ])) ? strip_tags($new_instance[ 'textbeforeskill' ]) : '';
		$instance['percentage'] = intval($new_instance['percentage']);
		$instance['titlecolor'] = esc_html($new_instance['titlecolor']);
		$instance['titlebackground'] = esc_html($new_instance['titlebackground']);
		$instance['barbackground'] = esc_html($new_instance['barbackground']);
		$instance[ 'textafterskill' ] = (!empty( $new_instance[ 'textafterskill' ])) ? strip_tags($new_instance[ 'textafterskill' ]) : '';
		
		return $instance;
	}

	function widget($args, $instance) {
		extract( $args );
		?>
			<?php echo $before_widget; ?>
					<div class="skill-section">
						<?php if ( array_key_exists( 'textbeforeskill', $instance ) && ( $instance[ 'textbeforeskill' ] != '' ) ) :
								echo '<div>'.$instance[ 'textbeforeskill' ].'</div>';
							  endif; ?>			
						<div class="single-skill-box">
							<div class="skillbar clear">
								<div class="skillbar-title" style="background: <?php if( !empty($instance['titlebackground']) ): echo esc_html($instance['titlebackground']); endif; ?>;"><span style="color:<?php if( !empty($instance['titlecolor']) ): echo esc_html($instance['titlecolor']); endif; ?>;"><?php if( !empty($instance['title']) ): echo esc_html($instance['title']); endif; ?></span></div>
								<div class="skillbar-bar" style="background: <?php if( !empty($instance['barbackground']) ): echo esc_html($instance['barbackground']); endif; ?>; width:<?php if( !empty($instance['percentage']) ): echo intval($instance['percentage']); endif; ?>%"></div>
								<div class="skill-bar-percent"><?php if( !empty($instance['percentage']) ): echo esc_html($instance['percentage']); endif; ?>%</div>
							</div>
						</div>
						<?php if ( array_key_exists( 'textafterskill', $instance ) && ( $instance[ 'textafterskill' ] != '' ) ) :
								echo '<div>'.$instance[ 'textafterskill' ].'</div>';
							  endif; ?>
					</div>		
			<?php echo $after_widget; ?>
		<?php
	}
}

class aya_FacebookLikeBoxWidget extends WP_Widget {

	function __construct() {

		parent::__construct(
			'aya_FacebookLikeBoxWidget',
			__( 'Facebook Page Like Box', 'aya' ),
			array( 'description' => __( 'Display Facebook Page Like Box.', 'aya' ), )
		);
	}

	public function widget( $args, $instance ) {

		if ( array_key_exists( 'before_widget', $args ) ) {
			echo $args['before_widget'];
		}

		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		$tab_output = array();

		if ( $instance['timeline_tab'] == 1 ) {
			array_push( $tab_output, 'timeline' );
		}
		if ( $instance['events_tab'] == 1 ) {
			array_push( $tab_output, 'events' );
		}
		if ( $instance['messages_tab'] == 1 ) {
			array_push( $tab_output, 'messages' );
		}

		$dataHref = ( strpos( $instance['href'], 'facebook.com' ) !== false ) ?
						esc_attr( $instance['href'] ) : 'https://facebook.com/' . $instance['href'];
?>
		<div id="simple-facebook-widget" style="text-align:<?php echo esc_attr( $instance['align'] ); ?>;">
			<div class="fb-page"
				data-href="<?php echo $dataHref; ?>"
				data-width="<?php echo esc_attr( $instance['width'] ); ?>"
				data-height="<?php echo esc_attr( $instance['height'] ); ?>"
				data-tabs="<?php echo implode( ', ', $tab_output ); ?>"
				data-hide-cover="<?php echo esc_attr( $instance['show_cover'] ); ?>"
				data-show-facepile="<?php echo esc_attr( $instance['show_facepile'] ); ?>"
				data-hide-cta="<?php echo esc_attr( $instance['show_cta'] ); ?>"
				data-small-header="<?php echo esc_attr( $instance['small_header'] ); ?>"
				data-adapt-container-width="<?php echo esc_attr( $instance['adapt_container_width'] ); ?>" >
			</div>
		</div>
		<script>(function(d, s, id) {
			  var js, fjs = d.getElementsByTagName(s)[0];
			  if (d.getElementById(id)) return;
			  js = d.createElement(s); js.id = id;
			  js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.5";
			  fjs.parentNode.insertBefore(js, fjs);
			}(document, 'script', 'facebook-jssdk'));
		</script>
<?php
		if ( array_key_exists( 'after_widget', $args ) ) {
			echo $args['after_widget'];
		}
	}

	public function form( $instance ) {

		$defaults = $this->sfpp_defaults();
		$instance = wp_parse_args( (array) $instance, $defaults );
		$title = strip_tags( $instance['title'] );
		$href = strip_tags( $instance['href'] );
		$width = range( 280, 500, 20 );
		$height = range( 125, 800, 25 );
		$show_cover = array( 'true' => 'Yes', 'false' => 'No' );
		$show_facepile = array( 'true' => 'Yes', 'false' => 'No' );
		$align = array( 'initial' => 'None', 'left' => 'Left', 'center' => 'Center', 'right' => 'Right' );
		$timeline_tab = array( 'true' => 'Yes', 'false' => 'No' );
		$events_tab = array( 'true' => 'Yes', 'false' => 'No' );
		$messages_tab = array( 'true' => 'Yes', 'false' => 'No' );
		$show_cta = array( 'true' => 'Yes', 'false' => 'No' );
		$small_header = array( 'true' => 'Yes', 'false' => 'No' );
		$adapt_container_width = array( 'true' => 'Yes', 'false' => 'No' );
		$reverse_boolean = array( 0 => 'Yes', 1 => 'No' );
		$boolean = array( 1 => 'Yes', 0 => 'No' );
?>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
			       name="<?php echo $this->get_field_name( 'title' ); ?>"
			       value="<?php echo esc_attr( $instance['title'] ); ?>"/>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'href' ); ?>"><?php _e( 'Facebook Page URL:', 'aya' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'href' ); ?>"
			       name="<?php echo $this->get_field_name( 'href' ); ?>"
			       value="<?php echo esc_attr( $instance['href'] ); ?>"/>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'width' ); ?>"><?php _e( 'Width:', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'width' ); ?>"
			        name="<?php echo $this->get_field_name( 'width' ); ?>">
				<?php foreach ( $width as $val ): ?>
					<option
						value="<?php echo esc_attr( $val ); ?>" <?php selected( $instance['width'], $val ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'height' ); ?>"><?php _e( 'Height:', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'height' ); ?>"
			        name="<?php echo $this->get_field_name( 'height' ); ?>">
				<?php foreach ( $height as $val ): ?>
					<option
						value="<?php echo esc_attr( $val ); ?>" <?php selected( $instance['height'], $val ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'show_cover' ); ?>"><?php _e( 'Show Cover Photo?', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'show_cover' ); ?>"
			        name="<?php echo $this->get_field_name( 'show_cover' ); ?>">
				<?php foreach ( $reverse_boolean as $key => $val ): ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( $instance['show_cover'], $key ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'show_facepile' ); ?>"><?php _e( 'Show Facepile?', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'show_facepile' ); ?>"
			        name="<?php echo $this->get_field_name( 'show_facepile' ); ?>">
				<?php foreach ( $boolean as $key => $val ): ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( $instance['show_facepile'], $key ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'show_cta' ); ?>"><?php _e( 'Show Call to Action button?', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'show_cta' ); ?>"
			        name="<?php echo $this->get_field_name( 'show_cta' ); ?>">
				<?php foreach ( $reverse_boolean as $key => $val ): ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( $instance['show_cta'], $key ) ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'small_header' ); ?>"><?php _e( 'Small Header?', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'small_header' ); ?>"
			        name="<?php echo $this->get_field_name( 'small_header' ); ?>">
				<?php foreach ( $boolean as $key => $val ): ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( $instance['small_header'], $key ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'timeline_tab' ); ?>"><?php _e( 'Show Timeline Tab?', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'timeline_tab' ); ?>"
			        name="<?php echo $this->get_field_name( 'timeline_tab' ); ?>">
				<?php foreach ( $boolean as $key => $val ): ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( $instance['timeline_tab'], $key ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'events_tab' ); ?>"><?php _e( 'Show Events Tab?', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'events_tab' ); ?>"
			        name="<?php echo $this->get_field_name( 'events_tab' ); ?>">
				<?php foreach ( $boolean as $key => $val ): ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( $instance['events_tab'], $key ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'messages_tab' ); ?>"><?php _e( 'Show Messages Tab?', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'messages_tab' ); ?>"
			        name="<?php echo $this->get_field_name( 'messages_tab' ); ?>">
				<?php foreach ( $boolean as $key => $val ): ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( $instance['messages_tab'], $key ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'adapt_container_width' ); ?>"><?php _e( 'Beta: Auto-responsive?', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'adapt_container_width' ); ?>"
			        name="<?php echo $this->get_field_name( 'adapt_container_width' ); ?>">
				<?php foreach ( $boolean as $key => $val ): ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( $instance['adapt_container_width'], $key ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo $this->get_field_id( 'align' ); ?>"><?php _e( 'Alignment:', 'aya' ); ?></label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'align' ); ?>"
			        name="<?php echo $this->get_field_name( 'align' ); ?>">
				<?php foreach ( $align as $key => $val ): ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( $instance['align'], $key ); ?>><?php echo esc_html( $val ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {

		$defaults = $this->sfpp_defaults();
		$instance = $old_instance;
		foreach ( $defaults as $key => $val ) {
			$instance[ $key ] = strip_tags( $new_instance[ $key ] );
		}

		return $instance;
	}

	function sfpp_defaults() {

		$defaults = array(
			'title'                 => esc_attr__( 'Facebook Page Widget', 'aya' ),
			'href'                  => 'https://www.facebook.com/ayatemplates',
			'width'                 => '340',
			'height'                => '500',
			'show_cover'            => '0',
			'show_facepile'         => '0',
			'align'                 => 'initial',
			'timeline_tab'          => '1',
			'events_tab'            => '0',
			'messages_tab'          => '0',
			'show_cta'              => '0',
			'small_header'          => '0',
			'adapt_container_width' => '1'
		);

		return $defaults;
	}
}

/*
 * Display Vimeo Video
 */
class aya_DisplayVimeoVideo_Widget extends WP_Widget {

	function __construct() {
	parent::__construct(
		// Base ID of Display Vimeo Video widget
		'aya_DisplayVimeoVideo_Widget', 

		// Widget name will appear in UI
		__( 'Display Vimeo Video', 'aya' ), 

		// Widget description
		array( 'description' => __( 'Embed vimeo video widget', 'aya' )) 
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget($args, $instance) {

		$title = apply_filters( 'widget_title', array_key_exists( 'title', $instance ) ? $instance[ 'title' ] : '' );
		// before and after widget arguments are defined by themes
		echo $args[ 'before_widget' ];

		if ( !empty($title) ) {

			echo $args['before_title'] . $title . $args['after_title'];
		};

		$videoid = empty($instance['videoid']) ? '' : $instance['videoid'];
		if ($videoid != '') {

			$maxwidth = empty($instance['maxwidth']) ? '640' : $instance['maxwidth'];
			$maxheight = empty($instance['maxheight']) ? '360' : $instance['maxheight'];

			echo '<i' . 'frame src="https://player.vimeo.com/video/' . $videoid . '" width="' . $maxwidth
					. '" height="' . $maxheight
					. '" frameborder="0" class="vimeo-iframe" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';

			$videodescription = empty($instance['videodescription']) ? '' : $instance['videodescription'];
			if ($videodescription != '') {
				echo '<p>' . $videodescription . '</p>';
			}
		}

		echo $args[ 'after_widget' ];
	}
		
	// Widget Backend 
	public function form($instance) {

		$title = isset($instance[ 'title' ]) ? $instance[ 'title' ] : '';
		$videoid = isset($instance[ 'videoid' ]) ? $instance[ 'videoid' ] : '';	
		$maxwidth = isset($instance[ 'maxwidth' ]) ? $instance[ 'maxwidth' ] : '640';
		$maxheight = isset($instance[ 'maxheight' ]) ? $instance[ 'maxheight' ] : '360';
		$videodescription = isset($instance[ 'videodescription' ]) ? $instance[ 'videodescription' ] : '';

		// Widget admin form
?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'videoid' ); ?>"><?php _e( 'Video ID:', 'aya' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'videoid' ); ?>" name="<?php echo $this->get_field_name( 'videoid' ); ?>" type="text" value="<?php echo esc_attr($videoid); ?>" />
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'maxwidth' ); ?>"><?php _e( 'Maximum Width:', 'aya' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'maxwidth' ); ?>" name="<?php echo $this->get_field_name( 'maxwidth' ); ?>" type="text" value="<?php echo esc_attr($maxwidth); ?>" />
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'maxheight' ); ?>"><?php _e( 'Maximum Height:', 'aya' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'maxheight' ); ?>" name="<?php echo $this->get_field_name( 'maxheight' ); ?>" type="text" value="<?php echo esc_attr($maxheight); ?>" />
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'videodescription' ); ?>"><?php _e( 'Video Description:', 'aya' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'videodescription' ); ?>" name="<?php echo $this->get_field_name( 'videodescription' ); ?>" type="text" value="<?php echo esc_attr($videodescription); ?>" />
		</p>

<?php 
	}
	
	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance[ 'title' ] = (!empty( $new_instance[ 'title' ])) ? strip_tags($new_instance[ 'title' ]) : '';
		$instance[ 'videoid' ] = (!empty( $new_instance[ 'videoid' ])) ? strip_tags($new_instance[ 'videoid' ]) : '';
		$instance[ 'maxwidth' ] = (!empty( $new_instance[ 'maxwidth' ])) ? strip_tags($new_instance[ 'maxwidth' ]) : '';
		$instance[ 'maxheight' ] = (!empty( $new_instance[ 'maxheight' ])) ? strip_tags($new_instance[ 'maxheight' ]) : '';
		$instance[ 'videodescription' ] = (!empty( $new_instance[ 'videodescription' ])) ? strip_tags($new_instance[ 'videodescription' ]) : '';
		
		return $instance;
	}
}

/*
 * Display Testimonials Widget Class
 */
class aya_Display_Testimonials_Widget extends WP_Widget {

	function __construct() {
		parent::__construct('display-testimonials', __('Testimonials', 'aya'), 
							array( 'classname' => 'widget_testimonials_entries',
							       'description' => __( "Display testimonials entries", 'aya') )
						    );
		$this->alt_option_name = 'widget_testimonials_entries';

		add_action( 'save_post', array($this, 'flush_widget_testimonials_cache') );
		add_action( 'deleted_post', array($this, 'flush_widget_testimonials_cache') );
		add_action( 'switch_theme', array($this, 'flush_widget_testimonials_cache') );
	}

	function widget($args, $instance) {
		$cache = wp_cache_get('widget_testimonials_entries', 'widget');

		if ( !is_array($cache) )
			$cache = array();

		if ( ! isset( $args['widget_id'] ) )
			$args['widget_id'] = $this->id;

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();
		extract($args);

		$title = ( array_key_exists( 'title', $instance ) && !empty( $instance['title'] ) ) ? $instance['title'] : __( 'Testimonials', 'aya' );
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 10;
		if ( ! $number )
 			$number = 10;
			
		$testimonialsArgs = array( 'post_type' 		=> 'testimonial',
								   'posts_per_page' => $number
								  );
		
		$r = new WP_Query( $testimonialsArgs );
		
		if ($r->have_posts()) :
?>
		<?php echo $before_widget; ?>
		<?php if ( $title ) echo $before_title . $title . $after_title; ?>

			<ul id="testimonials" class="jcarousel jcarousel-skin">

			<?php while ( $r->have_posts() ) : $r->the_post();
			
					$data = get_post_meta( $r->post->ID, 'testimonial', true );
?>
			
					<li class="slide">
						<div class="testimonial-quote">
							<?php the_content(); ?>
						</div>
						
						<div class="client-contact-info">

							<?php if ( has_post_thumbnail() ) {

								echo '<div class="testimonial-author">' . get_the_post_thumbnail() . '</div>';

							} ?>

							<?php echo $data[ 'person-name' ]; ?>
							
							<?php if ( strlen($data[ 'position' ] ) > 0 ) : ?>
							
									<br />
									<?php echo $data[ 'position' ]; ?>
							
							<?php endif; ?>
							
							<?php if ( strlen($data[ 'link' ] ) > 0 || strlen( $data[ 'company' ]) > 0 ) : ?>
							
									<br />
									<a href="<?php echo $data[ 'link' ]; ?>" title="<?php echo $data[ 'company' ]; ?>" target="_blank"><?php echo $data[ 'company' ]; ?></a>
							
							<?php endif; ?>
						</div>
						<div class="clear"></div>
						
					</li>

<?php			 endwhile; ?>

			</ul>

		<?php echo $after_widget; ?>
<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;

		$cache[$args['widget_id']] = ob_get_flush();
		wp_cache_set('widget_testimonials_entries', $cache, 'widget');
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$this->flush_widget_testimonials_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_testimonials_entries_entries']) )
			delete_option('widget_testimonials_entries_entries');

		return $instance;
	}

	function flush_widget_testimonials_cache() {
		wp_cache_delete('widget_testimonials_entries', 'widget');
	}

	function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'Testimonials', 'aya' );
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of testimonials to show:', 'aya' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>
<?php
	}
}

/*
 * Display Projects Widget Class
 */
class aya_Display_Projects_Widget extends WP_Widget {

	function __construct() {
		parent::__construct('display-Projects', __('Recent Projects', 'aya'), 
							array( 'classname' => 'widget_Projects_entries',
							       'description' => __( "Display Recent Project Entries", 'aya') )
						    );
		$this->alt_option_name = 'widget_Projects_entries';

		add_action( 'save_post', array($this, 'flush_widget_Projects_cache') );
		add_action( 'deleted_post', array($this, 'flush_widget_Projects_cache') );
		add_action( 'switch_theme', array($this, 'flush_widget_Projects_cache') );
	}

	function widget($args, $instance) {
		$cache = wp_cache_get('widget_Projects_entries', 'widget');

		if ( !is_array($cache) )
			$cache = array();

		if ( ! isset( $args['widget_id'] ) )
			$args['widget_id'] = $this->id;

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();
		extract($args);

		$title = ( array_key_exists( 'title', $instance ) && !empty( $instance['title'] ) ) ? $instance['title'] : __( 'Display Projects', 'aya' );
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 10;
		if ( ! $number )
 			$number = 10;
			
		$projectsArgs = array( 'post_type' 		=> 'project',
							   'posts_per_page' => $number
							  );
		
		$r = new WP_Query( $projectsArgs );
		
		if ($r->have_posts()) :
?>
		<?php echo $before_widget; ?>
		<?php if ( $title ) :
		
				echo $before_title . $title . $after_title;

			  endif; ?>
			
			<ul id="projects-carousel" class="jcarousel jcarousel-skin">

			<?php while ( $r->have_posts() ) : $r->the_post();
			
					$data = get_post_meta( $r->post->ID, 'project', true );
?>
					<li class="slide project-widget-item">
						<div class="img">
							<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title(); ?>">
								<?php the_post_thumbnail('medium'); ?>
							</a>
						</div>				
						<p>
							<strong>
								<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a>
							</strong>
						</p>
					</li>

<?php			 endwhile; ?>

			</ul>

		<?php echo $after_widget; ?>
<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;

		$cache[$args['widget_id']] = ob_get_flush();
		wp_cache_set('widget_Projects_entries', $cache, 'widget');
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$this->flush_widget_Projects_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_Projects_entries_entries']) )
			delete_option('widget_Projects_entries_entries');

		return $instance;
	}

	function flush_widget_Projects_cache() {
		wp_cache_delete('widget_Projects_entries', 'widget');
	}

	function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'Projects', 'aya' );
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of Projects to show:', 'aya' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>
<?php
	}
}

/*
 * Display Clients Widget Class
 */
class aya_Display_Clients_Widget extends WP_Widget {

	function __construct() {
		parent::__construct('display-clients', __('Clients', 'aya'), 
							array( 'classname' => 'widget_clients_entries',
							       'description' => __( "Display clients entries", 'aya') )
						    );
		$this->alt_option_name = 'widget_clients_entries';

		add_action( 'save_post', array($this, 'flush_widget_clients_cache') );
		add_action( 'deleted_post', array($this, 'flush_widget_clients_cache') );
		add_action( 'switch_theme', array($this, 'flush_widget_clients_cache') );
	}

	function widget($args, $instance) {
		$cache = wp_cache_get('widget_clients_entries', 'widget');

		if ( !is_array($cache) )
			$cache = array();

		if ( ! isset( $args['widget_id'] ) )
			$args['widget_id'] = $this->id;

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();
		extract($args);

		$title = ( array_key_exists( 'title', $instance ) && !empty( $instance['title'] ) ) ? $instance['title'] : __( 'Display Clients', 'aya' );
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 10;
		if ( ! $number )
 			$number = 10;
			
		$clientsArgs = array( 'post_type' 		=> 'client',
								   'posts_per_page' => $number
								  );
		
		$r = new WP_Query( $clientsArgs );
		
		if ($r->have_posts()) :
?>
		<?php echo $before_widget; ?>
		<?php if ( $title ) echo $before_title . $title . $after_title; ?>

			<ul id="clients" class="jcarousel jcarousel-skin">

			<?php while ( $r->have_posts() ) : $r->the_post();
			
					$data = get_post_meta( $r->post->ID, 'client', true );
?>
			
					<li class="slide">
						<a href="<?php echo $data['link']; ?>" title="<?php the_title(); ?>" target="_blank"><?php the_post_thumbnail(); ?></a>
		
					</li>

<?php			 endwhile; ?>

			</ul>

		<?php echo $after_widget; ?>
<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;

		$cache[$args['widget_id']] = ob_get_flush();
		wp_cache_set('widget_clients_entries', $cache, 'widget');
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$this->flush_widget_clients_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_clients_entries_entries']) )
			delete_option('widget_clients_entries_entries');

		return $instance;
	}

	function flush_widget_clients_cache() {
		wp_cache_delete('widget_clients_entries', 'widget');
	}

	function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'Clients', 'aya' );
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'aya' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of clients to show:', 'aya' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>
<?php
	}
}

?>
