<?php

/**
 * Utility function to add a new section to the customizer
 */
function aya_customizer_add_section( $wp_customize, $sectionId, $sectionTitle ) {

	$wp_customize->add_section(
		$sectionId,
		array(
			'title'       => $sectionTitle,
			'capability'  => 'edit_theme_options',
		)
	);
}

function aya_customizer_add_customize_control( $wp_customize, $sectionId, $controlId, $controlLabel, $controlDefaultVar, $sanitizeCallback, $type ) {

	if ($controlDefaultVar) {

		$wp_customize->add_setting( $controlId, array(
									'sanitize_callback' => $sanitizeCallback,
									'default' 		    => $controlDefaultVar,
				) );
	} else {

		$wp_customize->add_setting( $controlId, array(
									'sanitize_callback' => $sanitizeCallback,
				) );
	}

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, $controlId,
        array(
            'label'          => $controlLabel,
            'section'        => $sectionId,
            'settings'       => $controlId,
            'type'           => $type,
            )
        )
	);
}

/**
 * Utility function to add a new select control to the customizer
 */
function aya_customizer_add_select_control( $wp_customize, $sectionId, $controlId, $controlLabel, $controlDefaultVar, $controlChoices ) {

	$wp_customize->add_setting(
		$controlId,
		array(
		    'default'           => $controlDefaultVar,
		    'sanitize_callback' => 'esc_attr',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, $controlId,
        array(
            'label'          => $controlLabel,
            'section'        => $sectionId,
            'settings'       => $controlId,
            'type'           => 'select',
			'choices'        => $controlChoices
            )
        )
	);
}

/**
 * Utility function to add a new checkbox control to the customizer
 */
function aya_customizer_add_checkbox_control( $wp_customize, $sectionId, $controlId, $controlLabel, $controlDefaultVar ) {

	aya_customizer_add_customize_control( $wp_customize, $sectionId, $controlId,
		$controlLabel, $controlDefaultVar, 'esc_attr', 'checkbox' );
}

/**
 * Utility function to add a new textarea control to the customizer
 */
function aya_customizer_add_textarea_control( $wp_customize, $sectionId, $controlId, $controlLabel, $controlDefaultVar ) {

	aya_customizer_add_customize_control( $wp_customize, $sectionId, $controlId,
		$controlLabel, $controlDefaultVar, 'balanceTags', 'textarea' );
}

/**
 * Utility function to add a new text control to the customizer
 */
function aya_customizer_add_text_control( $wp_customize, $sectionId, $controlId, $controlLabel, $controlDefaultVar ) {

	aya_customizer_add_customize_control( $wp_customize, $sectionId, $controlId,
		$controlLabel, $controlDefaultVar, 'balanceTags', 'text' );
}

/**
 * Utility function to add a new image control to the customizer
 */
function aya_customizer_add_image_control( $wp_customize, $sectionId, $controlId, $controlLabel, $controlDefaultVar ) {

	if ($controlDefaultVar) {

		$wp_customize->add_setting( $controlId, array(
					'sanitize_callback' => 'esc_url_raw',
					'default' 			=> $controlDefaultVar,
				) );

	} else {

		$wp_customize->add_setting( $controlId, array(
					'sanitize_callback' => 'esc_url_raw',
				) );
	}

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $controlId,
			array(
				'label'   	 => $controlLabel,
				'section' 	 => $sectionId,
				'settings'   => $controlId,
			) 
		)
	);
}

/**
 * Utility function to add a new color control to the customizer
 */
function aya_customizer_add_color_control( $wp_customize, $sectionId, $controlId, $controlLabel, $controlDefaultVar ) {

	if ($controlDefaultVar) {

		$wp_customize->add_setting( $controlId, array(
					'sanitize_callback' => 'esc_attr',
					'default' 			=> $controlDefaultVar,
				) );

	} else {

		$wp_customize->add_setting( $controlId, array(
					'sanitize_callback' => 'esc_attr',
				) );
	}
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $controlId,
        array(
            'label'          => $controlLabel,
            'section'        => $sectionId,
            'settings'       => $controlId,
            )
        )
	);
}

/**
 * Add General Settings to the Customizer
 */
function aya_customize_register_general_settings( $wp_customize ) {

	// Add General Settings Section
	aya_customizer_add_section( $wp_customize, 'aya_general_settings', __( 'General', 'aya' ) );

	// Layout Options
	aya_customizer_add_select_control( $wp_customize, 'aya_general_settings',
			'aya_general_layout', __( 'Website Layout', 'aya' ),
			'wide', array( 'wide'   => __( 'Wide', 'aya' ),
							'boxed'  => __( 'Boxed', 'aya' ),
						  ) );

	// Code before </head> tag
	aya_customizer_add_textarea_control( $wp_customize, 'aya_general_settings',
			'aya_general_headercode', __( 'Code Before &lt;/head&gt; tag', 'aya' ), null );

	// Code before </body> tag
	aya_customizer_add_textarea_control( $wp_customize, 'aya_general_settings',
			'aya_general_bodycode', __( 'Code before &lt;/body&gt; tag', 'aya' ), null );

	// Tracking Code
	aya_customizer_add_textarea_control( $wp_customize, 'aya_general_settings',
			'aya_general_trackingcode', __( 'Tracking Code (i.e. Google Analytics).', 'aya' ), null );

	// Show Author Info After Single Posts
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_general_settings',
		'aya_general_showauthorinfo_aftersinglepost', __( 'Show Author Info After Single Posts', 'aya' ), 1 );

	// Show Social Sharing After Single Posts
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_general_settings',
		'aya_general_showsocialsharing_aftersinglepost', __( 'Show Social Sharing After Single Posts', 'aya' ), 1 );

	// Show Author Info After Single Pages
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_general_settings',
		'aya_general_showauthorinfo_aftersinglepage', __( 'Show Author Info After Single Pages', 'aya' ), 0 );

	// Show Social Sharing After Single Pages
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_general_settings',
		'aya_general_showsocialsharing_aftersinglepage', __( 'Show Social Sharing After Single Pages', 'aya' ), 0 );

	// Display Author Links for Posts
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_general_settings',
		'aya_general_showauthor_forposts', __( 'Display Author Links for Posts', 'aya' ), 1 );

	// Display Author Links for Pages
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_general_settings',
		'aya_general_showauthor_forpages', __( 'Display Author Links for Pages', 'aya' ), 0 );

	// Display Sidebar in Posts
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_general_settings',
		'aya_general_showsidebar_forposts', __( 'Display Sidebar in Posts', 'aya' ), 1 );

	// Display Sidebar in Pages
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_general_settings',
		'aya_general_showsidebar_forpages', __( 'Display Sidebar in Pages', 'aya' ), 1 );

	// Display Sidebar in Left
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_general_settings',
		'aya_general_sidebarinleft', __( 'Display Sidebar in Left', 'aya' ), 0 );
}

/**
 * Add Header Image to the Customizer
 */
function aya_customize_register_site_identity_settings( $wp_customize ) {

	// Add logo width (small resolution)
	aya_customizer_add_text_control( $wp_customize, 'title_tagline', 'aya_header_logo_width_small',
		__( 'Logo Width (in pixels) for Small Resolution (screen width smaller than 360px)', 'aya' ), null );

	// Add logo width (medium resolution)
	aya_customizer_add_text_control( $wp_customize, 'title_tagline', 'aya_header_logo_width_medium',
		__( 'Logo Width (in pixels) for Medium Resolution (screen width between 360px and 800px)', 'aya' ), null );

	// Add logo width (large resolution)
	aya_customizer_add_text_control( $wp_customize, 'title_tagline', 'aya_header_logo_width_large',
		__( 'Logo Width (in pixels) for Large Resolution (screen width between 800px and 1200px)', 'aya' ), null );

	// Add logo width (extra large resolution)
	aya_customizer_add_text_control( $wp_customize, 'title_tagline', 'aya_header_logo_width_extralarge',
		__( 'Logo Width (in pixels) for Large Resolution (screen width larger than 1200px)', 'aya' ), null );
}

/**
 * Add Header and Footer Settings to the Customizer
 */
function aya_customize_register_header_and_footer_settings( $wp_customize ) {

	aya_customizer_add_section( $wp_customize, 'aya_header_and_footer_settings', __( 'Header and Footer', 'aya' ) );

	// Display social icons in header
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_header_and_footer_settings',
		'aya_header_displaysocial', __( 'Display Social Icons in Header', 'aya' ), 1 );

	// Add header open social in a new window
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_header_and_footer_settings',
		'aya_header_opensocialnewwindow', __( 'Open Header Social Icons in a new window', 'aya' ), 1 );

    // Number of Columns in Footer
    aya_customizer_add_select_control( $wp_customize, 'aya_header_and_footer_settings',
			'aya_footer_columnsnumber', __( 'Number of Columns in Footer', 'aya' ),
			'4', array( 'none' => 'none',
						'1'	   => '1',
						'2'	   => '2',
						'3'	   => '3',
						'4'	   => '4',
					) );

	// Display social icons in footer
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_header_and_footer_settings',
		'aya_footer_displaysocial', __( 'Display Social Icons in Footer', 'aya' ), 1 );

	// Add footer open social in a new window
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_header_and_footer_settings',
		'aya_footer_opensocialnewwindow', __( 'Open Footer Social Icons in a new window', 'aya' ), 1 );

	// Display Footer Menu
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_header_and_footer_settings',
		'aya_footer_displayfootermenu', __( 'Display Footer Menu', 'aya' ), 1 );

// Add copyright Text in Footer
	aya_customizer_add_text_control( $wp_customize, 'aya_header_and_footer_settings', 'aya_footer_copyrighttext',
		__( 'Copyright Text in Footer', 'aya' ), 'Copyright &copy; 2017. All Rights Reserved. | Powered by <a title="ayatemplates.com" href="https://ayatemplates.com/" target="_blank">ayatemplates.com</a>' );
}

/**
 * Add Home Page Settings to the Customizer
 */
function aya_customize_register_homepage_settings( $wp_customize ) {

	aya_customizer_add_section( $wp_customize, 'aya_homepage_settings', __( 'Home Page', 'aya' ) );

	

	// Add display latest posts
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_homepage_settings',
		'aya_homepage_displaylatestposts', __( 'Display Latest Posts', 'aya' ), 1 );

	// Add Display Sidebar
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_homepage_settings',
		'aya_homepage_displaysidebar', __( 'Display Sidebar', 'aya' ), 1 );

	// Number of Columns in Home Page
	aya_customizer_add_select_control( $wp_customize, 'aya_homepage_settings',
			'aya_homepage_columnsnumber', __( 'Number of Columns', 'aya' ),
			'4', array( 'none' => 'none',
						'1'	   => '1',
						'2'	   => '2',
						'3'	   => '3',
						'4'	   => '4',
					) );

	// Add Homepage Above Columns background image
	aya_customizer_add_image_control( $wp_customize, 'aya_homepage_settings',
		'aya_homepage_abovecolsback', __( 'Homepage Above Columns Background Image', 'aya' ), null );

	// Add fix bacground image for Homepage Above Columns
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_homepage_settings',
		'aya_homepage_abovecolsback_fixed', __( 'Homepage Above Columns Background Image Fix Position', 'aya' ), 0 );

	// Add Homepage Columns background image
	aya_customizer_add_image_control( $wp_customize, 'aya_homepage_settings',
		'aya_homepage_colsback', __( 'Homepage Columns Background Image', 'aya' ), null );


	// Add fix bacground image for Homepage Columns
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_homepage_settings',
		'aya_homepage_colsback_fixed', __( 'Homepage Columns Background Image Fix Position', 'aya' ), 0 );

	// Homepage Below Columns background image
	aya_customizer_add_image_control( $wp_customize, 'aya_homepage_settings',
		'aya_homepage_belowcolsback', __( 'Homepage Below Columns Background Image', 'aya' ), null );

	// Add fix bacground image for Homepage Columns
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_homepage_settings',
		'aya_homepage_belowcolsback_fixed', __( 'Homepage Below Columns Background Image Fix Position', 'aya' ), 0 );
}

/**
 * Add Slider Settings to the Customizer
 */
function aya_customize_register_slider_settings( $wp_customize ) {

	// Add General Settings Section
	aya_customizer_add_section( $wp_customize, 'aya_slider_settings', __( 'Slider', 'aya' ) );

	// Add Display Slider in HomePage
    aya_customizer_add_checkbox_control( $wp_customize, 'aya_slider_settings',
        'aya_slider_displayinhomepage', __( 'Display Slider in Home Page', 'aya' ), 1 );

    // Add Display Slider in All Website Pages
    aya_customizer_add_checkbox_control( $wp_customize, 'aya_slider_settings',
        'aya_slider_displayinallpages', __( 'Display Slider in All Website Pages', 'aya' ), 0 );

	$defaultVals = array(  
			// Slide #1 default settings
			'aya_slider_displayslide1'		=> 1,
			'aya_slider_slide1_title' 	    => 'Lorem ipsum dolor',
			'aya_slider_slide1_text' 	   		=> '<p>Lorem ipsum dolor sit amet, consectetur adipisicing.</p>',
			'aya_slider_slide1_url' 		   	=> '#',
			'aya_slider_slide1_image'	   		=> get_stylesheet_directory_uri().'/images/slider/slides/1.jpg',
			// Slide #2 default settings
			'aya_slider_displayslide2' 	   	=> 1,
			'aya_slider_slide2_title'	   		=> 'Everti Constituam',
			'aya_slider_slide2_text' 	   		=> '<p>Vel nobis libris nostrud an. Per ex veniam.</p>',
			'aya_slider_slide2_url' 		   	=> '#',
			'aya_slider_slide2_image'	   		=> get_stylesheet_directory_uri().'/images/slider/slides/2.jpg',
			// Slide #3 default settings
			'aya_slider_displayslide3'	   	=> 1,
			'aya_slider_slide3_title' 	   	=> 'Id Essent Cetero',
			'aya_slider_slide3_text' 	   		=> '<p>Quodsi docendi sed id. Ea eam quod aliquam epicurei.</p>',
			'aya_slider_slide3_url' 		   	=> '#',
			'aya_slider_slide3_image' 	   	=> get_stylesheet_directory_uri().'/images/slider/slides/3.jpg',
			// slide #4 default settings
			'aya_slider_displayslide4'	  	=> 1,
			'aya_slider_slide4_title' 	   	=> 'Nostrud Cotidieque Et',
			'aya_slider_slide4_text' 	   		=> '<p>Vel nobis libris nostrud an. Id prompta postulant.</p>',
			'aya_slider_slide4_url' 		   	=> '#',
			'aya_slider_slide4_image'	   		=> get_stylesheet_directory_uri().'/images/slider/slides/4.jpg',
			// slide #5 default settings
			'aya_slider_displayslide5'	   	=> 1,
			'aya_slider_slide5_title' 	   	=> 'Lorem ipsum dolor sit amet',
			'aya_slider_slide5_text' 	   		=> '<p>Lorem ipsum dolor sit amet, consectetur adipisicing.</p>',
			'aya_slider_slide5_url' 		   	=> '#',
			'aya_slider_slide5_image'	   		=> get_stylesheet_directory_uri().'/images/slider/slides/5.jpg',
			// slide #6 default settings
			'aya_slider_displayslide6'		=> 1,
			'aya_slider_slide6_title' 	    => 'Lorem ipsum dolor',
			'aya_slider_slide6_text' 	   		=> '<p>Lorem ipsum dolor sit amet, consectetur adipisicing.</p>',
			'aya_slider_slide6_url' 		   	=> '#',
			'aya_slider_slide6_image'	   		=> get_stylesheet_directory_uri().'/images/slider/slides/6.jpg',
			// Slide #2 default settings
			'aya_slider_displayslide7' 	   	=> 1,
			'aya_slider_slide7_title'	   		=> 'Everti Constituam',
			'aya_slider_slide7_text' 	   		=> '<p>Vel nobis libris nostrud an. Id prompta postulant.</p>',
			'aya_slider_slide7_url' 		   	=> '#',
			'aya_slider_slide7_image'	   		=> get_stylesheet_directory_uri().'/images/slider/slides/7.jpg',
			// Slide #3 default settings
			'aya_slider_displayslide8'	   	=> 1,
			'aya_slider_slide8_title' 	   	=> 'Id Essent Cetero',
			'aya_slider_slide8_text' 	   		=> '<p>Quodsi docendi sed id. Ea eam quod aliquam.</p>',
			'aya_slider_slide8_url' 		   	=> '#',
			'aya_slider_slide8_image' 	   	=> get_stylesheet_directory_uri().'/images/slider/slides/8.jpg',
	);

	// Add Slides title color
	aya_customizer_add_color_control( $wp_customize, 'aya_slider_settings', 'aya_slider_titlecolor',
		__( 'Slides Title Color', 'aya' ), '#ffffff' );

	// Add Slides text color
	aya_customizer_add_color_control( $wp_customize, 'aya_slider_settings', 'aya_slider_textcolor',
		__( 'Slides Text Color', 'aya' ), '#ffffff' );

	// Add Slides link color
	aya_customizer_add_color_control( $wp_customize, 'aya_slider_settings', 'aya_slider_linkcolor',
		__( 'Slides Link Color', 'aya' ), '#cccccc' );

	// Add Slides link hover color
	aya_customizer_add_color_control( $wp_customize, 'aya_slider_settings', 'aya_slider_linkhovercolor',
		__( 'Slides Link Hover Color', 'aya' ), '#84c104' );

	// Add Slider Total Width (Large Resolution)
	aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings', 'aya_slider_width_large',
		__( 'Slider Total Width in pixes (Large Resolution)', 'aya' ), '685' );

	// Add Slider Total Width (Medium Resolution)
	aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings', 'aya_slider_width_medium',
		__( 'Slider Total Width in pixes (Medium Resolution)', 'aya' ), '540' );

	// Add Slider Width (Small Resolution)
	aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings', 'aya_slider_width_small',
		__( 'Slider Total Width in pixes (Small Resolution)', 'aya' ), '320' );

	// Add Slide Width (Large Resolution)
	aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings', 'aya_slide_width_large',
		__( 'Slides Width in pixes (Large Resolution)', 'aya' ), '335' );

	// Add Slide Width (Medium Resolution)
	aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings', 'aya_slide_width_medium',
		__( 'Slides Width in pixes (Medium Resolution)', 'aya' ), '260' );

	// Add Slide Width (Small Resolution)
	aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings', 'aya_slide_width_small',
		__( 'Slides Width in pixes (Small Resolution)', 'aya' ), '180' );

	// Add Slide Visible Piece (Large Resolution)
	aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings', 'aya_slide_piece_width_large',
		__( 'Slides Visible Piece in pixes (Large Resolution)', 'aya' ), '50' );

	// Add Slide Visible Piece (Medium Resolution)
	aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings', 'aya_slide_piece_width_medium',
		__( 'Slides Visible Piece in pixes (Medium Resolution)', 'aya' ), '40' );

	// Add Slide Visible Piece (Small Resolution)
	aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings', 'aya_slide_piece_width_small',
		__( 'Slides Visible Piece in pixes (Small Resolution)', 'aya' ), '20' );

	// Add slide settings
	for ( $slideNumber = 1; $slideNumber <= 10; ++$slideNumber ) {

		// Add checkbox to display slide
		aya_customizer_add_checkbox_control( $wp_customize, 'aya_slider_settings',
			'aya_slider_displayslide'.$slideNumber, sprintf( __( 'Display slide #%s in the slider', 'aya' ), $slideNumber ),
			array_key_exists('aya_slider_displayslide'.$slideNumber, $defaultVals) ? $defaultVals['aya_slider_displayslide'.$slideNumber] : null );

		// Add Slide Title
		aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings',
			'aya_slider_slide'.$slideNumber.'_title', sprintf( __( 'Slide #%s Title in the slider', 'aya' ), $slideNumber ),
			array_key_exists('aya_slider_slide'.$slideNumber.'_title', $defaultVals) ? $defaultVals['aya_slider_slide'.$slideNumber.'_title'] : null );

		// Add Slide Text
		aya_customizer_add_textarea_control( $wp_customize, 'aya_slider_settings',
			'aya_slider_slide'.$slideNumber.'_text', sprintf( __( 'Slide #%s Text in the slider', 'aya' ), $slideNumber ),
			array_key_exists('aya_slider_slide'.$slideNumber.'_text', $defaultVals) ? $defaultVals['aya_slider_slide'.$slideNumber.'_text'] : null );
				   
		// Add Slide URL
		aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings',
			'aya_slider_slide'.$slideNumber.'_url', sprintf( __( 'Slide #%s URL in the slider', 'aya' ), $slideNumber ),
			array_key_exists('aya_slider_slide'.$slideNumber.'_url', $defaultVals) ? $defaultVals['aya_slider_slide'.$slideNumber.'_url'] : null );

		// Add checkbox to open slide link in a new window
		aya_customizer_add_checkbox_control( $wp_customize, 'aya_slider_settings',
			'aya_slider_slide'.$slideNumber.'_opennewwindow', sprintf( __( 'Open Slide #%s URL in a new window', 'aya' ), $slideNumber ), null );

		// Add Slide URL Text
		aya_customizer_add_text_control( $wp_customize, 'aya_slider_settings',
			'aya_slider_slide'.$slideNumber.'_urltext', sprintf( __( 'Slide #%s URL Text in the slider', 'aya' ), $slideNumber ), __( 'Read more', 'aya' ) );

		// Add Slide Image
		aya_customizer_add_image_control( $wp_customize, 'aya_slider_settings',
			'aya_slider_slide'.$slideNumber.'_image', sprintf( __( 'Slide #%s Background Image', 'aya' ), $slideNumber ),
			array_key_exists('aya_slider_slide'.$slideNumber.'_image', $defaultVals) ? $defaultVals['aya_slider_slide'.$slideNumber.'_image'] : null );
	}
}

/**
 * Add Colors Settings to the Customizer
 */
function aya_customize_register_colors_settings( $wp_customize ) {

	$wp_customize->remove_control('header_textcolor');

	// add default colors settings
	$defaultVals = array(
		'aya_colors_contentbackgroundcolor'           => '#f7f7f7',
		'aya_colors_textcolor'           => '#555555',
		'aya_colors_linkcolor'           => '#656565',
		'aya_colors_linkhovercolor'           => '#84c104',
		'aya_colors_headingscolor'           => '#555555',
		'aya_colors_buttonbackgroundgradienttop'           => '#FFF000',
		'aya_colors_buttonbackgroundgradientbottom'           => '#639200',
		'aya_colors_headerbackground'           => '#e3fc57',
		'aya_colors_header_textcolor'           => '#555555',
		'aya_colors_header_linkcolor'           => '#656565',
		'aya_colors_header_linkhovercolor'           => '#639200',
		'aya_colors_menutextcolor'           => '#639200',
		'aya_colors_menuhovertextcolor'           => '#656565',
		'aya_colors_menudropdownbackgroundcolor'           => '#fafafa',
		'aya_colors_menudropdowntextcolor'           => '#555555',
		'aya_colors_menuhoverdropdownbackground'           => '#fafafa',
		'aya_colors_menuhoverdropdowntextcolor'           => '#777777',
		'aya_colors_footerbackground'           => '#eeeeee',
		'aya_colors_footertextcolor'           => '#639200',
		'aya_colors_footerlinkcolor'           => '#656565',
		'aya_colors_footerlinkhovercolor'           => '#639200',
	);

	// Add content background color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_contentbackgroundcolor',
		__( 'Content Background Color', 'aya' ), $defaultVals['aya_colors_contentbackgroundcolor'] );

	// Add text color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_textcolor',
		__( 'Text Color', 'aya' ), $defaultVals['aya_colors_textcolor'] );

	// Add link color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_linkcolor',
		__( 'Link Color', 'aya' ), $defaultVals['aya_colors_linkcolor'] );

	// Add link hover color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_linkhovercolor',
		__( 'Link Hover Color', 'aya' ), $defaultVals['aya_colors_linkhovercolor'] );

	// Add headings color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_headingscolor',
		__( 'Headings Color (h1, h2, h3)', 'aya' ), $defaultVals['aya_colors_headingscolor'] );

	// Add button gradient top color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_buttonbackgroundgradienttop',
		__( 'Buttons Gradient Top Background Color', 'aya' ), $defaultVals['aya_colors_buttonbackgroundgradienttop'] );

	// Add button gradient bottom color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_buttonbackgroundgradientbottom',
		__( 'Buttons Gradient Bottom Background Color', 'aya' ), $defaultVals['aya_colors_buttonbackgroundgradientbottom'] );

	// Add header background color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_headerbackground',
		__( 'Header Background Color', 'aya' ), $defaultVals['aya_colors_headerbackground'] );

	// Add Header text color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_header_textcolor',
		__( 'Header Text Color', 'aya' ), $defaultVals['aya_colors_header_textcolor'] );

	// Add Header link color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_header_linkcolor',
		__( 'Header Link Color', 'aya' ), $defaultVals['aya_colors_header_linkcolor'] );

	// Add Header link hover color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_header_linkhovercolor',
		__( 'Header Link Hover Color', 'aya' ), $defaultVals['aya_colors_header_linkhovercolor'] );

	// Add Post Boxes
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_postboxes_background',
		__( 'Post Boxes (tags, categories, etc.) Background Color', 'aya' ), '#e5e5e5' );
		
	// Add Page Header text color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_postboxes_textcolor',
		__( 'Post Boxes (tags, categories, etc.) Text Color', 'aya' ), '#111111' );
	
	// Add Page Header link color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_postboxes_linkcolor',
		__( 'Post Boxes (tags, categories, etc.) Link Color', 'aya' ), '#111111' );

	// Add Page Header link hover color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_postboxes_linkhovercolor',
		__( 'Post Boxes (tags, categories, etc.) Link Hover Color', 'aya' ), '#84c104' );

	// Add menu text color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_menutextcolor',
		__( 'Menu Text Color', 'aya' ), $defaultVals['aya_colors_menutextcolor'] );

	// Add menu text hover color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_menuhovertextcolor',
		__( 'Menu Text Hover Color', 'aya' ), $defaultVals['aya_colors_menuhovertextcolor'] );

	// Add menu drop down background color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_menudropdownbackgroundcolor',
		__( 'Menu Drop Down Background Color', 'aya' ), $defaultVals['aya_colors_menudropdownbackgroundcolor'] );

	// Add menu drop down background color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_menudropdowntextcolor',
		__( 'Menu Drop Down Text Color', 'aya' ), $defaultVals['aya_colors_menudropdowntextcolor'] );

	// Add menu hover background color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_menuhoverdropdownbackground',
		__( 'Menu Drop Down Hover Background Color', 'aya' ), $defaultVals['aya_colors_menuhoverdropdownbackground'] );

	// Add menu drop down text hover color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_menuhoverdropdowntextcolor',
		__( 'Menu Drop Down Hover Text Color', 'aya' ), $defaultVals['aya_colors_menuhoverdropdowntextcolor'] );

	// Add footer background color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_footerbackground',
		__( 'Footer Background Color', 'aya' ), $defaultVals['aya_colors_footerbackground'] );

	// Add footer text color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_footertextcolor',
		__( 'Footer Text Color', 'aya' ), $defaultVals['aya_colors_footertextcolor'] );

	// Add footer link color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_footerlinkcolor',
		__( 'Footer Link Color', 'aya' ), $defaultVals['aya_colors_footerlinkcolor'] );

	// Add footer link hover color
	aya_customizer_add_color_control( $wp_customize, 'colors', 'aya_colors_footerlinkhovercolor',
		__( 'Footer Link Hover Color', 'aya' ), $defaultVals['aya_colors_footerlinkhovercolor'] );
}

/**
 * Add Social Settings to the Customizer
 */
function aya_customize_register_social_settings( $wp_customize ) {

	// Add Social Settings Section
	aya_customizer_add_section( $wp_customize, 'aya_social_settings', __( 'Social Sites', 'aya' ) );

	// Add Facebook Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_facebook', __('Facebook', 'aya'),
		'https://www.facebook.com/ayatemplates' );

	// Add Google+ Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_googleplus', __('Google+', 'aya'),
		'https://plus.google.com' );

	// Add Twitter Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_twitter', __('Twitter', 'aya'),
		'https://twitter.com/ayatemplates' );

	// Add LinkedIn Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_linkedin', __('LinkedIn', 'aya'),
		'https://www.linkedin.com' );

	// Add Instagram Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_instagram', __('Instagram', 'aya'),
		'https://instagram.com/' );

	// Add RSS Feeds Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_rss', __('RSS Feeds', 'aya'),
		get_bloginfo( 'rss2_url' ) );

	// Add Tumblr Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_tumblr', __('Tumblr', 'aya'),
		'https://www.tumblr.com/' );

	// Add YouTube channel Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_youtube', __('YouTube channel', 'aya'),
		'http://www.youtube.com/' );

	// Add Pinterest Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_pinterest', __('Pinterest', 'aya'),
		'http://www.pinterest.com/' );

	// Add VK Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_vk', __('VK', 'aya'),
		'http://vk.com/' );

	// Add Flickr Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_flickr', __('Flickr', 'aya'),
		'http://flickr.com/' );

	// Add Vine Text Control
	aya_customizer_add_text_control( $wp_customize, 'aya_social_settings',
		'aya_social_vine', __('Vine', 'aya'),
		'https://vine.co/' );
}

/**
 * Add Thumbnails Settings to the Customizer
 */
function aya_customize_register_thumbnails_settings( $wp_customize ) {

	// Add Thumbnails Settings Section
	aya_customizer_add_section( $wp_customize, 'aya_thumbnails_settings', __( 'Thumbnails', 'aya' ) );

	// Add Enable Thumbnails Functionality
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_thumbnails_settings',
		'aya_thumbnails_enablethumbnails', __( 'Globally Enable Thumbnails functionality', 'aya' ), 1 );

	// Add Thumbnail Image Size in Index Pages
	aya_customizer_add_select_control( $wp_customize, 'aya_thumbnails_settings',
			'aya_thumbnails_size', __( 'Thumbnail image size in Index Pages', 'aya' ),
			'full', array( 'none'   => __( 'none', 'aya' ),
							'thumbnail'  => __( 'thumbnail', 'aya' ),
							'medium'  => __( 'medium', 'aya' ),
							'large'  => __( 'large', 'aya' ),
							'full'  => __( 'full', 'aya' ),
						  ) );

	// Add Link Thumbnail Image to Single Post
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_thumbnails_settings',
		'aya_thumbnails_linkthumbnails', __( 'Link Thumbnails to Single Post URLs', 'aya' ), 1 );

	// Add Display Thumbnail in Single Post
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_thumbnails_settings',
		'aya_thumbnails_displayinsingle', __( 'Display in Single Post', 'aya' ), 1 );

	// Add Thumbnail Image Size in Single Post
	aya_customizer_add_select_control( $wp_customize, 'aya_thumbnails_settings',
			'aya_thumbnails_sizeinsinglepost', __( 'Thumbnail image size in Single Posts', 'aya' ),
			'full', array( 'none'   => __( 'none', 'aya' ),
						   'thumbnail'  => __( 'thumbnail', 'aya' ),
						   'medium'  => __( 'medium', 'aya' ),
						   'large'  => __( 'large', 'aya' ),
						   'full'  => __( 'full', 'aya' ),
						  ) );
}



/**
 * Add Not Found Settings to the Customizer
 */
function aya_customize_register_notfound_settings( $wp_customize ) {

	// Add Not Found Settings Section
	aya_customizer_add_section( $wp_customize, 'aya_notfound_settings', __( '404 Not Found Page', 'aya' ) );

	// Add 404 image
	aya_customizer_add_image_control( $wp_customize, 'aya_notfound_settings',
		'aya_notfound_image', __( 'Image', 'aya' ), get_stylesheet_directory_uri().'/images/404.png' );

	// Add title
	aya_customizer_add_text_control( $wp_customize, 'aya_notfound_settings',
		'aya_notfound_title', __( 'Title', 'aya' ), 'Error 404: Not Found' );

	// Add content
	aya_customizer_add_textarea_control( $wp_customize, 'aya_notfound_settings',
		'aya_notfound_content', __( 'Content', 'aya' ),
		'<p>Sorry. The page you are looking for does not exist.</p>' );
}

/**
 * Add WooCommerce Settings to the Customizer
 */
function aya_customize_register_woocommerce_settings( $wp_customize ) {

	// Add Not Found Settings Section
	aya_customizer_add_section( $wp_customize, 'aya_woocommerce_settings', __( 'WooCommerce', 'aya' ) );

	// Add Display of WooCommerce Sidebar
	aya_customizer_add_checkbox_control( $wp_customize, 'aya_woocommerce_settings',
		'aya_woocommerce_displaysidebar', __( 'Display WooCommerce Sidebar', 'aya' ), 1 );

	// Add Number of Products per Page
	aya_customizer_add_text_control( $wp_customize, 'aya_woocommerce_settings',
		'aya_woocommerce_productsperpage', __( 'Products per Page', 'aya' ), 10 );
}


function aya_customize_register_font_settings( $wp_customize ) {

	define('DEFAULT_FONT_NAME', 'PT+Sans');
	define('BODY_FONT_SIZE', '13');
	define('BODY_H1_SIZE', '26');
	define('BODY_H2_SIZE', '22');
	define('BODY_H3_SIZE', '20');
	define('BODY_H4_SIZE', '18');
	define('BODY_MENU_LARGE_SIZE', '14');
	define('BODY_MENU_SMALL_SIZE', '13');
	define('SECTION_TITLE_SIZE', '20');
	define('FOOTER_SECTION_TITLE_SIZE', '21');

	// Add Not Found Settings Section
	aya_customizer_add_section( $wp_customize, 'aya_font_settings', __( 'Font', 'aya' ) );

	// Layout Options
	aya_customizer_add_select_control( $wp_customize, 'aya_font_settings',
			'aya_font_name', __( 'Font Name', 'aya' ), DEFAULT_FONT_NAME,
			array(                     'ABeeZee' => 'ABeeZee',
                   'Abel' => 'Abel',
                   'Abril+Fatface' => 'Abril Fatface',
                   'Aclonica' => 'Aclonica',
                   'Acme' => 'Acme',
                   'Actor' => 'Actor',
                   'Adamina' => 'Adamina',
                   'Advent+Pro' => 'Advent Pro',
                   'Aguafina+Script' => 'Aguafina Script',
                   'Akronim' => 'Akronim',
                   'Aladin' => 'Aladin',
                   'Aldrich' => 'Aldrich',
                   'Alef' => 'Alef',
                   'Alegreya' => 'Alegreya',
                   'Alegreya+SC' => 'Alegreya SC',
                   'Alegreya+Sans' => 'Alegreya Sans',
                   'Alegreya+Sans+SC' => 'Alegreya Sans SC',
                   'Alex+Brush' => 'Alex Brush',
                   'Alfa+Slab+One' => 'Alfa Slab One',
                   'Alice' => 'Alice',
                   'Alike' => 'Alike',
                   'Alike+Angular' => 'Alike Angular',
                   'Allan' => 'Allan',
                   'Allerta' => 'Allerta',
                   'Allerta+Stencil' => 'Allerta Stencil',
                   'Allura' => 'Allura',
                   'Almendra' => 'Almendra',
                   'Almendra+Display' => 'Almendra Display',
                   'Almendra+SC' => 'Almendra SC',
                   'Amarante' => 'Amarante',
                   'Amaranth' => 'Amaranth',
                   'Amatic+SC' => 'Amatic SC',
                   'Amethysta' => 'Amethysta',
                   'Amiri' => 'Amiri',
                   'Amita' => 'Amita',
                   'Anaheim' => 'Anaheim',
                   'Andada' => 'Andada',
                   'Andika' => 'Andika',
                   'Angkor' => 'Angkor',
                   'Annie+Use+Your+Telescope' => 'Annie Use Your Telescope',
                   'Anonymous+Pro' => 'Anonymous Pro',
                   'Antic' => 'Antic',
                   'Antic+Didone' => 'Antic Didone',
                   'Antic+Slab' => 'Antic Slab',
                   'Anton' => 'Anton',
                   'Arapey' => 'Arapey',
                   'Arbutus' => 'Arbutus',
                   'Arbutus+Slab' => 'Arbutus Slab',
                   'Architects+Daughter' => 'Architects Daughter',
                   'Archivo+Black' => 'Archivo Black',
                   'Archivo+Narrow' => 'Archivo Narrow',
                   'Arimo' => 'Arimo',
                   'Arizonia' => 'Arizonia',
                   'Armata' => 'Armata',
                   'Artifika' => 'Artifika',
                   'Arvo' => 'Arvo',
                   'Arya' => 'Arya',
                   'Asap' => 'Asap',
                   'Asar' => 'Asar',
                   'Asset' => 'Asset',
                   'Astloch' => 'Astloch',
                   'Asul' => 'Asul',
                   'Atomic+Age' => 'Atomic Age',
                   'Aubrey' => 'Aubrey',
                   'Audiowide' => 'Audiowide',
                   'Autour+One' => 'Autour One',
                   'Average' => 'Average',
                   'Average+Sans' => 'Average Sans',
                   'Averia+Gruesa+Libre' => 'Averia Gruesa Libre',
                   'Averia+Libre' => 'Averia Libre',
                   'Averia+Sans+Libre' => 'Averia Sans Libre',
                   'Averia+Serif+Libre' => 'Averia Serif Libre',
                   'Bad+Script' => 'Bad Script',
                   'Balthazar' => 'Balthazar',
                   'Bangers' => 'Bangers',
                   'Basic' => 'Basic',
                   'Battambang' => 'Battambang',
                   'Baumans' => 'Baumans',
                   'Bayon' => 'Bayon',
                   'Belgrano' => 'Belgrano',
                   'Belleza' => 'Belleza',
                   'BenchNine' => 'BenchNine',
                   'Bentham' => 'Bentham',
                   'Berkshire+Swash' => 'Berkshire Swash',
                   'Bevan' => 'Bevan',
                   'Bigelow+Rules' => 'Bigelow Rules',
                   'Bigshot+One' => 'Bigshot One',
                   'Bilbo' => 'Bilbo',
                   'Bilbo+Swash+Caps' => 'Bilbo Swash Caps',
                   'Biryani' => 'Biryani',
                   'Bitter' => 'Bitter',
                   'Black+Ops+One' => 'Black Ops One',
                   'Bokor' => 'Bokor',
                   'Bonbon' => 'Bonbon',
                   'Boogaloo' => 'Boogaloo',
                   'Bowlby+One' => 'Bowlby One',
                   'Bowlby+One+SC' => 'Bowlby One SC',
                   'Brawler' => 'Brawler',
                   'Bree+Serif' => 'Bree Serif',
                   'Bubblegum+Sans' => 'Bubblegum Sans',
                   'Bubbler+One' => 'Bubbler One',
                   'Buda' => 'Buda',
                   'Buenard' => 'Buenard',
                   'Butcherman' => 'Butcherman',
                   'Butterfly+Kids' => 'Butterfly Kids',
                   'Cabin' => 'Cabin',
                   'Cabin+Condensed' => 'Cabin Condensed',
                   'Cabin+Sketch' => 'Cabin Sketch',
                   'Caesar+Dressing' => 'Caesar Dressing',
                   'Cagliostro' => 'Cagliostro',
                   'Calligraffitti' => 'Calligraffitti',
                   'Cambay' => 'Cambay',
                   'Cambo' => 'Cambo',
                   'Candal' => 'Candal',
                   'Cantarell' => 'Cantarell',
                   'Cantata+One' => 'Cantata One',
                   'Cantora+One' => 'Cantora One',
                   'Capriola' => 'Capriola',
                   'Cardo' => 'Cardo',
                   'Carme' => 'Carme',
                   'Carrois+Gothic' => 'Carrois Gothic',
                   'Carrois+Gothic+SC' => 'Carrois Gothic SC',
                   'Carter+One' => 'Carter One',
                   'Catamaran' => 'Catamaran',
                   'Caudex' => 'Caudex',
                   'Caveat' => 'Caveat',
                   'Caveat+Brush' => 'Caveat Brush',
                   'Cedarville+Cursive' => 'Cedarville Cursive',
                   'Ceviche+One' => 'Ceviche One',
                   'Changa+One' => 'Changa One',
                   'Chango' => 'Chango',
                   'Chau+Philomene+One' => 'Chau Philomene One',
                   'Chela+One' => 'Chela One',
                   'Chelsea+Market' => 'Chelsea Market',
                   'Chenla' => 'Chenla',
                   'Cherry+Cream+Soda' => 'Cherry Cream Soda',
                   'Cherry+Swash' => 'Cherry Swash',
                   'Chewy' => 'Chewy',
                   'Chicle' => 'Chicle',
                   'Chivo' => 'Chivo',
                   'Chonburi' => 'Chonburi',
                   'Cinzel' => 'Cinzel',
                   'Cinzel+Decorative' => 'Cinzel Decorative',
                   'Clicker+Script' => 'Clicker Script',
                   'Coda' => 'Coda',
                   'Coda+Caption' => 'Coda Caption',
                   'Codystar' => 'Codystar',
                   'Combo' => 'Combo',
                   'Comfortaa' => 'Comfortaa',
                   'Coming+Soon' => 'Coming Soon',
                   'Concert+One' => 'Concert One',
                   'Condiment' => 'Condiment',
                   'Content' => 'Content',
                   'Contrail+One' => 'Contrail One',
                   'Convergence' => 'Convergence',
                   'Cormorant+Garamond' => 'Cormorant Garamond',
                   'Cookie' => 'Cookie',
                   'Copse' => 'Copse',
                   'Corben' => 'Corben',
                   'Courgette' => 'Courgette',
                   'Cousine' => 'Cousine',
                   'Coustard' => 'Coustard',
                   'Covered+By+Your+Grace' => 'Covered By Your Grace',
                   'Crafty+Girls' => 'Crafty Girls',
                   'Creepster' => 'Creepster',
                   'Crete+Round' => 'Crete Round',
                   'Crimson+Text' => 'Crimson Text',
                   'Croissant+One' => 'Croissant One',
                   'Crushed' => 'Crushed',
                   'Cuprum' => 'Cuprum',
                   'Cutive' => 'Cutive',
                   'Cutive+Mono' => 'Cutive Mono',
                   'Damion' => 'Damion',
                   'Dancing+Script' => 'Dancing Script',
                   'Dangrek' => 'Dangrek',
                   'Dawning+of+a+New+Day' => 'Dawning of a New Day',
                   'Days+One' => 'Days One',
                   'Dekko' => 'Dekko',
                   'Delius' => 'Delius',
                   'Delius+Swash+Caps' => 'Delius Swash Caps',
                   'Delius+Unicase' => 'Delius Unicase',
                   'Della+Respira' => 'Della Respira',
                   'Denk+One' => 'Denk One',
                   'Devonshire' => 'Devonshire',
                   'Dhurjati' => 'Dhurjati',
                   'Didact+Gothic' => 'Didact Gothic',
                   'Diplomata' => 'Diplomata',
                   'Diplomata+SC' => 'Diplomata SC',
                   'Domine' => 'Domine',
                   'Donegal+One' => 'Donegal One',
                   'Doppio+One' => 'Doppio One',
                   'Dorsa' => 'Dorsa',
                   'Dosis' => 'Dosis',
                   'Dr+Sugiyama' => 'Dr Sugiyama',
                   'Droid+Sans' => 'Droid Sans',
                   'Droid+Sans+Mono' => 'Droid Sans Mono',
                   'Droid+Serif' => 'Droid Serif',
                   'Duru+Sans' => 'Duru Sans',
                   'Dynalight' => 'Dynalight',
                   'EB+Garamond' => 'EB Garamond',
                   'Eagle+Lake' => 'Eagle Lake',
                   'Eater' => 'Eater',
                   'Economica' => 'Economica',
                   'Eczar' => 'Eczar',
                   'Ek+Mukta' => 'Ek Mukta',
                   'Electrolize' => 'Electrolize',
                   'Elsie' => 'Elsie',
                   'Elsie+Swash+Caps' => 'Elsie Swash Caps',
                   'Emblema+One' => 'Emblema One',
                   'Emilys+Candy' => 'Emilys Candy',
                   'Engagement' => 'Engagement',
                   'Englebert' => 'Englebert',
                   'Enriqueta' => 'Enriqueta',
                   'Erica+One' => 'Erica One',
                   'Esteban' => 'Esteban',
                   'Euphoria+Script' => 'Euphoria Script',
                   'Ewert' => 'Ewert',
                   'Exo' => 'Exo',
                   'Exo+2' => 'Exo 2',
                   'Expletus+Sans' => 'Expletus Sans',
                   'Fanwood+Text' => 'Fanwood Text',
                   'Fascinate' => 'Fascinate',
                   'Fascinate+Inline' => 'Fascinate Inline',
                   'Faster+One' => 'Faster One',
                   'Fasthand' => 'Fasthand',
                   'Fauna+One' => 'Fauna One',
                   'Federant' => 'Federant',
                   'Federo' => 'Federo',
                   'Felipa' => 'Felipa',
                   'Fenix' => 'Fenix',
                   'Finger+Paint' => 'Finger Paint',
                   'Fira+Mono' => 'Fira Mono',
                   'Fira+Sans' => 'Fira Sans',
                   'Fjalla+One' => 'Fjalla One',
                   'Fjord+One' => 'Fjord One',
                   'Flamenco' => 'Flamenco',
                   'Flavors' => 'Flavors',
                   'Fondamento' => 'Fondamento',
                   'Fontdiner+Swanky' => 'Fontdiner Swanky',
                   'Forum' => 'Forum',
                   'Francois+One' => 'Francois One',
                   'Freckle+Face' => 'Freckle Face',
                   'Fredericka+the+Great' => 'Fredericka the Great',
                   'Fredoka+One' => 'Fredoka One',
                   'Freehand' => 'Freehand',
                   'Fresca' => 'Fresca',
                   'Frijole' => 'Frijole',
                   'Fruktur' => 'Fruktur',
                   'Fugaz+One' => 'Fugaz One',
                   'GFS+Didot' => 'GFS Didot',
                   'GFS+Neohellenic' => 'GFS Neohellenic',
                   'Gabriela' => 'Gabriela',
                   'Gafata' => 'Gafata',
                   'Galdeano' => 'Galdeano',
                   'Galindo' => 'Galindo',
                   'Gentium+Basic' => 'Gentium Basic',
                   'Gentium+Book+Basic' => 'Gentium Book Basic',
                   'Geo' => 'Geo',
                   'Geostar' => 'Geostar',
                   'Geostar+Fill' => 'Geostar Fill',
                   'Germania+One' => 'Germania One',
                   'Gidugu' => 'Gidugu',
                   'Gilda+Display' => 'Gilda Display',
                   'Give+You+Glory' => 'Give You Glory',
                   'Glass+Antiqua' => 'Glass Antiqua',
                   'Glegoo' => 'Glegoo',
                   'Gloria+Hallelujah' => 'Gloria Hallelujah',
                   'Goblin+One' => 'Goblin One',
                   'Gochi+Hand' => 'Gochi Hand',
                   'Gorditas' => 'Gorditas',
                   'Goudy+Bookletter+1911' => 'Goudy Bookletter 1911',
                   'Graduate' => 'Graduate',
                   'Grand+Hotel' => 'Grand Hotel',
                   'Gravitas+One' => 'Gravitas One',
                   'Great+Vibes' => 'Great Vibes',
                   'Griffy' => 'Griffy',
                   'Gruppo' => 'Gruppo',
                   'Gudea' => 'Gudea',
                   'Gurajada' => 'Gurajada',
                   'Habibi' => 'Habibi',
                   'Halant' => 'Halant',
                   'Hammersmith+One' => 'Hammersmith One',
                   'Hanalei' => 'Hanalei',
                   'Hanalei+Fill' => 'Hanalei Fill',
                   'Handlee' => 'Handlee',
                   'Hanuman' => 'Hanuman',
                   'Happy+Monkey' => 'Happy Monkey',
                   'Headland+One' => 'Headland One',
                   'Henny+Penny' => 'Henny Penny',
                   'Herr+Von+Muellerhoff' => 'Herr Von Muellerhoff',
                   'Hind' => 'Hind',
                   'Hind+Siliguri' => 'Hind Siliguri',
                   'Hind+Vadodara' => 'Hind Vadodara',
                   'Holtwood+One+SC' => 'Holtwood One SC',
                   'Homemade+Apple' => 'Homemade Apple',
                   'Homenaje' => 'Homenaje',
                   'IM+Fell+DW+Pica' => 'IM Fell DW Pica',
                   'IM+Fell+DW+Pica+SC' => 'IM Fell DW Pica SC',
                   'IM+Fell+Double+Pica' => 'IM Fell Double Pica',
                   'IM+Fell+Double+Pica+SC' => 'IM Fell Double Pica SC',
                   'IM+Fell+English' => 'IM Fell English',
                   'IM+Fell+English+SC' => 'IM Fell English SC',
                   'IM+Fell+French+Canon' => 'IM Fell French Canon',
                   'IM+Fell+French+Canon+SC' => 'IM Fell French Canon SC',
                   'IM+Fell+Great+Primer' => 'IM Fell Great Primer',
                   'IM+Fell+Great+Primer+SC' => 'IM Fell Great Primer SC',
                   'Iceberg' => 'Iceberg',
                   'Iceland' => 'Iceland',
                   'Imprima' => 'Imprima',
                   'Inconsolata' => 'Inconsolata',
                   'Inder' => 'Inder',
                   'Indie+Flower' => 'Indie Flower',
                   'Inika' => 'Inika',
                   'Inknut+Antiqua' => 'Inknut Antiqua',
                   'Irish+Grover' => 'Irish Grover',
                   'Istok+Web' => 'Istok Web',
                   'Italiana' => 'Italiana',
                   'Italianno' => 'Italianno',
                   'Itim' => 'Itim',
                   'Jacques+Francois' => 'Jacques Francois',
                   'Jacques+Francois+Shadow' => 'Jacques Francois Shadow',
                   'Jaldi' => 'Jaldi',
                   'Jim+Nightshade' => 'Jim Nightshade',
                   'Jockey+One' => 'Jockey One',
                   'Jolly+Lodger' => 'Jolly Lodger',
                   'Josefin+Sans' => 'Josefin Sans',
                   'Josefin+Slab' => 'Josefin Slab',
                   'Joti+One' => 'Joti One',
                   'Judson' => 'Judson',
                   'Julee' => 'Julee',
                   'Julius+Sans+One' => 'Julius Sans One',
                   'Junge' => 'Junge',
                   'Jura' => 'Jura',
                   'Just+Another+Hand' => 'Just Another Hand',
                   'Just+Me+Again+Down+Here' => 'Just Me Again Down Here',
                   'Kadwa' => 'Kadwa',
                   'Kalam' => 'Kalam',
                   'Kameron' => 'Kameron',
                   'Kanit' => 'Kanit',
                   'Kantumruy' => 'Kantumruy',
                   'Karla' => 'Karla',
                   'Karma' => 'Karma',
                   'Kaushan+Script' => 'Kaushan Script',
                   'Kavoon' => 'Kavoon',
                   'Kdam+Thmor' => 'Kdam Thmor',
                   'Keania+One' => 'Keania One',
                   'Kelly+Slab' => 'Kelly Slab',
                   'Kenia' => 'Kenia',
                   'Khand' => 'Khand',
                   'Khmer' => 'Khmer',
                   'Khula' => 'Khula',
                   'Kite+One' => 'Kite One',
                   'Knewave' => 'Knewave',
                   'Kotta+One' => 'Kotta One',
                   'Koulen' => 'Koulen',
                   'Kranky' => 'Kranky',
                   'Kreon' => 'Kreon',
                   'Kristi' => 'Kristi',
                   'Krona+One' => 'Krona One',
                   'Kurale' => 'Kurale',
                   'La+Belle+Aurore' => 'La Belle Aurore',
                   'Laila' => 'Laila',
                   'Lakki+Reddy' => 'Lakki Reddy',
                   'Lancelot' => 'Lancelot',
                   'Lateef' => 'Lateef',
                   'Lato' => 'Lato',
                   'League+Script' => 'League Script',
                   'Leckerli+One' => 'Leckerli One',
                   'Ledger' => 'Ledger',
                   'Lekton' => 'Lekton',
                   'Lemon' => 'Lemon',
                   'Libre+Baskerville' => 'Libre Baskerville',
                   'Life+Savers' => 'Life Savers',
                   'Lilita+One' => 'Lilita One',
                   'Lily+Script+One' => 'Lily Script One',
                   'Limelight' => 'Limelight',
                   'Linden+Hill' => 'Linden Hill',
                   'Lobster' => 'Lobster',
                   'Lobster+Two' => 'Lobster Two',
                   'Londrina+Outline' => 'Londrina Outline',
                   'Londrina+Shadow' => 'Londrina Shadow',
                   'Londrina+Sketch' => 'Londrina Sketch',
                   'Londrina+Solid' => 'Londrina Solid',
                   'Lora' => 'Lora',
                   'Love+Ya+Like+A+Sister' => 'Love Ya Like A Sister',
                   'Loved+by+the+King' => 'Loved by the King',
                   'Lovers+Quarrel' => 'Lovers Quarrel',
                   'Luckiest+Guy' => 'Luckiest Guy',
                   'Lusitana' => 'Lusitana',
                   'Lustria' => 'Lustria',
                   'Macondo' => 'Macondo',
                   'Macondo+Swash+Caps' => 'Macondo Swash Caps',
                   'Magra' => 'Magra',
                   'Maiden+Orange' => 'Maiden Orange',
                   'Mako' => 'Mako',
                   'Mallanna' => 'Mallanna',
                   'Mandali' => 'Mandali',
                   'Marcellus' => 'Marcellus',
                   'Marcellus+SC' => 'Marcellus SC',
                   'Marck+Script' => 'Marck Script',
                   'Margarine' => 'Margarine',
                   'Marko+One' => 'Marko One',
                   'Marmelad' => 'Marmelad',
                   'Martel' => 'Martel',
                   'Martel+Sans' => 'Martel Sans',
                   'Marvel' => 'Marvel',
                   'Mate' => 'Mate',
                   'Mate+SC' => 'Mate SC',
                   'Maven+Pro' => 'Maven Pro',
                   'McLaren' => 'McLaren',
                   'Meddon' => 'Meddon',
                   'MedievalSharp' => 'MedievalSharp',
                   'Medula+One' => 'Medula One',
                   'Megrim' => 'Megrim',
                   'Meie+Script' => 'Meie Script',
                   'Merienda' => 'Merienda',
                   'Merienda+One' => 'Merienda One',
                   'Merriweather' => 'Merriweather',
                   'Merriweather+Sans' => 'Merriweather Sans',
                   'Metal' => 'Metal',
                   'Metal+Mania' => 'Metal Mania',
                   'Metamorphous' => 'Metamorphous',
                   'Metrophobic' => 'Metrophobic',
                   'Michroma' => 'Michroma',
                   'Milonga' => 'Milonga',
                   'Miltonian' => 'Miltonian',
                   'Miltonian+Tattoo' => 'Miltonian Tattoo',
                   'Miniver' => 'Miniver',
                   'Miss+Fajardose' => 'Miss Fajardose',
                   'Modak' => 'Modak',
                   'Modern+Antiqua' => 'Modern Antiqua',
                   'Molengo' => 'Molengo',
                   'Molle' => 'Molle',
                   'Monda' => 'Monda',
                   'Monofett' => 'Monofett',
                   'Monoton' => 'Monoton',
                   'Monsieur+La+Doulaise' => 'Monsieur La Doulaise',
                   'Montaga' => 'Montaga',
                   'Montez' => 'Montez',
                   'Montserrat' => 'Montserrat',
                   'Montserrat+Alternates' => 'Montserrat Alternates',
                   'Montserrat+Subrayada' => 'Montserrat Subrayada',
                   'Moul' => 'Moul',
                   'Moulpali' => 'Moulpali',
                   'Mountains+of+Christmas' => 'Mountains of Christmas',
                   'Mouse+Memoirs' => 'Mouse Memoirs',
                   'Mr+Bedfort' => 'Mr Bedfort',
                   'Mr+Dafoe' => 'Mr Dafoe',
                   'Mr+De+Haviland' => 'Mr De Haviland',
                   'Mrs+Saint+Delafield' => 'Mrs Saint Delafield',
                   'Mrs+Sheppards' => 'Mrs Sheppards',
                   'Muli' => 'Muli',
                   'Mystery+Quest' => 'Mystery Quest',
                   'NTR' => 'NTR',
                   'Neucha' => 'Neucha',
                   'Neuton' => 'Neuton',
                   'New+Rocker' => 'New Rocker',
                   'News+Cycle' => 'News Cycle',
                   'Niconne' => 'Niconne',
                   'Nixie+One' => 'Nixie One',
                   'Nobile' => 'Nobile',
                   'Nokora' => 'Nokora',
                   'Norican' => 'Norican',
                   'Nosifer' => 'Nosifer',
                   'Nothing+You+Could+Do' => 'Nothing You Could Do',
                   'Noticia+Text' => 'Noticia Text',
                   'Noto+Sans' => 'Noto Sans',
                   'Noto+Serif' => 'Noto Serif',
                   'Nova+Cut' => 'Nova Cut',
                   'Nova+Flat' => 'Nova Flat',
                   'Nova+Mono' => 'Nova Mono',
                   'Nova+Oval' => 'Nova Oval',
                   'Nova+Round' => 'Nova Round',
                   'Nova+Script' => 'Nova Script',
                   'Nova+Slim' => 'Nova Slim',
                   'Nova+Square' => 'Nova Square',
                   'Numans' => 'Numans',
                   'Nunito' => 'Nunito',
                   'Odor+Mean+Chey' => 'Odor Mean Chey',
                   'Offside' => 'Offside',
                   'Old+Standard+TT' => 'Old Standard TT',
                   'Oldenburg' => 'Oldenburg',
                   'Oleo+Script' => 'Oleo Script',
                   'Oleo+Script+Swash+Caps' => 'Oleo Script Swash Caps',
                   'Open+Sans' => 'Open Sans',
                   'Open+Sans+Condensed' => 'Open Sans Condensed',
                   'Oranienbaum' => 'Oranienbaum',
                   'Orbitron' => 'Orbitron',
                   'Oregano' => 'Oregano',
                   'Orienta' => 'Orienta',
                   'Original+Surfer' => 'Original Surfer',
                   'Oswald' => 'Oswald',
                   'Over+the+Rainbow' => 'Over the Rainbow',
                   'Overlock' => 'Overlock',
                   'Overlock+SC' => 'Overlock SC',
                   'Ovo' => 'Ovo',
                   'Oxygen' => 'Oxygen',
                   'Oxygen+Mono' => 'Oxygen Mono',
                   'PT+Mono' => 'PT Mono',
                   'PT+Sans' => 'PT Sans',
                   'PT+Sans+Caption' => 'PT Sans Caption',
                   'PT+Sans+Narrow' => 'PT Sans Narrow',
                   'PT+Serif' => 'PT Serif',
                   'PT+Serif+Caption' => 'PT Serif Caption',
                   'Pacifico' => 'Pacifico',
                   'Palanquin' => 'Palanquin',
                   'Palanquin+Dark' => 'Palanquin Dark',
                   'Paprika' => 'Paprika',
                   'Parisienne' => 'Parisienne',
                   'Passero+One' => 'Passero One',
                   'Passion+One' => 'Passion One',
                   'Pathway+Gothic+One' => 'Pathway Gothic One',
                   'Patrick+Hand' => 'Patrick Hand',
                   'Patrick+Hand+SC' => 'Patrick Hand SC',
                   'Patua+One' => 'Patua One',
                   'Paytone+One' => 'Paytone One',
                   'Peddana' => 'Peddana',
                   'Peralta' => 'Peralta',
                   'Permanent+Marker' => 'Permanent Marker',
                   'Petit+Formal+Script' => 'Petit Formal Script',
                   'Petrona' => 'Petrona',
                   'Philosopher' => 'Philosopher',
                   'Piedra' => 'Piedra',
                   'Pinyon+Script' => 'Pinyon Script',
                   'Pirata+One' => 'Pirata One',
                   'Plaster' => 'Plaster',
                   'Play' => 'Play',
                   'Playball' => 'Playball',
                   'Playfair+Display' => 'Playfair Display',
                   'Playfair+Display+SC' => 'Playfair Display SC',
                   'Podkova' => 'Podkova',
                   'Poiret+One' => 'Poiret One',
                   'Poller+One' => 'Poller One',
                   'Poly' => 'Poly',
                   'Pompiere' => 'Pompiere',
                   'Pontano+Sans' => 'Pontano Sans',
                   'Poppins' => 'Poppins',
                   'Port+Lligat+Sans' => 'Port Lligat Sans',
                   'Port+Lligat+Slab' => 'Port Lligat Slab',
                   'Pragati+Narrow' => 'Pragati Narrow',
                   'Prata' => 'Prata',
                   'Preahvihear' => 'Preahvihear',
                   'Press+Start+2P' => 'Press Start 2P',
                   'Princess+Sofia' => 'Princess Sofia',
                   'Prociono' => 'Prociono',
                   'Prosto+One' => 'Prosto One',
                   'Puritan' => 'Puritan',
                   'Purple+Purse' => 'Purple Purse',
                   'Quando' => 'Quando',
                   'Quantico' => 'Quantico',
                   'Quattrocento' => 'Quattrocento',
                   'Quattrocento+Sans' => 'Quattrocento Sans',
                   'Questrial' => 'Questrial',
                   'Quicksand' => 'Quicksand',
                   'Quintessential' => 'Quintessential',
                   'Qwigley' => 'Qwigley',
                   'Racing+Sans+One' => 'Racing Sans One',
                   'Radley' => 'Radley',
                   'Rajdhani' => 'Rajdhani',
                   'Raleway' => 'Raleway',
                   'Raleway+Dots' => 'Raleway Dots',
                   'Ramabhadra' => 'Ramabhadra',
                   'Ramaraja' => 'Ramaraja',
                   'Rambla' => 'Rambla',
                   'Rammetto+One' => 'Rammetto One',
                   'Ranchers' => 'Ranchers',
                   'Rancho' => 'Rancho',
                   'Ranga' => 'Ranga',
                   'Rationale' => 'Rationale',
                   'Ravi+Prakash' => 'Ravi Prakash',
                   'Redressed' => 'Redressed',
                   'Reenie+Beanie' => 'Reenie Beanie',
                   'Revalia' => 'Revalia',
                   'Rhodium+Libre' => 'Rhodium Libre',
                   'Ribeye' => 'Ribeye',
                   'Ribeye+Marrow' => 'Ribeye Marrow',
                   'Righteous' => 'Righteous',
                   'Risque' => 'Risque',
                   'Roboto' => 'Roboto',
                   'Roboto+Condensed' => 'Roboto Condensed',
                   'Roboto+Mono' => 'Roboto Mono',
                   'Roboto+Slab' => 'Roboto Slab',
                   'Rochester' => 'Rochester',
                   'Rock+Salt' => 'Rock Salt',
                   'Rokkitt' => 'Rokkitt',
                   'Romanesco' => 'Romanesco',
                   'Ropa+Sans' => 'Ropa Sans',
                   'Rosario' => 'Rosario',
                   'Rosarivo' => 'Rosarivo',
                   'Rouge+Script' => 'Rouge Script',
                   'Rozha+One' => 'Rozha One',
                   'Rubik' => 'Rubik',
                   'Rubik+Mono+One' => 'Rubik Mono One',
                   'Rubik+One' => 'Rubik One',
                   'Ruda' => 'Ruda',
                   'Rufina' => 'Rufina',
                   'Ruge+Boogie' => 'Ruge Boogie',
                   'Ruluko' => 'Ruluko',
                   'Rum+Raisin' => 'Rum Raisin',
                   'Ruslan+Display' => 'Ruslan Display',
                   'Russo+One' => 'Russo One',
                   'Ruthie' => 'Ruthie',
                   'Rye' => 'Rye',
                   'Sacramento' => 'Sacramento',
                   'Sahitya' => 'Sahitya',
                   'Sail' => 'Sail',
                   'Salsa' => 'Salsa',
                   'Sanchez' => 'Sanchez',
                   'Sancreek' => 'Sancreek',
                   'Sansita+One' => 'Sansita One',
                   'Sarala' => 'Sarala',
                   'Sarina' => 'Sarina',
                   'Sarpanch' => 'Sarpanch',
                   'Satisfy' => 'Satisfy',
                   'Scada' => 'Scada',
                   'Scheherazade' => 'Scheherazade',
                   'Schoolbell' => 'Schoolbell',
                   'Seaweed+Script' => 'Seaweed Script',
                   'Sevillana' => 'Sevillana',
                   'Seymour+One' => 'Seymour One',
                   'Shadows+Into+Light' => 'Shadows Into Light',
                   'Shadows+Into+Light+Two' => 'Shadows Into Light Two',
                   'Shanti' => 'Shanti',
                   'Share' => 'Share',
                   'Share+Tech' => 'Share Tech',
                   'Share+Tech+Mono' => 'Share Tech Mono',
                   'Shojumaru' => 'Shojumaru',
                   'Short+Stack' => 'Short Stack',
                   'Siemreap' => 'Siemreap',
                   'Sigmar+One' => 'Sigmar One',
                   'Signika' => 'Signika',
                   'Signika+Negative' => 'Signika Negative',
                   'Simonetta' => 'Simonetta',
                   'Sintony' => 'Sintony',
                   'Sirin+Stencil' => 'Sirin Stencil',
                   'Six+Caps' => 'Six Caps',
                   'Skranji' => 'Skranji',
                   'Slabo+13px' => 'Slabo 13px',
                   'Slabo+27px' => 'Slabo 27px',
                   'Slackey' => 'Slackey',
                   'Smokum' => 'Smokum',
                   'Smythe' => 'Smythe',
                   'Sniglet' => 'Sniglet',
                   'Snippet' => 'Snippet',
                   'Snowburst+One' => 'Snowburst One',
                   'Sofadi+One' => 'Sofadi One',
                   'Sofia' => 'Sofia',
                   'Sonsie+One' => 'Sonsie One',
                   'Sorts+Mill+Goudy' => 'Sorts Mill Goudy',
                   'Source+Code+Pro' => 'Source Code Pro',
                   'Source+Sans+Pro' => 'Source Sans Pro',
                   'Source+Serif+Pro' => 'Source Serif Pro',
                   'Special+Elite' => 'Special Elite',
                   'Spicy+Rice' => 'Spicy Rice',
                   'Spinnaker' => 'Spinnaker',
                   'Spirax' => 'Spirax',
                   'Squada+One' => 'Squada One',
                   'Sree+Krushnadevaraya' => 'Sree Krushnadevaraya',
                   'Stalemate' => 'Stalemate',
                   'Stalinist+One' => 'Stalinist One',
                   'Stardos+Stencil' => 'Stardos Stencil',
                   'Stint+Ultra+Condensed' => 'Stint Ultra Condensed',
                   'Stint+Ultra+Expanded' => 'Stint Ultra Expanded',
                   'Stoke' => 'Stoke',
                   'Strait' => 'Strait',
                   'Sue+Ellen+Francisco' => 'Sue Ellen Francisco',
                   'Sumana' => 'Sumana',
                   'Sunshiney' => 'Sunshiney',
                   'Supermercado+One' => 'Supermercado One',
                   'Sura' => 'Sura',
                   'Suranna' => 'Suranna',
                   'Suravaram' => 'Suravaram',
                   'Suwannaphum' => 'Suwannaphum',
                   'Swanky+and+Moo+Moo' => 'Swanky and Moo Moo',
                   'Syncopate' => 'Syncopate',
                   'Tangerine' => 'Tangerine',
                   'Taprom' => 'Taprom',
                   'Tauri' => 'Tauri',
                   'Teko' => 'Teko',
                   'Telex' => 'Telex',
                   'Tenali+Ramakrishna' => 'Tenali Ramakrishna',
                   'Tenor+Sans' => 'Tenor Sans',
                   'Text+Me+One' => 'Text Me One',
                   'The+Girl+Next+Door' => 'The Girl Next Door',
                   'Tienne' => 'Tienne',
                   'Tillana' => 'Tillana',
                   'Timmana' => 'Timmana',
                   'Tinos' => 'Tinos',
                   'Titan+One' => 'Titan One',
                   'Titillium+Web' => 'Titillium Web',
                   'Trade+Winds' => 'Trade Winds',
                   'Trocchi' => 'Trocchi',
                   'Trochut' => 'Trochut',
                   'Trykker' => 'Trykker',
                   'Tulpen+One' => 'Tulpen One',
                   'Ubuntu' => 'Ubuntu',
                   'Ubuntu+Condensed' => 'Ubuntu Condensed',
                   'Ubuntu+Mono' => 'Ubuntu Mono',
                   'Ultra' => 'Ultra',
                   'Uncial+Antiqua' => 'Uncial Antiqua',
                   'Underdog' => 'Underdog',
                   'Unica+One' => 'Unica One',
                   'UnifrakturCook' => 'UnifrakturCook',
                   'UnifrakturMaguntia' => 'UnifrakturMaguntia',
                   'Unkempt' => 'Unkempt',
                   'Unlock' => 'Unlock',
                   'Unna' => 'Unna',
                   'VT323' => 'VT323',
                   'Vampiro+One' => 'Vampiro One',
                   'Varela' => 'Varela',
                   'Varela+Round' => 'Varela Round',
                   'Vast+Shadow' => 'Vast Shadow',
                   'Vesper+Libre' => 'Vesper Libre',
                   'Vibur' => 'Vibur',
                   'Vidaloka' => 'Vidaloka',
                   'Viga' => 'Viga',
                   'Voces' => 'Voces',
                   'Volkhov' => 'Volkhov',
                   'Vollkorn' => 'Vollkorn',
                   'Voltaire' => 'Voltaire',
                   'Waiting+for+the+Sunrise' => 'Waiting for the Sunrise',
                   'Wallpoet' => 'Wallpoet',
                   'Walter+Turncoat' => 'Walter Turncoat',
                   'Warnes' => 'Warnes',
                   'Wellfleet' => 'Wellfleet',
                   'Wendy+One' => 'Wendy One',
                   'Wire+One' => 'Wire One',
                   'Work+Sans' => 'Work Sans',
                   'Yanone+Kaffeesatz' => 'Yanone Kaffeesatz',
                   'Yantramanav' => 'Yantramanav',
                   'Yellowtail' => 'Yellowtail',
                   'Yeseva+One' => 'Yeseva One',
                   'Yesteryear' => 'Yesteryear',
                   'Zeyada' => 'Zeyada',
				  ) );

	// Add Body Font Size
	aya_customizer_add_text_control( $wp_customize, 'aya_font_settings',
		'aya_font_textsz', __( 'Text Size (in pixels)', 'aya' ), BODY_FONT_SIZE );

	// Add H1 Font Size
	aya_customizer_add_text_control( $wp_customize, 'aya_font_settings',
		'aya_font_h1_sz', __( 'H1 Size (in pixels)', 'aya' ), BODY_H1_SIZE );

	// Add H2 Font Size
	aya_customizer_add_text_control( $wp_customize, 'aya_font_settings',
		'aya_font_h2_sz', __( 'H2 Size (in pixels)', 'aya' ), BODY_H2_SIZE );

	// Add H3 Font Size
	aya_customizer_add_text_control( $wp_customize, 'aya_font_settings',
		'aya_font_h3_sz', __( 'H3 Size (in pixels)', 'aya' ), BODY_H3_SIZE );

	// Add H4 Font Size
	aya_customizer_add_text_control( $wp_customize, 'aya_font_settings',
		'aya_font_h4_sz', __( 'H4 Size (in pixels)', 'aya' ), BODY_H4_SIZE );

	// Add Menu (Large resoluion) Font Size
	aya_customizer_add_text_control( $wp_customize, 'aya_font_settings',
		'aya_font_menu_large_sz', __( 'Menu Font Size (Large Resolution)', 'aya' ), BODY_MENU_LARGE_SIZE );

	// Add Menu (Small resoluion) Font Size
	aya_customizer_add_text_control( $wp_customize, 'aya_font_settings',
		'aya_font_menu_small_sz', __( 'Menu Font Size (Small Resolution)', 'aya' ), BODY_MENU_SMALL_SIZE );

	// Add Section Title Size
	aya_customizer_add_text_control( $wp_customize, 'aya_font_settings',
		'aya_font_sct_ttl_sz', __( 'Section Title Size (in pixels)', 'aya' ), SECTION_TITLE_SIZE );

	// Add Footer Section Title Size
	aya_customizer_add_text_control( $wp_customize, 'aya_font_settings',
		'aya_font_ftr_sct_ttl_sz', __( 'Footer Section Title Size (in pixels)', 'aya' ), FOOTER_SECTION_TITLE_SIZE );
}

//a Register theme settings in the customizer
function aya_customize_register( $wp_customize ) {

	aya_customize_register_general_settings( $wp_customize );

	aya_customize_register_site_identity_settings( $wp_customize );

	aya_customize_register_font_settings( $wp_customize );

	aya_customize_register_header_and_footer_settings( $wp_customize );

	aya_customize_register_homepage_settings( $wp_customize );

	aya_customize_register_slider_settings( $wp_customize );

	aya_customize_register_colors_settings( $wp_customize );

	aya_customize_register_social_settings( $wp_customize );

	aya_customize_register_thumbnails_settings( $wp_customize );

	aya_customize_register_notfound_settings( $wp_customize );

	aya_customize_register_woocommerce_settings( $wp_customize );
}

add_action('customize_register', 'aya_customize_register');

?>
