<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "body-content-wrapper" div.
 *
 * @package WordPress
 * @subpackage tBlogging
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?><?php if ( is_single() && has_post_thumbnail() ) : ?> xmlns="http://www.w3.org/1999/xhtml" xmlns:fb="http://ogp.me/ns/fb#"<?php endif; ?>>
	<head>
		<meta charset="<?php bloginfo('charset'); ?>" />
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
		<meta name="viewport" content="width=device-width" />
		<?php aya_head_load_scripts();
			  wp_head(); ?>

		<?php if ( is_single() && has_post_thumbnail() ) : ?>
			<meta property="og:image" content="<?php the_post_thumbnail_url(); ?>" />
		<?php endif; ?>


    </head>
	<body <?php body_class(); ?>>
		<div id="body-content-wrapper">
			<header id="header-main-fixed">
				<div id="header-content-wrapper">
					<?php aya_show_header_top(); ?>
					<div>
						<?php aya_shopping_cart(); ?>
					</div>
					<div class="clear">
					</div>
					<div id="header-logo">
						<?php aya_show_website_logo_image_and_title(); ?>
					</div><!-- #header-logo -->
					<nav id="navmain">
						<?php wp_nav_menu( array( 'theme_location' => 'primary', ) ); ?>
						<div class="clear">
						</div>
					</nav><!-- #navmain -->
					
					<div class="clear">
					</div>
				</div><!-- #header-content-wrapper -->
			</header><!-- #header-main-fixed -->

			<?php if ( aya_should_display_slider() ) :

					aya_display_slider();

				  endif; ?>

			<div class="clear">
			</div>