<?php
/*
 * aya functions and definitions
 *
 * Set up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 */

function aya_read_customizer_option($name, $default) {

	return get_theme_mod($name, $default);
}
 
function aya_show_social_sites( $before,
						  $after,
						  $separatorBefore,
						  $separatorAfter,
						  $openInNewWindow,
						  $iconSize /* must be 16 or 32 */) {

		echo $before;

	$socialSite = aya_read_customizer_option('aya_social_facebook', 'https://www.facebook.com/ayatemplates');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on Facebook', 'aya' ), 'facebook'.$iconSize, $openInNewWindow );
	}

	$socialSite = aya_read_customizer_option('aya_social_googleplus', 'https://plus.google.com/');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on Google+', 'aya' ), 'google'.$iconSize, $openInNewWindow );
	}

	$socialSite = aya_read_customizer_option('aya_social_twitter', 'https://twitter.com/ayatemplates');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on Twitter', 'aya' ), 'twitter'.$iconSize, $openInNewWindow );
	}
	
	$socialSite = aya_read_customizer_option('aya_social_linkedin', 'http://www.linkedin.com/');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on LinkedIn', 'aya' ), 'linkedin'.$iconSize, $openInNewWindow );
	}

	$socialSite = aya_read_customizer_option('aya_social_instagram', 'https://instagram.com/');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on Instagram', 'aya' ), 'instagram'.$iconSize, $openInNewWindow );
	}

	$socialSite = aya_read_customizer_option('aya_social_rss', get_bloginfo( 'rss2_url' ));
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on RSS Feeds', 'aya' ), 'rss'.$iconSize, $openInNewWindow );
	}
	
	$socialSite = aya_read_customizer_option('aya_social_tumblr', 'https://www.tumblr.com/');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on Tumblr', 'aya' ), 'tumblr'.$iconSize, $openInNewWindow );
	}
	
	$socialSite = aya_read_customizer_option('aya_social_youtube', 'http://www.youtube.com/');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on YouTube', 'aya' ), 'youtube'.$iconSize, $openInNewWindow );
	}
	
	$socialSite = aya_read_customizer_option('aya_social_pinterest', 'http://www.pinterest.com/');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on Pinterest', 'aya' ), 'pinterest'.$iconSize, $openInNewWindow );
	}

	$socialSite = aya_read_customizer_option('aya_social_vk', 'http://vk.com/');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on VK', 'aya' ), 'vk'.$iconSize, $openInNewWindow );
	}

	$socialSite = aya_read_customizer_option('aya_social_flickr', 'http://flickr.com/');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on Flickr', 'aya' ), 'flickr'.$iconSize, $openInNewWindow );
	}

	$socialSite = aya_read_customizer_option('aya_social_vine', 'https://vine.co/');
	if ( !empty( $socialSite ) ) {
		aya_show_single_social_site( $separatorBefore, $separatorAfter, $socialSite,
				__( 'Follow us on Vine', 'aya' ), 'vine'.$iconSize, $openInNewWindow );
	}

	echo $after;	
}

function aya_show_single_social_site( $separatorBefore,
											 $separatorAfter,
											 $socialSiteUrl,
											 $title,
											 $cssClass,
											 $openInNewWindow ) {

	echo $separatorBefore;
	
	if ( $openInNewWindow ) {
		echo "<a href='$socialSiteUrl' title=\"$title\" class='$cssClass' target=\"_blank\"></a>";
	}
	else {
		echo "<a href='$socialSiteUrl' title=\"$title\" class='$cssClass'></a>";
	}

	echo $separatorAfter;
}

/**
 * Display website's logo image
 */
function aya_show_website_logo_image_and_title() {

	if ( has_custom_logo() ) {

        the_custom_logo();
    }

    $header_text_color = get_header_textcolor();

    if ( 'blank' !== $header_text_color ) {
    
        echo '<div id="site-identity">';
        echo '<a href="' . esc_url( home_url('/') ) . '" title="' . esc_attr( get_bloginfo('name') ) . '">';
        echo '<h1>'.get_bloginfo('name').'</h1>';
        echo '</a>';
        echo '<strong>'.get_bloginfo('description').'</strong>';
        echo '</div>';
    }
}

/* 
 * Display content at header top: social icons, shopping card, etc.
 */
function aya_show_header_top() {

	$displaySocial = (aya_read_customizer_option('aya_header_displaysocial', 1) == 1);

	// check if no content is set to display, then we should skip displaying
	if ( !$displaySocial ) {
		return;
	}
?>
	<div id="header-top">
		<?php
			// display social sites
			if ( $displaySocial ) {
				aya_show_social_sites( '<ul class="header-social-widget">', '</ul>', '<li>', '</li>', 
							aya_read_customizer_option('aya_header_opensocialnewwindow', 1) == 1, 16 );
			}
		?>
	</div>
	<div class="clear"></div>
<?php
}

/**
 * Check if the Footer Menu should be displayed.
 */
function aya_should_display_footer_menu() {

	return ( aya_read_customizer_option('aya_footer_displayfootermenu', 1) == 1 );
}

/**
 * Displays social sites code for footer
 */
function aya_show_footer_social_sites($before, $after) {

	if ( aya_read_customizer_option('aya_footer_displaysocial', 1) == 1 ) {
		 
		echo $before;

		aya_show_social_sites( '<ul class="footer-social-widget">', '</ul>', '<li>', '</li>',
				aya_read_customizer_option('aya_footer_opensocialnewwindow', 1) == 1, 16 );

		echo $after;
	}
}

/**
 * Displays social sites icons with size 16 x 16
 */
function aya_show_social_sites16( $openinnewwindow ) {

	aya_show_social_sites( '<ul class="social-widget">', '</ul>', '<li>', '</li>', $openinnewwindow, 16 );
}

/**
 * Displays social sites icons with size 32 x 32
 */
function aya_show_social_sites32( $openinnewwindow ) {

	aya_show_social_sites( '<ul class="social-widget">', '</ul>', '<li>', '</li>', $openinnewwindow, 32 );
}

/**
 * Displays single follow us social site (i.e. 'Follow Us on Facebook')
 */
function aya_show_follow_single_social_site( $socialPageUrl, $title, $iconClass, $openinnewwindow ) {

	echo '<div class="single-social-widget">';

	echo '<p class="social32">';

	echo '<a href="'.$socialPageUrl.'" title="'.$title.'" class="'.$iconClass.'"';
	
	if ( $openinnewwindow ) {
		echo ' target="_blank"';
	}
	echo '></a>';
	
	echo '</p>';
	
	if ( !empty( $title ) ) {
		echo '<p><a href="'.$socialPageUrl.'" title="'.$title.'"';
		
		if ( $openinnewwindow ) {
			echo ' target="_blank"';
		}
		echo '>'.$title.'</a></p>';
	}
	
	echo '</div>';
}

/**
 *	Displays the copyright text.
 */
function aya_show_copyright_text() {

	$copyrightText = aya_read_customizer_option('aya_footer_copyrighttext', 'Copyright &copy; 2017. All Rights Reserved. | Powered by <a title="ayatemplates.com" href="https://ayatemplates.com/" target="_blank">ayatemplates.com</a>');
	if ( !empty($copyrightText) ) {

		echo '<p>'.$copyrightText.'</p>';
	}
}

/**
 * Checks if slider should be displayed in the website's homepage
 */
function aya_should_display_slider() {

	return ( aya_read_customizer_option('aya_slider_displayinallpages', 0) == 1
			 || (is_front_page() && aya_read_customizer_option('aya_slider_displayinhomepage', 1) == 1) );
}

/**
 * Displays the slider
 */
function aya_display_slider() { ?>
	
	<section class="main">
		<div class="ia-container">

		<?php
			$numberOfSlides = 0;

			// display slides
			for ( $i = 1; $i <= 10; ++$i ) {
				if ( aya_read_customizer_option('aya_slider_displayslide'.$i, ($i <= 8) ? 1 : 0) == 1 ) {

					++$numberOfSlides;

					$defaultTitle = '';
					$defaultText = '';

					if ($i == 1) {
						$defaultTitle = 'Lorem ipsum dolor';
						$defaultText = '<p>Lorem ipsum dolor sit amet, consectetur adipisicing.</p>';
					} else if ($i == 2) {
						$defaultTitle = 'Everti Constituam';
						$defaultText = '<p>Vel nobis libris nostrud an. Per ex veniam.</p>';
					} else if ($i == 3) {
						$defaultTitle = 'Id Essent Cetero';
						$defaultText = '<p>Quodsi docendi sed id. Ea eam quod aliquam epicurei.</p>';
					} else if ($i == 4) {
						$defaultTitle = 'Nostrud Cotidieque Et';
						$defaultText = '<p>Vel nobis libris nostrud an. Id prompta postulant.</p>';
					} else if ($i == 5) {
						$defaultTitle = 'Lorem ipsum dolor sit amet';
						$defaultText = '<p>Lorem ipsum dolor sit amet, consectetur adipisicing.</p>';
					} else if ($i == 6) {
						$defaultTitle = 'Lorem ipsum dolor';
						$defaultText = '<p>Lorem ipsum dolor sit amet, consectetur adipisicing.</p>';
					} else if ($i == 7) {
						$defaultTitle = 'Everti Constituam';
						$defaultText = '<p>Vel nobis libris nostrud an. Id prompta postulant.</p>';
					} else if ($i == 8) {
						$defaultTitle = 'Id Essent Cetero';
						$defaultText = '<p>Quodsi docendi sed id. Ea eam quod aliquam.</p>';
					}

					$slideTitle = aya_read_customizer_option('aya_slider_slide'.$i.'_title', $defaultTitle);
					$slideText = aya_read_customizer_option('aya_slider_slide'.$i.'_text', $defaultText);
					$slideUrl = aya_read_customizer_option('aya_slider_slide'.$i.'_url', ($i <= 8) ? '#' : '' );
					$slideImage = aya_read_customizer_option('aya_slider_slide'.$i.'_image', ($i <= 8) ? get_stylesheet_directory_uri().'/images/slider/slides/'.$i.'.jpg' : '' );
					$slideLinkText = aya_read_customizer_option('aya_slider_slide'.$i.'_urltext', __( 'Read more', 'aya' ) );
					$slideLinkOpenInNewWindow = aya_read_customizer_option('aya_slider_slide'.$i.'_opennewwindow', 0) == 1;
				?>

					<figure>
						<img src="<?php echo $slideImage; ?>" alt="<?php echo $slideTitle; ?>" />
						<input type="radio" name="radio-set" <?php if ($numberOfSlides == 1) : echo 'checked="checked"'; endif; ?> />
						<figcaption>
							<div class="slide">
								<?php if ($slideTitle != '') : ?>

											<h2><?php echo $slideTitle; ?></h2>

									<?php endif; ?>

									<?php echo $slideText; ?>

									<?php if ($slideUrl != '' && $slideLinkText != '') : ?>
											
											<a href="<?php echo $slideUrl; ?>" <?php if ($slideLinkOpenInNewWindow) { echo ' target="_blank" '; } ?>  title="<?php echo $slideLinkText; ?>"><?php echo $slideLinkText; ?></a>

								<?php endif; ?>
							</div>
						</figcaption>
				<?php	
				}
			} ?>

			<?php for ($i = 0; $i < $numberOfSlides; ++$i) {

						echo '</figure>';
			} ?>
	 </div><!-- ia-container -->
	</section>
<?php 
}

/**
 * Returns the number of footer columns set in Admin -> Appearance -> Theme Options -> Footer
 */
function aya_getNumberOfFooterColumns() {

	return (int)aya_read_customizer_option('aya_footer_columnsnumber', 4);
}

/**
 * Returns the number of homepage columns set in Admin -> Appearance -> Theme Options -> Home
 */
function aya_getNumberOfHomePageColumns() {

	return (int)aya_read_customizer_option('aya_homepage_columnsnumber', 4);
}

/**
 * Returns true if show author box is set to be shown after single posts
 */
function aya_show_author_info_after_single_post_enabled() {

	return (aya_read_customizer_option('aya_general_showauthorinfo_aftersinglepost', 1) == 1);
}

/**
 * Returns true if social sharing box is set to be shown after single posts
 */
function aya_show_social_sharing_after_single_post_enabled() {

	return (aya_read_customizer_option('aya_general_showsocialsharing_aftersinglepost', 1) == 1);
}

/**
 * Returns true if show author box is set to be shown after single pages
 */
function aya_show_author_info_after_single_page_enabled() {

	return (aya_read_customizer_option('aya_general_showauthorinfo_aftersinglepage', 0) == 1);
}

/**
 * Returns true if social sharing box is set to be shown after single pages
 */
function aya_show_social_sharing_after_single_page_enabled() {

	return (aya_read_customizer_option('aya_general_showsocialsharing_aftersinglepage', 0) == 1);
}

/**
 * Returns true if WooCommerce plugin is activate.
 */
function aya_is_woocommerce_activate() {

	return is_plugin_active( 'woocommerce/woocommerce.php' );
}

function aya_shopping_cart() {

	// display shopping cart
	if ( aya_is_woocommerce_activate() ) {
	
			global $woocommerce;  ?>
			
			<a class="cart-contents" href="<?php echo $woocommerce->cart->get_cart_url(); ?>" 
				title="<?php _e('View your shopping cart', 'aya'); ?>">
					<?php echo sprintf(_n('%d item', '%d items', $woocommerce->cart->cart_contents_count, 'aya'), $woocommerce->cart->cart_contents_count);?> - <?php echo $woocommerce->cart->get_cart_total(); ?>
			</a>
			
			<div id="cart-popup-content">
			
				<div class="widget_shopping_cart_content"></div>
			
			</div>

<?php
	}
}

/**
 * Returns true if boxed layout is selected
 */
function aya_is_boxed_layout_selected() {
 
	return (aya_read_customizer_option('aya_general_layout', 'wide') == 'boxed');
}

/**
 *	Returns true if 'Display Sidebar' is set in Appearance -> Theme Options -> Home
 */
 function aya_display_sidebar_in_homepage() {
	
	return (aya_read_customizer_option('aya_homepage_displaysidebar', 1) == 1);
	
 }
 
/**
 *	Returns true if 'Display Latest Posts' is set in Appearance -> Theme Options -> Home
 */
function aya_display_latest_posts_in_homepage() {
	
	return (aya_read_customizer_option('aya_homepage_displaylatestposts', 1) == 1);
	
}

/**
 * Converts a Hex color to RGB Array with rgb values
 */
function aya_hex2rgb($hex) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);

   return $rgb;
}

/**
 * Returns true if woocommerce sidebar is set to be displayed in WooCommerce pages
 */
function aya_display_woocommerce_sidebar_enabled() {

	return (aya_read_customizer_option('aya_woocommerce_displaysidebar', 1) == 1);
}

/**
 * Display author link for posts and pages
 */
function aya_author_link() {

	$postType = get_post_type();

	if ( ($postType == 'post' && aya_read_customizer_option('aya_general_showauthor_forposts', 1) == 1)
	     || ($postType == 'page' && aya_read_customizer_option('aya_general_showauthor_forpages', 0) == 1) ) {
?>
			<span class="author-icon">
			<?php the_author_posts_link(); ?>
		</span>
<?php
	}
}

/*
 * Note: This function is called directly in header.php.
 * Reason: We need these scripts to be loaded in the head tag.
 * If wp_enqueue_script is called in wp_action, the scripts are loaded in footer.
 */
function aya_head_load_scripts() {
	
	// Load thread comments reply script
	if ( is_singular() ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

require_once( 'inc/customizer.php' );
require_once( 'inc/widgets.php' );

require_once( ABSPATH . 'wp-admin/includes/plugin.php' );

load_theme_textdomain( 'aya', get_template_directory() . '/languages' );

add_theme_support( 'menus' );



// Add wp_enqueue_scripts actions
function aya_load_scripts() {

	wp_enqueue_script('jquery');

	// load main stylesheet.
	wp_enqueue_style( 'aya-style', get_stylesheet_uri(), array( ) );
	
	aya_load_inline_styles();
}
add_action( 'wp_enqueue_scripts', 'aya_load_scripts' );

// Add wp_head actions
function aya_head_load_code_in_head_tag() {

	$headerCode = aya_read_customizer_option('aya_general_headercode', null);

	if ( !empty( $headerCode ) ) {

		echo $headerCode."\n";	
	}
}
add_action( 'wp_head', 'aya_head_load_code_in_head_tag' );

// Add wp_footer actions
/*
 * wp_footer action functions
 */
function aya_footer_load_footer_scripts() {

	// Load jQuery UI Script
	wp_enqueue_script( 'aya-jquery-ui-js', get_template_directory_uri() . '/js/jquery-ui-1.10.4.custom.min.js', array( 'jquery' ) );
	
	// Load Utilities JS Script
	wp_enqueue_script( 'aya-utilities-js', get_template_directory_uri() . '/js/utilities.js', array( 'jquery', 'aya-jquery-ui-js' ) );
	
	// Load jCarousel JS Script
	wp_enqueue_script( 'aya-jcarousel', get_template_directory_uri() . '/js/jquery.jcarousel.min.js', array( 'jquery' ) );
}
add_action( 'wp_footer', 'aya_footer_load_footer_scripts' );

function aya_footer_load_tracking_code() {

	$trackingCode = aya_read_customizer_option('aya_general_trackingcode', null);
	if ( !empty( $trackingCode ) ) {

		echo $trackingCode."\n";	
	}
}
add_action( 'wp_footer', 'aya_footer_load_tracking_code' );

function aya_footer_load_code_in_body_tag() {

	$bodyCode = aya_read_customizer_option('aya_general_bodycode', null);
	if ( !empty( $bodyCode ) ) {

		echo $bodyCode."\n";	
	}
}
add_action( 'wp_footer', 'aya_footer_load_code_in_body_tag' );

/**
 *	widgets-init action handler. Used to register widgets and register widget areas
 */
function aya_widgets_init() {

	// I. Register Widgets

	// Register Social Sites Widgets
	register_widget( 'aya_SocialSites_Widget' );
	register_widget( 'aya_FollowUsOnFacebook_Widget' );
	register_widget( 'aya_FollowUsOnTwitter_Widget' );
	register_widget( 'aya_FollowOurRssFeeds_Widget' );

	// Register Custom Post Formats Widgets
	register_widget( 'aya_Recent_Posts_Slider_Widget' );
	
	// Register Text Widgets
	register_widget( 'aya_AdvancedTextContent_Widget' );
	register_widget( 'aya_AdvancedTextContentTwoColumns_Widget' );
	register_widget( 'aya_AdvancedTextContentThreeColumns_Widget' );
	register_widget( 'aya_AdvancedTextContentFourColumns_Widget' );
	register_widget( 'aya_Skills_Widget' );
	
	// Register Contacts Widgets
	register_widget( 'aya_OfficesContacts_Widget' );
	register_widget( 'aya_GoogleMap_Widget' );
	
	// Register Tab Widget
	register_widget( 'aya_tabs_widget' );
	
	// Register Recent Tweets Widget
	register_widget( 'aya_FacebookLikeBoxWidget' );
	
	register_widget( 'aya_DisplayVimeoVideo_Widget' );
	
	// Register Instagram Widget
	register_widget( 'aya_Instagram_Widget' );

	register_widget( 'aya_Display_Clients_Widget' );
	register_widget( 'aya_Display_Projects_Widget' );
	register_widget( 'aya_Display_Testimonials_Widget' );
	
	// II. Register Widget Areas

	// Sidebar Widget.
	register_sidebar( array (
						'name'	 		 =>	 __( 'Sidebar Widget Area', 'aya' ),
						'id'		 	 =>	 'sidebar-widget-area',
						'description'	 =>  __( 'The sidebar widget area', 'aya' ),
						'before_widget'	 =>  '',
						'after_widget'	 =>  '',
						'before_title'	 =>  '<div class="sidebar-before-title"></div><h3 class="sidebar-title">',
						'after_title'	 =>  '</h3><div class="sidebar-after-title"></div>',
					) );
					
	// Add Homepage Top Widget
	register_sidebar( array (
						'name'			 =>  __( 'Homepage Above Columns', 'aya' ),
						'id'			 =>  'homepage-top-widget-area',
						'description' 	 =>  __( 'A widget area above homepage columns', 'aya' ),
						'before_widget'	 =>  '<div>',
						'after_widget'	 =>  '</div>',
						'before_title'	 =>  '<h2 class="home-title">',
						'after_title'	 =>  '</h2><div class="home-after-title"></div>',
					) );
	
	
	$numberOfHomePageColumns = aya_getNumberOfHomePageColumns();
	for ($i = 1; $i <= $numberOfHomePageColumns; ++$i) {

		// Add Homepage Column #i Widget
		register_sidebar( array (
							'name'			 =>  sprintf( __( 'Homepage Column #%s', 'aya' ), $i ),
							'id' 			 =>  'homepage-column-'.$i.'-widget-area',
							'description'	 =>  sprintf( __( 'The Homepage Column #%s widget area', 'aya' ), $i ),
							'before_widget'  =>  '',
							'after_widget'	 =>  '',
							'before_title'	 =>  '<h2 class="home-col-title">',
							'after_title'	 =>  '</h2><div class="home-col-after-title"></div>',
						) );					
	}
					
	// Add Homepage Bottom Widget
	register_sidebar( array (
						'name'			 =>  __( 'Homepage Below Columns', 'aya' ),
						'id'			 =>  'homepage-bottom-widget-area',
						'description' 	 =>  __( 'A widget area below homepage columns', 'aya' ),
						'before_widget'	 =>  '<div class="bottom-widget">',
						'after_widget'	 =>  '</div>',
						'before_title'	 =>  '<h2 class="home-title">',
						'after_title'	 =>  '</h2><div class="home-after-title"></div>',
					) );

	$numberOfFooterColumns = aya_getNumberOfFooterColumns();
	for ($i = 1; $i <= $numberOfFooterColumns; ++$i) {

		// Add Footer Column #i Widget
		register_sidebar( array (
							'name'			 =>  sprintf( __( 'Footer Column #%s', 'aya' ), $i ),
							'id' 			 =>  'footer-column-'.$i.'-widget-area',
							'description'	 =>  sprintf( __( 'The footer column #%s Widget area', 'aya' ), $i ),
							'before_widget'  =>  '',
							'after_widget'	 =>  '',
							'before_title'	 =>  '<h3 class="footer-title">',
							'after_title'	 =>  '</h3><div class="footer-after-title"></div>',
						) );					
	}
	
	// Add Footer Bottom Widget
	register_sidebar( array (
						'name'			 =>  __( 'Footer Bottom', 'aya' ),
						'id'			 =>  'footer-bottom-widget-area',
						'description' 	 =>  __( 'The footer bottom widget area', 'aya' ),
						'before_widget'  =>  '<div class="clear">',
						'after_widget' 	 =>  '</div>',
						'before_title'	 =>  '<h3 class="footer-title">',
						'after_title'	 =>  '</h3><div class="footer-after-title"></div>',
					) );
					
	register_sidebar( array (
						'name'	 		 =>	 __( 'Before Single Post Content', 'aya' ),
						'id'		 	 =>	 'before-single-post-content-widget-area',
						'description'	 =>  __( 'Widget area before single post content', 'aya' ),
						'before_widget'	 =>  '',
						'after_widget'	 =>  '',
						'before_title'	 =>  '<h3>',
						'after_title'	 =>  '</h3>',
					) );
					
	register_sidebar( array (
						'name'	 		 =>	 __( 'After Single Post Content', 'aya' ),
						'id'		 	 =>	 'after-single-post-content-widget-area',
						'description'	 =>  __( 'Widget area after single post content', 'aya' ),
						'before_widget'	 =>  '',
						'after_widget'	 =>  '',
						'before_title'	 =>  '<h3>',
						'after_title'	 =>  '</h3>',
					) );
					
	register_sidebar( array (
						'name'	 		 =>	 __( 'Before Single Page Content', 'aya' ),
						'id'		 	 =>	 'before-single-page-content-widget-area',
						'description'	 =>  __( 'Widget area before single Page content (Page Template: Page with Widget Areas)', 'aya' ),
						'before_widget'	 =>  '',
						'after_widget'	 =>  '',
						'before_title'	 =>  '<h3>',
						'after_title'	 =>  '</h3>',
					) );
					
	register_sidebar( array (
						'name'	 		 =>	 __( 'After Single Page Content', 'aya' ),
						'id'		 	 =>	 'after-single-page-content-widget-area',
						'description'	 =>  __( 'Widget area after single Page content (Page Template: Page with Widget Areas)', 'aya' ),
						'before_widget'	 =>  '',
						'after_widget'	 =>  '',
						'before_title'	 =>  '<h3>',
						'after_title'	 =>  '</h3>',
					) );
					
	// Sidebar Widget.
	register_sidebar( array (
						'name'	 		 =>	 __( 'Shop', 'aya' ),
						'id'		 	 =>	 'shop-widget-area',
						'description'	 =>  __( 'The shop widget area (woocommerce pages)', 'aya' ),
						'before_widget'	 =>  '',
						'after_widget'	 =>  '',
						'before_title'	 =>  '<div class="sidebar-before-title"></div><h3 class="sidebar-title">',
						'after_title'	 =>  '</h3><div class="sidebar-after-title"></div>',
					) );
					
	// Add Contacts Top Widget
	register_sidebar( array (
						'name'		    =>  __( 'Contacts Top', 'aya' ),
						'id' 			=>  'contacts-top-widget-area',
						'description'   =>  __( 'Widget area in the top (Page Template: Contact Page)', 'aya' ),
						'before_widget' =>  '',
						'after_widget'  =>  '',
						'before_title'  =>  '<h2>',
						'after_title'   =>  '</h2>',
					) );
					
	// Add Contacts Sidebar Widget.
	register_sidebar( array (
						'name'	 		 =>	 __( 'Contacts Sidebar', 'aya' ),
						'id'		 	 =>	 'contacts-sidebar-widget-area',
						'description'	 =>  __( 'Widget area in the sidebar (Page Template: Contact Page)', 'aya' ),
						'before_widget'	 =>  '',
						'after_widget'	 =>  '',
						'before_title'	 =>  '<div class="sidebar-before-title"></div><h3 class="sidebar-title">',
						'after_title'	 =>  '</h3><div class="sidebar-after-title"></div>',
					) );
}
add_action( 'widgets_init', 'aya_widgets_init' );

add_theme_support( 'post-thumbnails' );
set_post_thumbnail_size( 150, 150, true );

add_theme_support( 'automatic-feed-links' );

register_nav_menus( array(
        'primary'   => __( 'Primary Menu', 'aya' ),
        'footer'   => __( 'Footer Menu', 'aya' ),
    ) );

// add Custom background
$args = array(
	'default-color' 	 => '#555555',
	'default-attachment' => 'fixed',
);
add_theme_support( 'custom-background', $args );
				 
// add custom header
add_theme_support( 'custom-header', array (
                   'default-image'          => '',
                   'random-default'         => '',
                   'flex-height'            => true,
                   'flex-width'             => true,
                   'uploads'                => true,
                   'width'                  => 900,
                   'height'                 => 100,
                   'default-text-color'     => '#555555',
                   'wp-head-callback'       => 'landshaftingpro_header_style',
                ) );

// add custom logo
add_theme_support( 'custom-logo', array (
                   'width'                  => 145,
                   'height'                 => 36,
                   'flex-height'            => true,
                   'flex-width'             => true,
                ) );
				
/*
 * Let WordPress manage the document title.
 * By adding theme support, we declare that this theme does not use a
 * hard-coded <title> tag in the document head, and expect WordPress to
 * provide it for us.
 */
add_theme_support( 'title-tag' );

/*
 * Switch default core markup for search form, comment form, and comments
 * to output valid HTML5.
 */
add_theme_support( 'html5', array(
	'search-form', 'comment-form', 'comment-list',
) );

// add support for Post Formats.
add_theme_support( 'post-formats', array (
										'aside',
										'image',
										'video',
										'audio',
										'quote', 
										'link',
										'gallery',
				) );
				
global $content_width;
	if ( ! isset( $content_width ) ) {
	$content_width = 900;
}

// add WooCommerce support
add_theme_support( 'woocommerce' );

// add the visual editor to resemble the theme style
add_editor_style( array( 'css/editor-style.css', get_template_directory_uri() . '/css/font-awesome.min.css' ) );

/**
 * Add author additional info (i.e. social links)
 */
function aya_add_to_author_profile( $contactmethods ) {
	
	$contactmethods['rss_url'] = 'RSS URL';
	$contactmethods['facebook_profile'] = 'Facebook Profile URL';
	$contactmethods['linkedin_profile'] = 'Linkedin Profile URL';
	$contactmethods['google_profile'] = 'Google Profile URL';
	$contactmethods['twitter_profile'] = 'Twitter Profile URL';

	return $contactmethods;
}
add_filter( 'user_contactmethods', 'aya_add_to_author_profile', 10, 1);

/**
 * change default comment fields, add placeholder and change type attributes.
 */
function aya_comment_placeholders( $fields )
{
    $commenter = wp_get_current_commenter();
    $req = get_option( 'require_name_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );
 
    $fields['author'] =
        '<p class="comment-form-author">
            <input required maxlength="30" placeholder="'.__( 'Name', 'aya' ).'" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
    '" size="30"' . $aria_req . ' />
        </p>';
 
    $fields['email'] =
        '<p class="comment-form-email">
            <input required placeholder="'.__( 'Email', 'aya' ).'" id="email" name="email" type="email" value="' . esc_attr(  $commenter['comment_author_email'] ) .
    '" size="30"' . $aria_req . ' />
        </p>';
 
    $fields['url'] =
        '<p class="comment-form-url">
            <input placeholder="'.__( 'Website', 'aya' ).'" id="url" name="url" type="url" value="' . esc_attr( $commenter['comment_author_url'] ) .
    '" size="30" />
        </p>';

    return $fields;
}
add_filter( 'comment_form_default_fields', 'aya_comment_placeholders' );

function aya_update_comment_field($comment_field) {
 
    $comment_field =
        '<p class="comment-form-comment">
            <textarea required placeholder="'.__( 'Comment', 'aya' ).'" id="comment" name="comment" aria-required="true"></textarea>
        </p>';
 
    return $comment_field;
}
add_filter( 'comment_form_field_comment', 'aya_update_comment_field');

/**
 *	Returns the number of products to show per page
 */
function aya_woocommerce_products_per_page() {

	return aya_read_customizer_option('aya_woocommerce_productsperpage', 10);
}
add_filter( 'loop_shop_per_page', 'aya_woocommerce_products_per_page', 20 );

/**
 *	Ensure cart contents update when products are added to the cart via AJAX
 */
function aya_woocommerce_header_add_to_cart_fragment() {

	global $woocommerce;
	ob_start();
?>
	
	<a class="cart-contents-icon" href="<?php echo $woocommerce->cart->get_cart_url(); ?>" title="<?php _e('View your shopping cart', 'aya'); ?>"></a>
	
<?php
	$fragments['a.cart-contents-icon'] = ob_get_clean();

	ob_start();

    woocommerce_mini_cart();
?>	
	<script type="text/javascript">
		jQuery(document).ready(function(){
		
			initMiniCartEvents();
		});
	</script>
	
<?php	
	$fragments['div.widget_shopping_cart_content'] = ob_get_clean();
	
	return $fragments;
}
add_filter('add_to_cart_fragments', 'aya_woocommerce_header_add_to_cart_fragment'); 


function aya_post_classes( $classes ) {
	if ( ! post_password_required() && ! is_attachment() && has_post_thumbnail() ) {
		$classes[] = 'has-post-thumbnail';
	}

	return $classes;
}
add_filter( 'post_class', 'aya_post_classes' );

/**
 *	Generates valid css3 graident
 */
function aya_generate_css3_gradient($className, $gradientTopColor, $gradientBottomColor) {

	$result = " $className{";
			
	$result .= ' background-image: -ms-linear-gradient(top, '.$gradientTopColor.' 0%, '.$gradientBottomColor.' 100%);';
	$result .= ' background-image: -moz-linear-gradient(top, '.$gradientTopColor.' 0%, '.$gradientBottomColor.' 100%);';
	$result .= ' background-image: -o-linear-gradient(top, '.$gradientTopColor.' 0%, '.$gradientBottomColor.' 100%);';
	$result .= ' background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, '.$gradientTopColor.'), color-stop(1, '.$gradientBottomColor.'));';
	$result .= ' background-image: -webkit-linear-gradient(top, '.$gradientTopColor.' 0%, '.$gradientBottomColor.' 100%);';
	$result .= ' background-image: linear-gradient(top, '.$gradientTopColor.' 0%, '.$gradientBottomColor.' 100%);';
	$result .= " filter: progid:DXImageTransform.Microsoft.gradient(GradientType=0,startColorstr='".$gradientTopColor."', endColorstr='".$gradientBottomColor."' );";
			
	$result .= ' }';

	return $result;
}

/**
 * Load inline styles set from Admin Panel -> Appearance -> Theme Options -> Colors
 */
function aya_load_inline_styles() {

	$custom_css = '';

	
	$isBoxedLayoutSelected = aya_is_boxed_layout_selected();

	$colorVal = aya_read_customizer_option('aya_font_name', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' @import url(//fonts.googleapis.com/css?family=' . $colorVal . ');';

		$custom_css .= ' body{font-family:"'. $colorVal . '",Arial,Helvetica,sans-serif;}';
	}

	$colorVal = aya_read_customizer_option('aya_font_textsz', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' body{font-size:'.$colorVal.'px;}';
	}

	$colorVal = aya_read_customizer_option('aya_font_h1_sz', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' h1{font-size:'.$colorVal.'px;}';
	}

	$colorVal = aya_read_customizer_option('aya_font_h2_sz', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' h2{font-size:'.$colorVal.'px;}';
	}

	$colorVal = aya_read_customizer_option('aya_font_h3_sz', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' h3{font-size:'.$colorVal.'px;}';
	}

	$colorVal = aya_read_customizer_option('aya_font_h4_sz', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' h4{font-size:'.$colorVal.'px;}';
	}

	$colorVal = aya_read_customizer_option('aya_font_menu_large_sz', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' @media screen and (min-width: 800px){#navmain ul a {font-size:'.$colorVal.'px;}}';
	}

	
	$colorVal = aya_read_customizer_option('aya_font_menu_small_sz', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' @media screen and (max-width: 799px) {#navmain ul a {font-size:'.$colorVal.'px;}}';
	}

	$colorVal = aya_read_customizer_option('aya_font_sct_ttl_sz', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' .home-title,.sidebar-title{font-size:'.$colorVal.'px;}';
	}

	$colorVal = aya_read_customizer_option('aya_font_ftr_sct_ttl_sz', null);
	if ( !empty( $colorVal ) ) {

		$custom_css .= ' .footer-title{font-size:'.$colorVal.'px;}';
	}
	
	
	$colorVal = aya_read_customizer_option('aya_colors_contentbackgroundcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #body-content-wrapper{background-color:'.$colorVal.';}';
	}
		
	$colorVal = aya_read_customizer_option('aya_colors_textcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' body{color:'.$colorVal.';}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_linkcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' a{color:'.$colorVal.';}';
		
		$custom_css .= ' .product_list_widget a{color:'.$colorVal.' !important;}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_linkhovercolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' a:hover{color:'.$colorVal.';}';
		
		$custom_css .= ' .product_list_widget a:hover{color:'.$colorVal.' !important;}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_headingscolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' h1,h2,h3,h4,h5,h6{color:'.$colorVal.';}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_headerbackground', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #header-main-fixed{background-color:'.$colorVal.'; }';
	}

	$colorVal = aya_read_customizer_option('aya_colors_header_textcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #header-main-fixed{color:'.$colorVal.'; }';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_header_linkcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #header-main-fixed a, #header-main-fixed a h1{color:'.$colorVal.'; }';
	}

	$colorVal = aya_read_customizer_option('aya_colors_header_linkhovercolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #header-main-fixed a:hover {color:'.$colorVal.'; }';
	}

	$colorVal1 = aya_read_customizer_option('aya_colors_buttonbackgroundgradienttop', null);
	$colorVal2 = aya_read_customizer_option('aya_colors_buttonbackgroundgradientbottom', null);
	if ( !empty( $colorVal1 ) && !empty( $colorVal2 ) ) {
		// add buttons background color
		$custom_css .= aya_generate_css3_gradient('input[type="submit"],button,.btn,#container .button', 
			$colorVal1, $colorVal2);

		// add buttons hover background color
		$custom_css .= aya_generate_css3_gradient('input[type="submit"]:hover,button:hover,.btn:hover,#container .button:hover', 
			$colorVal2, $colorVal1);
	}

	$colorVal = aya_read_customizer_option('aya_colors_postboxes_background', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .author-icon > a, .clock-icon, .aside-icon > a, .audio-icon > a, .comments-icon > a, .gallery-icon > a, .image-icon > a, .link-icon > a, .quote-icon > a, .video-icon > a, .edit-icon > a, .categories-wrapper > a, .tags-wrapper > a{background-color: '.$colorVal.'; }';
	}

	$colorVal = aya_read_customizer_option('aya_colors_postboxes_textcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .clock-icon {color: '.$colorVal.'; }';
	}

	$colorVal = aya_read_customizer_option('aya_colors_postboxes_linkcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .author-icon > a, .aside-icon > a, .audio-icon > a, .comments-icon > a, .gallery-icon > a, .image-icon > a, .link-icon > a, .quote-icon > a, .video-icon > a, .edit-icon > a, .categories-wrapper > a, .tags-wrapper > a{color: '.$colorVal.'; }';
	}

	$colorVal = aya_read_customizer_option('aya_colors_postboxes_linkhovercolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .author-icon > a:hover, .aside-icon > a:hover, .audio-icon > a:hover, .comments-icon > a:hover, .gallery-icon > a:hover, .image-icon > a:hover, .link-icon > a:hover, .quote-icon > a:hover, .video-icon > a:hover, .edit-icon > a:hover, .categories-wrapper > a:hover, .tags-wrapper > a:hover{color: '.$colorVal.'; }';
	}


	
	$colorVal = aya_read_customizer_option('aya_colors_footerbackground', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #footer-main{background-color: '.$colorVal.'; }';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_footertextcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #footer-main, .footer-title {color:'.$colorVal.';}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_footerlinkcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #footer-main a {color:'.$colorVal.';}';
		
	}

	$colorVal = aya_read_customizer_option('aya_colors_footerlinkhovercolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #footer-main a:hover {color:'.$colorVal.';}';
		
	}

	$colorVal = aya_read_customizer_option('aya_slider_titlecolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .ia-container .slide h2 {color:'.$colorVal.';}';
		
	}

	$colorVal = aya_read_customizer_option('aya_slider_textcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .ia-container .slide {color:'.$colorVal.';}';
		
	}

	$colorVal = aya_read_customizer_option('aya_slider_linkcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .ia-container .slide a {color:'.$colorVal.';}';
		
	}

	$colorVal = aya_read_customizer_option('aya_slider_linkhovercolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .ia-container .slide a:hover {color:'.$colorVal.';}';
		
	}

	// Large Resolution
	$custom_css .= ' @media screen and (min-width: 800px) { ';
	
	if ( $isBoxedLayoutSelected ) {
	
		$custom_css .= ' #body-content-wrapper{margin-left:30px;margin-right:30px;}';
		
		$custom_css .= ' #header-main-fixed{width:auto;left:0;right:0;margin-left:30px;margin-right:30px;}';
	}

	// menu colors
	$colorVal = aya_read_customizer_option('aya_colors_menutextcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain > div > ul > li > a {color:'.$colorVal.';}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_menuhovertextcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain > div > ul > .current-menu-item > a, #navmain > div > ul > .current-menu-ancestor > a, #navmain > div > ul > li > a:hover {color:'.$colorVal.';}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_menudropdownbackgroundcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain ul ul {background-color: '.$colorVal.';}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_menudropdowntextcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain ul ul a {color: '.$colorVal.';}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_menuhoverdropdownbackground', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain ul ul li:hover > a {background-color:'.$colorVal.';}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_menuhoverdropdowntextcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain ul ul li:hover > a {color:'.$colorVal.';}';
	}

	$colorVal = aya_read_customizer_option('aya_header_logo_width_large', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #header-logo img {width:'.$colorVal.'px;height:auto;}';
	}

	$custom_css .= ' }'; // end of @media screen and (min-width: 800px)
	
	// Medium Resolution
	$custom_css .= ' @media screen and (max-width: 799px) {';

	if ( $isBoxedLayoutSelected ) {
	
		$custom_css .= ' #body-content-wrapper{margin-left:20px;margin-right:20px;}';
		
		$custom_css .= ' #header-main-fixed{width:auto;left:0;right:0;margin-left:20px;margin-right:20px;}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_menudropdownbackgroundcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain div > ul {background-color:'.$colorVal.';}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_menudropdowntextcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain div > ul a {color:'.$colorVal.' !important;}';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_menuhoverdropdowntextcolor', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain ul a:hover {color:'.$colorVal.' !important;} ';
	}
	
	$colorVal = aya_read_customizer_option('aya_colors_menuhoverdropdownbackground', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #navmain ul a:hover {background-color:'.$colorVal.' !important;}';
	}
	
	$colorVal = aya_read_customizer_option('aya_header_logo_width_medium', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #header-logo img {width:'.$colorVal.'px;height:auto;}';
	}

	$custom_css .= ' }'; // end of @media screen and (max-width: 799px)
	
	// Small Resolution (used only if boxed layout is selected)
	$custom_css .= ' @media screen and (max-width: 360px) {';
	
		if ( $isBoxedLayoutSelected ) {
	
		$custom_css .= ' #body-content-wrapper{margin-left:10px;margin-right:10px;}';
		
		$custom_css .= ' #header-main-fixed{width:auto;left:0;right:0;margin-left:10px;margin-right:10px;}';
		
				}
		
	$colorVal = aya_read_customizer_option('aya_header_logo_width_small', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' #header-logo img {width:'.$colorVal.'px;height:auto;}';
	}

	$custom_css .= ' }'; // end of @media screen and (max-width: 360px)

	
	// Extra Large Resolution(used only if boxed layout is selected)
	$custom_css .= ' @media screen and (min-width: 1200px) {';
	
		if ( $isBoxedLayoutSelected ) {
	
		$custom_css .= ' #body-content-wrapper{margin:0 auto;width:1180px;}';
		
		$custom_css .= ' #header-main-fixed{margin:0 auto;width:1180px;}';
		
		}
	
	$colorVal = aya_read_customizer_option('aya_header_logo_width_extralarge', null);
		if ( !empty( $colorVal ) ) {
			$custom_css .= ' #header-logo img {width:'.$colorVal.'px;height:auto;}';
		}

$custom_css .= ' }'; // end of @media screen and (min-width: 1200px)

	
	if ( $isBoxedLayoutSelected ) {
	
		$custom_css .= ' #body-content-wrapper{box-shadow: 0 0 10px #555555;}';
	}
	
	// add woocommerce additional classes
	if ( !aya_display_woocommerce_sidebar_enabled() ) {

		$custom_css .= " #container {width:96%;}";
	}

	if ( aya_read_customizer_option('aya_general_sidebarinleft', 0) == 1 ) {

		$custom_css .= ' #main-content, #container {float:right;} #sidebar {float:left;}';
	}

	$colorVal = aya_read_customizer_option('aya_slider_width_large', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .ia-container {width:'.$colorVal.'px;}';
	}

	$colorVal = aya_read_customizer_option('aya_slide_width_large', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .ia-container figure {width:'.$colorVal.'px;}';
	}

	$colorVal = aya_read_customizer_option('aya_slide_piece_width_large', null);
	if ( !empty( $colorVal ) ) {
		$custom_css .= ' .ia-container figure {left:'.$colorVal.'px;}';
	}

	$custom_css .= ' @media screen and (max-width: 720px) {';

		$colorVal = aya_read_customizer_option('aya_slider_width_medium', null);
		if ( !empty( $colorVal ) ) {
			$custom_css .= ' .ia-container {width:'.$colorVal.'px;}';
		}

		$colorVal = aya_read_customizer_option('aya_slide_width_medium', null);
		if ( !empty( $colorVal ) ) {
			$custom_css .= ' .ia-container figure {width:'.$colorVal.'px;}';
		}

		$colorVal = aya_read_customizer_option('aya_slide_piece_width_medium', null);
		if ( !empty( $colorVal ) ) {
			$custom_css .= ' .ia-container figure {left:'.$colorVal.'px;}';
		}

	$custom_css .= '}';

	$custom_css .= ' @media screen and (max-width: 520px) {';

		$colorVal = aya_read_customizer_option('aya_slider_width_small', null);
		if ( !empty( $colorVal ) ) {
			$custom_css .= ' .ia-container {width:'.$colorVal.'px;}';
		}

		$colorVal = aya_read_customizer_option('aya_slide_width_small', null);
		if ( !empty( $colorVal ) ) {
			$custom_css .= ' .ia-container figure {width:'.$colorVal.'px;}';
		}

		$colorVal = aya_read_customizer_option('aya_slide_piece_width_small', null);
		if ( !empty( $colorVal ) ) {
			$custom_css .= ' .ia-container figure {left:'.$colorVal.'px;}';
		}

	$custom_css .= '}';

	wp_add_inline_style( 'aya-style', $custom_css );
}

// add testimonial custom post format
add_action( 'init', 'aya_register_cpt_testimonial' );

// add portfolio post format
add_action( 'init', 'aya_register_cpt_portfolio' );

// add client custom post format
add_action( 'init', 'aya_register_cpt_client' );

$testimonials_key = "testimonial";
$testimonials_meta_boxes = array( "person-name" 		=> array( "name" 		=> "person-name",
															      "title"	    => "Person's Name",
															      "description" => "Enter the name of the person who gave you the testimonial."
															),
								 "position" 		    => array( "name" 		=> "position",
															      "title" 		=> "Position in Company",
															      "description" => "Enter their position in their specific company."),
															      "company" => array( "name" 	    => "company",
																				      "title" 	    => "Company Name",
																				      "description" => "Enter the client Company Name"
																				),
								 "link" 				=> array( "name"  		=> "link",
																  "title" 		=> "Client Link",
																  "description" => "Enter the link to client's site, or you can enter the link to your portfolio page where you have the client displayed."
																 ),
								);
 

 
add_action( 'admin_menu', 'aya_testimonials_create_meta_box' );
add_action( 'save_post', 'aya_testimonials_save_meta_box' );

add_action( 'admin_init', 'aya_portfolio_meta_box' );
add_action( 'save_post', 'aya_save_project_link' );
add_filter( 'manage_edit-project_columns', 'aya_project_edit_columns' );
add_action( 'manage_project_posts_custom_column', 'aya_project_custom_columns' );

$clients_key = "client";
$clients_meta_boxes = array( "link" 				=> array( "name"  		=> "link",
															  "title" 		=> "Client Link",
															  "description" => "Enter the link of client's website"
															 ),
							);

add_action( 'admin_menu', 'aya_clients_create_meta_box' );
add_action( 'save_post', 'aya_clients_save_meta_box' );
add_filter( 'manage_edit-client_columns', 'aya_clients_edit_columns' );
add_action( 'manage_client_posts_custom_column', 'aya_clients_custom_columns' );

/**
 * Register Testimonial custom post formats
 */
function aya_register_cpt_testimonial() {

	$labels = array( 
        'name' 				 => __( 'Testimonials', 'aya' ),
        'singular_name' 	 => __( 'testimonial', 'aya' ),
        'add_new' 			 => __( 'Add New', 'aya' ),
        'add_new_item' 		 => __( 'Add New testimonial', 'aya' ),
        'edit_item' 		 => __( 'Edit testimonial', 'aya' ),
        'new_item' 			 => __( 'New testimonial', 'aya' ),
        'view_item' 		 => __( 'View testimonial', 'aya' ),
        'search_items' 		 => __( 'Search Testimonials', 'aya' ),
        'not_found' 		 => __( 'No testimonials found', 'aya' ),
        'not_found_in_trash' => __( 'No testimonials found in Trash', 'aya' ),
        'parent_item_colon'  => __( 'Parent testimonial:', 'aya' ),
        'menu_name' 		 => __( 'Testimonials', 'aya' ),
    );

    $args = array( 
        'labels' 			  => $labels,
        'hierarchical'  	  => false,     
        'supports' 			  => array( 'title',
										 'editor',
										 'excerpt',
										 'author',
										 'thumbnail',
										 'custom-fields',
										 'revisions'
										),     
        'public' 			  => true,
        'show_ui' 			  => true,
        'show_in_menu'  	  => true,
        'show_in_nav_menus'   => true,
        'publicly_queryable'  => true,
        'exclude_from_search' => false,
        'has_archive' 		  => true,
        'query_var' 		  => true,
        'can_export' 		  => true,
        'rewrite' 			  => true,
        'capability_type' 	  => 'post'
    );

    register_post_type( 'testimonial', $args );
}

/**
 * Create Testimonials Meta Box
 */
function aya_testimonials_create_meta_box() {

	global $testimonials_key;
 
	if( function_exists( 'add_meta_box' ) ) {
		
		add_meta_box( 'new-meta-boxes', ucfirst( $testimonials_key ) . ' Information', 'aya_testimonials_display_meta_box', 'testimonial', 'normal', 'high' );
	}
}

/**
 * Display Testimonials Meta Box
 */
function aya_testimonials_display_meta_box() {

	global $post, $testimonials_meta_boxes, $testimonials_key;
?>
 
	<div class="form-wrap">
<?php
		wp_nonce_field( plugin_basename( __FILE__ ), $testimonials_key . '_wpnonce', false, true );
	 
		foreach( $testimonials_meta_boxes as $meta_box ) {

			$data = get_post_meta($post->ID, $testimonials_key, true);
?>
	 
		<div class="form-field form-required">
			<label for="<?php echo $meta_box[ 'name' ]; ?>"><?php echo $meta_box[ 'title' ]; ?></label>
			<input type="text" name="<?php echo $meta_box[ 'name' ]; ?>" value="<?php echo (isset($data[ $meta_box[ 'name' ] ]) ? htmlspecialchars( $data[ $meta_box[ 'name' ] ] ) : ''); ?>" />
			<p>
				<?php echo $meta_box[ 'description' ]; ?>
			</p>
		</div>
	 
<?php	} ?>

	</div>
<?php
}

/**
 * Save Testimonials Meta Box
 */
function aya_testimonials_save_meta_box( $post_id ) {

	global $post, $testimonials_meta_boxes, $testimonials_key;
 
	foreach( $testimonials_meta_boxes as $meta_box ) {

		if ( isset($_POST[ $meta_box[ 'name' ] ]) ) {
			$data[ $meta_box[ 'name' ] ] = $_POST[ $meta_box[ 'name' ] ];
		}
	}
 
	if ( !isset($_POST[ $testimonials_key . '_wpnonce' ]) ) 
		return $post_id;

	if ( !wp_verify_nonce( $_POST[ $testimonials_key . '_wpnonce' ], plugin_basename(__FILE__) ) )
		return $post_id;
 
	if ( !current_user_can( 'edit_post', $post_id ))
		return $post_id;
 
	update_post_meta( $post_id, $testimonials_key, $data );
}

/**
 * Register Portfolio custom post format
 */
function aya_register_cpt_portfolio() {

	$labels = array( 
        'name' 				 => __( 'Project', 'aya' ),
        'singular_name' 	 => __( 'Project', 'aya' ),
        'add_new' 			 => __( 'Add New', 'aya' ),
        'add_new_item' 		 => __( 'Add New Project', 'aya' ),
        'edit_item' 		 => __( 'Edit Project', 'aya' ),
        'new_item' 			 => __( 'New Project', 'aya' ),
        'view_item' 		 => __( 'View Project', 'aya' ),
        'search_items' 		 => __( 'Search Projects', 'aya' ),
        'not_found' 		 => __( 'No projects found', 'aya' ),
        'not_found_in_trash' => __( 'No projects found in Trash', 'aya' ),
        'parent_item_colon'  => __( 'Parent Projects:', 'aya' ),
        'menu_name' 		 => __( 'Projects', 'aya' ),
    );
	
	$args = array( 
        'labels' 			  => $labels,
        'hierarchical'  	  => false,     
        'supports' 			  => array( 'title',
										 'editor',
										 'excerpt',
										 'author',
										 'thumbnail',
										 'custom-fields',
										 'revisions'
										),     
        'public' 			  => true,
        'show_ui' 			  => true,
        'show_in_menu'  	  => true,
        'show_in_nav_menus'   => true,
        'publicly_queryable'  => true,
        'exclude_from_search' => false,
        'has_archive' 		  => true,
        'query_var' 		  => true,
        'can_export' 		  => true,
        'rewrite' 			  => true,
        'capability_type' 	  => 'post'
    );
   
    register_post_type( 'project' , $args );
	
	
	register_taxonomy( "project-type",
					   array( "project" ),
					   array( "hierarchical" 	=> true,
							  "label" 			=> "Project Types",
							  "singular_label"  => "Project Type",
							  "rewrite"			=> true 
							 )
					  );
}

/**
 *	Add Portfolio Meta Box
 */
function aya_portfolio_meta_box() { 
    add_meta_box("projInfo-meta", "Project Options", "aya_portfolio_meta_options", "project", "side", "low"); 
} 
   
/**
 * Add Portfolio Meta Options
 */
function aya_portfolio_meta_options() { 
        global $post; 
        if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) {
		
			return $post_id;
		}
        $custom = get_post_custom( $post->ID );
		
		$projClient = '';
		if ( array_key_exists( "projClient", $custom ) ) {		
			$projClient = $custom["projClient"][0];
		}
?>
    <label>Client:</label><br />
	<input name="projClient" value="<?php echo $projClient; ?>" /> 
<?php

	$projCompany = '';
		if ( array_key_exists( "projCompany", $custom ) ) {		
			$projCompany = $custom["projCompany"][0];
		}
?>
	<br /><br />
    <label>Company:</label><br />
	<input name="projCompany" value="<?php echo $projCompany; ?>" />
	
<?php
		$link = '';
		if ( array_key_exists( "projLink", $custom ) ) {		
			$link = $custom["projLink"][0];
		}
?>
	<br /><br />
    <label>Link:</label><br />
	<input name="projLink" value="<?php echo $link; ?>" />
<?php 
}

function aya_save_project_link() { 
    global $post; 
     
    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) {
	
        return $post_id;

    } else {
	
		if ( array_key_exists( 'projClient', $_POST ) ) {
	
			update_post_meta( $post->ID, "projClient", $_POST["projClient"] );	
		}
		
		if ( array_key_exists( 'projCompany', $_POST ) ) {
	
			update_post_meta( $post->ID, "projCompany", $_POST["projCompany"] );	
		}

		if ( array_key_exists( 'projLink', $_POST ) ) {
	
			update_post_meta( $post->ID, "projLink", $_POST["projLink"] );	
		}
    }
}

function aya_project_edit_columns($columns) {

        $columns = array( 
            "cb" 			=> "<input type=\"checkbox\" />", 
            "title" 		=> "Project", 
            "description" 	=> "Description", 
            "link" 			=> "Link", 
            "type" 			=> "Type of Project", 
        ); 

        return $columns; 
}

function aya_project_custom_columns( $column ){ 
        global $post; 
        switch ($column) 
        { 
            case "description": 
                the_excerpt(); 
                break; 
            case "link": 
                $custom = get_post_custom(); 
                echo $custom["projLink"][0]; 
                break; 
            case "type": 
                echo get_the_term_list($post->ID, 'project-type', '', ', ',''); 
                break; 
        } 
}

/**
 * Register Client custom post format
 */
function aya_register_cpt_client() {

	$labels = array( 
        'name' 				 => __( 'Clients', 'aya' ),
        'singular_name' 	 => __( 'client', 'aya' ),
        'add_new' 			 => __( 'Add New', 'aya' ),
        'add_new_item' 		 => __( 'Add New client', 'aya' ),
        'edit_item' 		 => __( 'Edit client', 'aya' ),
        'new_item' 			 => __( 'New client', 'aya' ),
        'view_item' 		 => __( 'View client', 'aya' ),
        'search_items' 		 => __( 'Search Clients', 'aya' ),
        'not_found' 		 => __( 'No clients found', 'aya' ),
        'not_found_in_trash' => __( 'No clients found in Trash', 'aya' ),
        'parent_item_colon'  => __( 'Parent client:', 'aya' ),
        'menu_name' 		 => __( 'Clients', 'aya' ),
    );

    $args = array( 
        'labels' 			  => $labels,
        'hierarchical'  	  => false,     
        'supports' 			  => array( 'title',
										'thumbnail',
										 'revisions'
										),     
        'public' 			  => true,
        'show_ui' 			  => true,
        'show_in_menu'  	  => true,
        'show_in_nav_menus'   => false,
        'publicly_queryable'  => true,
        'exclude_from_search' => true,
        'has_archive' 		  => false,
        'query_var' 		  => true,
        'can_export' 		  => true,
        'rewrite' 			  => true,
        'capability_type' 	  => 'post'
    );

    register_post_type( 'client', $args );
}

function aya_clients_create_meta_box() {

	global $clients_key;
 
	if( function_exists( 'add_meta_box' ) ) {
		
		add_meta_box( 'new-meta-boxes', ucfirst( $clients_key ) . ' Information', 'aya_clients_display_meta_box', 'client', 'normal', 'high' );
	}
}

function aya_clients_save_meta_box( $post_id ) {

	global $post, $clients_meta_boxes, $clients_key;
 
	foreach( $clients_meta_boxes as $meta_box ) {

		if ( isset($_POST[ $meta_box[ 'name' ] ]) ) {
			$data[ $meta_box[ 'name' ] ] = $_POST[ $meta_box[ 'name' ] ];
		}
	}
 
	if ( !isset($_POST[ $clients_key . '_wpnonce' ]) ) 
		return $post_id;

	if ( !wp_verify_nonce( $_POST[ $clients_key . '_wpnonce' ], plugin_basename(__FILE__) ) )
		return $post_id;
 
	if ( !current_user_can( 'edit_post', $post_id ))
		return $post_id;
 
	update_post_meta( $post_id, $clients_key, $data );
}

function aya_clients_display_meta_box() {

	global $post, $clients_meta_boxes, $clients_key;
?>
 
	<div class="form-wrap">
<?php
		wp_nonce_field( plugin_basename( __FILE__ ), $clients_key . '_wpnonce', false, true );
	 
		foreach( $clients_meta_boxes as $meta_box ) {

			$data = get_post_meta($post->ID, $clients_key, true);
?>
	 
		<div class="form-field form-required">
			<label for="<?php echo $meta_box[ 'name' ]; ?>"><?php echo $meta_box[ 'title' ]; ?></label>
			<input type="text" name="<?php echo $meta_box[ 'name' ]; ?>" value="<?php echo (isset($data[ $meta_box[ 'name' ] ]) ? htmlspecialchars( $data[ $meta_box[ 'name' ] ] ) : ''); ?>" />
			<p>
				<?php echo $meta_box[ 'description' ]; ?>
			</p>
		</div>
	 
<?php	} ?>

	</div>
<?php
}

function aya_clients_edit_columns($columns) {

        $columns = array( 
            "cb" 			=> "<input type=\"checkbox\" />",
			"logo"			=> "Client Logo",  
			"title" 		=> "Client",		
            "link" 			=> "Link",
        ); 

        return $columns; 
}

function aya_clients_custom_columns( $column ){ 
	global $post; 
	switch ($column) 
	{ 
		case "logo": 
			the_post_thumbnail( array(100,'auto') );
			break;			
		case "link":
			$custom = get_post_meta($post->ID, 'client', true);		
			if ( $custom != null && array_key_exists('link', $custom) ) {
			
				echo $custom['link'];
			}
			break; 
	} 
}

function landshaftingpro_header_style() {

    $header_text_color = get_header_textcolor();

    if ( ! has_header_image()
        && ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color
             || 'blank' === $header_text_color ) ) {

        return;
    }

    $headerImage = get_header_image();
?>
    <style type="text/css">
        <?php if ( has_header_image() ) : ?>

                #header-main-fixed {background-image: url("<?php echo esc_url( $headerImage ); ?>");}

        <?php endif; ?>

        <?php if ( get_theme_support( 'custom-header', 'default-text-color' ) !== $header_text_color
                    && 'blank' !== $header_text_color ) : ?>

                #header-main-fixed {color: #<?php echo esc_attr( $header_text_color ); ?>;}

        <?php endif; ?>
    </style>
<?php
}

?>