<?php get_header(); ?>

<div id="home-content-wrapper">
	<?php
		/**
		 * Displays content (latest posts or single page content) and sidebar in website homepage
		 * Note:
		 * The content will be displayed if Admin Panel -> Appearance -> Theme Options -> Home -> 'Display Latest Posts' is checked
		 * The sidebar will be displayed if Admin Panel -> Appearance -> Theme Options -> Home -> 'Display Sidebar' is checked
		 */
	?>
	<?php $displayLatestPosts = aya_display_latest_posts_in_homepage(); ?>
	<?php $displaySidebar = aya_display_sidebar_in_homepage(); ?>

	<div id="main-content-wrapper">
		<?php if ( $displayLatestPosts || $displaySidebar ) : ?>
		
			<div id="<?php if ($displaySidebar) :
								echo 'main-content';
						   else:
								echo 'main-content-full';
						   endif; ?>">

				<?php if ( $displayLatestPosts && have_posts() ) :
			
							// starts the loop
							while ( have_posts() ) :
				
								the_post();
	
								/*
								 * Include the post format-specific template for the content.
								 */
								get_template_part( 'content', get_post_format() );
							
							endwhile;
				
							the_posts_pagination( array(
		                        'prev_next' => '',
		                    ) );
 					   endif; ?>
			</div>
		<?php endif; ?>
	
		<?php if ( $displaySidebar ) :
		
					get_sidebar();
	
			  endif; ?>
	</div>
	<?php
		/**
		 * Display widgets dragged in 'Homepage Above Columns' widget area
		 */
	?>
	<?php $homeAboveColsStyle = '';
      $homeColsStyle = '';
      $homeBelowColsStyle = '';

	$aboveColsBack = aya_read_customizer_option('aya_homepage_abovecolsback', null);
	if ( !empty($aboveColsBack) ) :
		
		$homeAboveColsStyle .= "background-image: url('$aboveColsBack');";

		if ( aya_read_customizer_option('aya_homepage_abovecolsback_fixed', 0) == 1 ) :
			$homeAboveColsStyle .= 'background-position:left top;background-attachment: fixed;animation: 1s ease 0s normal none 1 running none;background-repeat:repeat;';
		endif;

        endif;

	$colsBack = aya_read_customizer_option('aya_homepage_colsback', null);
	if ( !empty($colsBack) ) :
		
		$homeColsStyle .= "background-image: url('$colsBack');";

		if ( aya_read_customizer_option('aya_homepage_colsback_fixed', 0) == 1 ) :
			$homeColsStyle .= 'background-position:left top;background-attachment: fixed;animation: 1s ease 0s normal none 1 running none;background-repeat:repeat;';
		endif;

        endif;

	$belowColsBack = aya_read_customizer_option('aya_homepage_belowcolsback', null);
	if ( !empty($belowColsBack) ) :
		
		$homeBelowColsStyle .= "background-image: url('$belowColsBack');";

		if ( aya_read_customizer_option('aya_homepage_belowcolsback_fixed', 0) == 1 ) :
			$homeBelowColsStyle .= 'background-position:left top;background-attachment: fixed;animation: 1s ease 0s normal none 1 running none;background-repeat:repeat;';
		endif;

        endif;
?>
    <div id="top-widget"
        <?php if ($homeAboveColsStyle != '') :
        
                    echo 'style="'.$homeAboveColsStyle.'"';
              endif; ?>>
		<div id="top-widget-inner">
			<?php dynamic_sidebar( 'homepage-top-widget-area' ); ?>
			<div class="clear">
			</div>
		</div>
	</div>
	
	<?php
		/**
		 * Display widgets dragged in 'Homepage Columns' widget areas
		 * Note: The number of columns is defined in:
		 * Admin Panel -> Appearance -> Theme Options -> Home -> 'Number of Columns'
		 */
	?>
	<div id="home-cols"
        <?php if ($homeColsStyle != '') :
        
                    echo 'style="'.$homeColsStyle.'"';
              endif; ?>>
		<div id="home-cols-inner">
			<?php $numberOfColumns = aya_getNumberOfHomePageColumns();
				  $chars = array( 'a', 'b', 'c', 'd' );
	
				  for ($i = 1; $i <= $numberOfColumns; ++$i) : ?>
	
						<div class="col col<?php echo $numberOfColumns ?><?php echo $chars[ $i - 1 ] ?>">
							<?php dynamic_sidebar( 'homepage-column-'.$i.'-widget-area' ); ?>
						</div>
	
			<?php endfor; ?>
			<div class="clear">
			</div>
		</div>
	</div>

	<?php
		/**
		 * Display widgets dragged in 'Homepage Below Columns' widget area
		 */
	?>
	<div class="bottom-widget"
        <?php if ($homeBelowColsStyle != '') :
        
                    echo 'style="'.$homeBelowColsStyle.'"';
              endif; ?>>
		<div id="bottom-widget-inner">
			<?php dynamic_sidebar( 'homepage-bottom-widget-area' ); ?>
			<div class="clear">
			</div>
		</div>
	</div>
</div>
<?php get_footer(); ?>