<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the "body-content-wrapper" div and all content after.
 *
 * @package WordPress
 * @subpackage tBlogging
 */
?>

			<a href="#" class="scrollup"></a>
			<footer id="footer-main">
				<div id="footer-content-wrapper">				
					<?php
						/**
						 * Display widgets dragged in 'Footer Columns' widget areas
						 * Note: The number of columns is defined in:
						 * Admin Panel -> Appearance -> Theme Options -> Footer -> 'Number of Columns'
						 */
					?>				
					<?php $numberOfColumns = aya_getNumberOfFooterColumns();
						  $displayFooterCol1 = ($numberOfColumns >= 1);
						  $displayFooterCol2 = ($numberOfColumns >= 2);
						  $displayFooterCol3 = ($numberOfColumns >= 3);
						  $displayFooterCol4 = ($numberOfColumns >= 4);
						  
						  /**
						   * Display 'Footer Column #1' Widget Area
						   */
						  if ( $displayFooterCol1 ) : ?>
						  
								<div class="col col<?php echo $numberOfColumns ?>a">
								
									<?php if ( !dynamic_sidebar( 'footer-column-1-widget-area' ) ) :
									
												/**
												 * Display Footer Column #1 Default Content
												 */
												the_widget( 'WP_Widget_Pages',
															array(),
															array ('before_title' => '<h3 class="footer-title">',
																   'after_title' => '</h3><div class="footer-after-title"></div>')
																  );							
										endif; ?>
								</div>

						  <?php endif;
						  
						  /**
						   * Display 'Footer Column #2' Widget Area
						   */
						  if ( $displayFooterCol2 ) : ?>
						  
								<div class="col col<?php echo $numberOfColumns ?>b">
								
									<?php if ( !dynamic_sidebar( 'footer-column-2-widget-area' ) ) :
									
												/**
												 * Display Footer Column #2 Default Content
												 */
												the_widget( 'WP_Widget_Recent_Posts',
															array(
																	'show_date' => '1',
																	'number' => '10'
																  ),
															array(
																   'before_title' => '<h3 class="footer-title">',
																   'after_title' => '</h3><div class="footer-after-title"></div>',
																 )
															);
																			
											endif; ?>
								</div>

						  <?php endif;
						  
						  /**
						   * Display 'Footer Column #3' Widget Area
						   */
						  if ( $displayFooterCol3 ) : ?>
						  
								<div class="col col<?php echo $numberOfColumns ?>c">
								
									<?php if ( !dynamic_sidebar( 'footer-column-3-widget-area' ) ) :
									
												/**
												 * Display Footer Column #3 Default Content
												 */
												the_widget( 'WP_Widget_Recent_Comments',
															array(
																	'number' => '10'
																  ),
															array(
																	'before_title' => '<h3 class="footer-title">',
																	'after_title' => '</h3><div class="footer-after-title"></div>',
																  )
														   );
																			
										endif; ?>
								</div>

						  <?php endif;
						  
						  /**
						   * Display 'Footer Column #4' Widget Area
						   */
						  if ( $displayFooterCol4 ) : ?>
						  
								<div class="col col<?php echo $numberOfColumns ?>d">
								
									<?php if ( !dynamic_sidebar( 'footer-column-4-widget-area' ) ) :
									
												/**
												 * Display Footer Column #4 Default Content
												 */
												the_widget( 'aya_FollowUsOnFacebook_Widget',
															array(
																	'title' => 'Follow us on Facebook',
																  )
														   );
												the_widget( 'aya_FollowUsOnTwitter_Widget',
															array(
																	'title' => 'Follow us on Twitter',
																  )
														   );
												the_widget( 'aya_FollowOurRssFeeds_Widget',
															array(
																	'title' => 'Follow Our Rss Feeds',
																  )
														  );
				
										endif; ?>
								</div>

						  <?php endif; ?>

					<div class="clear">
					</div>
					
					<?php
						/**
						 * Display 'Footer Bottom' Widget Area
						 */
					?>
					<div id="footer-bottom">
						<?php dynamic_sidebar( 'footer-bottom-widget-area' ); ?>
					</div>

					<?php
						/**
						 * Display Social Icon in Footer
						 * Note: the icons will be displayed if
						 * Admin Panel -> Appearance -> Theme Options -> Footer -> 'Display Social Icons' is checked
						 */
					?>
					<div class="clear">
						<?php aya_show_footer_social_sites( '<div id="fsocial">', '</div>' ); ?>
					</div>

					<div class="clear">
					</div>
					
					<?php if ( aya_should_display_footer_menu() ) : ?>

							<nav id="footer-menu">
								<?php wp_nav_menu( array( 'theme_location' => 'footer', ) ); ?>
							</nav>

							<div class="clear">
							</div>

					<?php endif; ?>
					
					<?php
						/**
						 * Display Copyright Text, set in
						 * Admin Panel -> Appearance -> Theme Options -> Footer -> 'Copyright Text'
						 */
					?>
					<div id="copyright">
						<?php aya_show_copyright_text(); ?>
					</div><!-- #copyright -->
				</div><!-- #footer-content-wrapper -->
			</footer><!-- #footer-main -->
		</div><!-- #body-content-wrapper -->
		<?php wp_footer(); ?>
	</body>
</html>