<?php
/**
 * The default template for displaying content
 *
 * Used for single, index, archive, and search contents.
 *
 * @package WordPress
 * @subpackage tBlogging
 *
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if ( is_single() ) : ?>

			<h1 class="entry-title">
				<?php the_title(); ?>
			</h1>

	<?php else :
			
			echo '<h1 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark" title="'.get_the_title().'">'.get_the_title().'</a></h1>';
	
		  endif; ?>

	<div class="before-content">
		<?php if ( !is_front_page() || is_home() ) : ?>
			<?php aya_author_link(); ?>
			<?php if ( !is_single() && get_the_title() === '' ) : ?>

					<span class="clock-icon">
						<a href="<?php the_permalink(); ?>" rel="bookmark">
							<time datetime="<?php the_time( 'Y-m-d' ); ?>"><?php the_time(get_option('date_format')); ?></time>
						</a>
					</span><!-- .clock-icon -->
		
			<?php else : ?>

					<span class="clock-icon">
						<time datetime="<?php the_time( 'Y-m-d' ); ?>"><?php the_time(get_option('date_format')); ?></time>
					</span><!-- .clock-icon -->
				
			<?php endif; ?>
		<?php endif; ?>
		
		<?php $format = get_post_format();
				if ( current_theme_supports( 'post-formats', $format ) ) :
					printf( '<span class="%1$s-icon"> <a href="%2$s">%3$s</a></span>',
							$format,							
							esc_url( get_post_format_link( $format ) ),
							get_post_format_string( $format )
						);
				endif;
		?>
		
		<?php if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>

				<span class="comments-icon">
					<?php comments_popup_link(__( 'No Comments', 'aya' ), __( '1 Comment', 'aya' ), __( '% Comments', 'aya' ), '', __( 'Comments are closed.', 'aya' )); ?>
				</span><!-- .comments-icon -->
		<?php endif; ?>

		<?php if ( ! post_password_required() ) : ?>

			<?php if ( has_category() ) : ?>
					<p class="categories-wrapper">
						<?php the_category( ' ' ) ?>
					</p><!-- .categories-wrapper -->
			<?php endif; ?>
		
			<?php if ( has_tag() ) : ?>
					<p class="tags-wrapper">				
						<?php echo get_the_tag_list( '', ' ','' ); ?>
					</p><!-- .tags-wrapper -->
			<?php endif; ?>

		<?php endif; /* ! post_password_required() */ ?>

		<?php edit_post_link( __( 'Edit', 'aya' ), '<span class="edit-icon">', '</span>' ); ?>
		
	</div><!-- .before-content -->

	<?php if ( is_single() ) : ?>

				<div class="content">
					<?php // show widget before single post content
						  dynamic_sidebar( 'before-single-post-content-widget-area' ); ?>
	
					<?php
						if ( has_post_thumbnail() ) {

							the_post_thumbnail('full');
						}
						the_content( __( 'Read More...', 'aya' ) );
					?>
					
					<?php // show widget after single post content
						  dynamic_sidebar( 'after-single-post-content-widget-area' ); ?>
						  
				</div>

	<?php else : ?>

				<div class="content">
					<?php
						// Display Thumbnails if enabled from settings and if thumbnail is set for the post
						if ( has_post_thumbnail() ) {
							echo '<a href="'.get_permalink().'" title="'.get_the_title().'">';
							the_post_thumbnail('full');
							echo '</a>';
						}
						the_content( __( 'Read More', 'aya' ) );
					?>
				</div><!-- .content -->

	<?php endif; ?>


	<div class="after-content">
	</div>
	
	<?php if ( !is_single() ) : ?>
				<div class="separator">
				</div>
	<?php endif; ?>
</article><!-- #post-## -->

<?php	// check if show social sharing box is set to be shown after single posts
		if ( is_single() && aya_show_social_sharing_after_single_post_enabled() ) :

			get_template_part( 'social-sharing-box' );
		
		endif;

		// check if show author box is set to be shown after single posts
		if ( is_single() && aya_show_author_info_after_single_post_enabled() ) :
		
			get_template_part( 'author-box' );
		
		endif;
?>