<?php
/**
 * The default template for displaying page content
 *
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<h1 class="entry-title"><?php the_title(); ?></h1>

	<div class="page-content">
		<?php
			if ( has_post_thumbnail() ) {

				the_post_thumbnail('full');
			}
			the_content( __( 'Read More...', 'aya' ) );
		?>
	</div>
	<div class="page-after-content">
		
		<?php aya_author_link(); ?>
<?php if ('open' == $post->comment_status) : ?>
			<?php if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>

<span class="comments-icon">
			<?php comments_popup_link(__( 'No Comments', 'aya' ), __( '1 Comment', 'aya' ), __( '% Comments', 'aya' ), '', __( 'Comments are closed.', 'aya' )); ?>
		</span>
<?php endif; ?>
		<?php endif; ?>
		<?php edit_post_link( __( 'Edit', 'aya' ), '<span class="edit-icon">', '</span>' ); ?>
	</div>
</article>

<?php	// check if show social sharing box is set to be shown after single pages
		if ( aya_show_social_sharing_after_single_page_enabled() ) :

			get_template_part( 'social-sharing-box' );
		
		endif;

		// check if show author box is set to be shown after single pages
		if ( aya_show_author_info_after_single_page_enabled() ) :
		
			get_template_part( 'author-box' );
		
		endif;
?>