<?php
/**
 * The template for displaying author info box
 *
 * Used for single posts and costom post formats contents.
 *
 * Note: before including it check if is single and if show author box is set to be shown after single posts
 *
 */
?>
<h4 class="author-title"><?php _e( 'About the Author', 'aya' ); ?></h4>
<div class="author-after-title">
</div>
<div class="author-info-box">
	<div class="author-avatar">
		<?php echo get_avatar( get_the_author_meta('email'), '90' ); ?>
	</div><!-- .author-avatar -->
	<p>
		<?php $authorFirstName = get_the_author_meta( 'user_firstname' );
			  $authorLastName = get_the_author_meta( 'user_lastname' );
			  if ( ($authorFirstName && $authorFirstName != '')
					|| ($authorLastName && $authorLastName != '') ) : ?>
		
			<?php echo $authorFirstName; ?> <?php echo $authorLastName; ?> (<?php the_author_posts_link(); ?>)
		
		<?php else : ?>
		
			<?php the_author_posts_link(); ?>
		
		<?php endif; ?>
	</p>
	<?php $authorDescription = get_the_author_meta( 'user_description' );
		  if ( $authorDescription && $authorDescription != '' ) : ?>

			<p><?php echo $authorDescription; ?></p>
	
	<?php endif; ?>
	
	<?php $userUrl = get_the_author_meta('user_url');
		  if ( $userUrl != null && $userUrl != '' ) : ?>
		  
		  <p><?php _e( 'Website', 'aya' ); ?>: <a href="<?php the_author_meta('user_url');?>" title="<?php _e( 'Website', 'aya' ); ?>" target="_blank"><?php echo $userUrl; ?></a></p>
		  
	<?php endif; ?>
	
	<ul class="social-widget">		
		<?php $facebook_profile = get_the_author_meta( 'facebook_profile' );
			if ( $facebook_profile && $facebook_profile != '' ) : ?>
				<li><a href="<?php echo esc_url($facebook_profile); ?>" title="<?php _e( 'Follow us on Facebook', 'aya' ); ?>" class="facebook32" target="_blank"></a></li>
		<?php endif; ?>
		
		<?php $google_profile = get_the_author_meta( 'google_profile' );
			if ( $google_profile && $google_profile != '' ) : ?>
				<li><a href="<?php echo esc_url($google_profile); ?>" title="<?php _e( 'Follow us on Google+', 'aya' ); ?>" class="google32" target="_blank"></a></li>
		<?php endif; ?>
		
		<?php $twitter_profile = get_the_author_meta( 'twitter_profile' );
			if ( $twitter_profile && $twitter_profile != '' ) : ?>
				<li><a href="<?php echo esc_url($twitter_profile); ?>" title="<?php _e( 'Follow us on Twitter', 'aya' ); ?>" class="twitter32" target="_blank"></a></li>
		<?php endif; ?>
		
		<?php $linkedin_profile = get_the_author_meta( 'linkedin_profile' );
			if ( $linkedin_profile && $linkedin_profile != '' ) : ?>
				<li><a href="<?php echo esc_url($linkedin_profile); ?>" title="<?php _e( 'Follow us on LinkedIn', 'aya' ); ?>" class="linkedin32" target="_blank"></a></li>
		<?php endif; ?>

		<?php $rss_url = get_the_author_meta( 'rss_url' );
			if ( $rss_url && $rss_url != '' ) : ?>
				<li><a href="<?php echo esc_url($rss_url); ?>" title="<?php _e( 'Follow our RSS Feeds', 'aya' ); ?>" class="rss32" target="_blank"></a></li>
		<?php endif; ?>
	</ul><!-- .social-widget -->
	
	<div class="clear">
	</div>
</div>