<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage tBlogging
 */

get_header(); ?>

<div id="main-content-wrapper">
	<?php
		$showSidebarForPosts = aya_read_customizer_option('aya_general_showsidebar_forposts', 1) == 1;
		if ( $showSidebarForPosts ) { ?>

			<div id="main-content">

	<?php } else { ?>

			<div id="main-content-full">

	<?php } ?>

	<?php $title = sprintf( __( 'Tag Archives: %s', 'aya' ), single_tag_title( '', false ) ); ?>
	<h1 class="entry-title"><?php echo $title; ?></h1>

	<?php if ( have_posts() ) : ?>

				<?php
				// Start the Loop.
				while ( have_posts() ) :

					the_post();

					/*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'content', get_post_format() );

				// End the loop.
				endwhile;

				the_posts_pagination( array(
                        'prev_next' => '',
                    ) );

		  // If no content, include the "No posts found" template.
		  else :

				// if no content is loaded, show the 'not found' template
				get_template_part( 'content', 'none' );
			
		  endif; ?>
	</div><!-- #main-content -->

	<?php if ( $showSidebarForPosts ) {

			get_sidebar();

	  } ?>

</div><!-- #main-content-wrapper -->
<?php get_footer(); ?>