<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage tBlogging
 *
 */

get_header(); ?>
<div id="main-content-wrapper">
	<div id="main-content-full">
		<article>
			<h1 id="not-found-title">
				<?php $notFoundTitle = aya_read_customizer_option('aya_notfound_title', 'Error 404: Not Found'); ?>
				<?php echo $notFoundTitle; ?>
			</h1><!-- #not-found-title -->
			<div class="clear">
			</div>
			<div class="text-center">
			<?php $notFoundImage = aya_read_customizer_option('aya_notfound_image', get_stylesheet_directory_uri().'/images/404.png'); ?>
			<?php if ( !empty($notFoundImage) ) :
					
				echo "<img id='not-found-image' src='$notFoundImage' alt='$notFoundTitle' title='$notFoundTitle' />";

			endif; ?>
			</div><!-- .text-center -->
			<div class="clear">
			</div>
			<div class="text-center">
				<?php echo aya_read_customizer_option('aya_notfound_content', '<p>Sorry. The page you are looking for does not exist.</p>'); ?>
			</div><!-- .text-center -->
		</article>
	</div><!-- #main-content-full -->
</div><!-- #main-content-wrapper -->

<?php get_footer(); ?>